%% load data
  load dfullM_inc;  D=data; clear data; k=3; 
%% set H=1 to construct inequality constraints  
  H1=1;
%% dipendent variable
  scs=D(:,1); scf=D(:,2); 
  scf=ceil(scf/2); scs=ceil(scs/2);
  yv=(scf-1)*k+scs; n=size(yv,1); 
%% variabili esplicative
% set covariates
% education
%  ed=D(:,3)+2*D(:,4)+3*D(:,5); 
%  ed=(ed-mean(ed))/std(ed); 
%  D(:,3)=ed; D(:,4)=ed.^2; D(:,4)=ed.^3;
  V=D(:,3:13); vc=size(V,2);
  V=V-ones(n,1)*mean(V);    % center
%% marginal model
  lev=[k k]; Md=['g' 'g';'g' 'g';'l' 'g'];
  B=[eye(2); 1 1];
  [Ma,Co]=cofoba(lev,B,Md);
  G=hdes(lev,'g'*[1 1],B); G(:,1)=[]; H=Hmat(G);

%% starting values 
  f=tabel(yv-1)+0.1; sic=size(Co,1);
  eta=Co*log(Ma*f); beta=eta;
  X=model(V(1,:)); xc=size(X,2);  
  beta=[beta;zeros(xc-sic,1)]; P=zeros(9,n);
  C=zeros(0,xc); D1=C; D2=C; 
  if H1==1, disp('sets inequality constraints')
  for is=1:n % cycle across individuals
      X=model(V(is,:)); 
      D1=[D1;X(5:6,:)]; D2=[D2;X(7:8,:)]; 
      if is==floor(is/36)*36, fprintf('-'); end      
  end
  D=[D1;D2];
  end
  fprintf('\n'); 
%% monotonicity only within first 2 rows
 % D=D1;
%% monotonicity only within last two rows   
 % D=D2;
%% equalities instead of inequalities 
 %  D=zeros(0,xc); 
 %  C=blkdiag(zeros(0,4),eye(4),zeros(0,24),eye(44));   
%% unconstrained model
%   C=zeros(0,xc); D=C;
%% independence within first two rows
 %  D=zeros(0,xc); 
 %  C=blkdiag(zeros(0,4),eye(2),zeros(0,2),zeros(0,24),eye(22),zeros(0,22));
%% independence within last two rows 
 %  D=zeros(0,xc); 
 %  C=blkdiag(zeros(0,4),zeros(0,2),eye(2),zeros(0,24),zeros(0,22),eye(22));  
%% ML estimation
   [LL,P,be,F] = macsil(yv,beta,lev,V,G,H,Co,Ma,C,D);
 %  [LL,be,F] = newmult(yv,V,G,Ma,Co,C,D,beta);
 %  [LL,be,F,P] = fiscor(yv,V,G,Co,Ma,D,beta);
  se=sqrt(diag(inv(F)));  % standard errors
  
