function  [p,q0,q1] = jocbar(T01,T12,w0,mod)
%         [p,q0,q1] = jocbar(T01,T12,w0,mod)
% - for the joint chibar distribution
% - computes the 2x2 table of probabilities 
% - by splitting at T01 by row and at T12 by col
% - T12 = inf if absent, weights for T01 in w0
% - if mod=1, p=P(1,1);

% - weights in row form of size h
 [i,h]=size(w0); 
 if h == 1,
   w=w0'; h=i; else, w=w0;
 end

% - initialize
  q0=zeros(h,1); q1=q0;
  
  for i=1:h,
   if w(i) > 0,
     gdl=i-1;
     if gdl == 0,
       q0(i)=1;
     else
       q0(i)=chi2cdf(T01,gdl);
     end
     gdl=h-i; 
     if gdl == 0,
       q1(i)=1;
     else
       q1(i)=chi2cdf(T12,gdl);
     end      %  gdl
   end        %  w>0
 end          %  for

 p(1,1)=w*(q0.*q1);
 p(1,2)=w*(q0.*(1-q1));
 p(2,1)=w*((1-q0).*q1);
 p(2,2)=w*((1-q0).*(1-q1));
 
% - for use with finv
  if  nargin == 4, p=p(1,1); end