function [X,Z] = hdes(lev,par,Gen)
%        [X,Z] = hdes(lev,par,Gen)
% constructs design matrix X and for a crossed 
% factorial model with number of levels in lev, 
% par may bg 'g' for GLIM or 'l' for consecutive, 
% G is binary matrix of hierarchical model, Z is 
% the design matrix for the complementary effects

% preliminaries
  k=length(lev); mal=max(lev);
  if length(par) ~= k,
    error('ckeck number of levels');
  end
  [G,R]=ghiera(Gen);
  ng=size(G(:,1),1); nr=length(R(:,1));
  I=eye(mal); u=ones(mal,1); 
  Eg=I(:,2:mal); El=tril(ones(mal)); 
  El=El(:,2:mal); X=[]; Z=zeros(prod(lev),0);
  X=ones(prod(lev),1);
 
% hierarchical components
  for ig=1:ng,
    gen=G(ig,:); 
    lv=lev(1); lr=1:lv; lc=1:lv-1;
    if gen(1) == 0,
      Xtemp=u(lr);
    else,
      if par(1) == 'g', Xtemp=Eg(lr,lc);
      else, Xtemp=El(lr,lc); 
      end
    end

    for ik=2:k,
      lv=lev(ik); lr=1:lv; lc=1:lv-1;
      if gen(ik) == 0,
        Xtemp=kron(Xtemp,u(lr));
      else,
        if par(ik) == 'g', 
          Xtemp=kron(Xtemp,Eg(lr,lc));
        else, 
          Xtemp=kron(Xtemp,El(lr,lc)); 
        end
      end
    end
    X=[X Xtemp];
  end

% remaining components
if nargin > 2,
  for ir=1:nr,
    gen=R(ir,:);
    lv=lev(1); lr=1:lv; lc=1:lv-1;
    if gen(1) == 0,
      Xtemp=u(lr);
    else,
      if par(1) == 'g', Xtemp=Eg(lr,lc);
      else, Xtemp=El(lr,lc); 
      end
    end
     
    for ik=2:k,
      lv=lev(ik);  lr=1:lv; lc=1:lv-1;
      if gen(ik) == 0,
        Xtemp=kron(Xtemp,u(lr));
      else,
        if par(ik) == 'g', 
          Xtemp=kron(Xtemp,Eg(lr,lc));
        else, 
          Xtemp=kron(Xtemp,El(lr,lc)); 
        end
      end
    end
    Z=[Z Xtemp];
  end
end