function [Ci,Mi] = globserv(lev,mod,bin,nes)
%        [Ci,Mi] = globserv(lev,mod,bin,nes)
% builds components of M and C for glob,
% glomat glocon, globeru; bin is (i,j)-th element
% of matrix of binary effects; these are marginal
% if ic is absent and conditional otherwise

% preliminaries
  Ac=tril(ones(lev));  As=Ac';
  c=[-1 1]; Id=eye(lev);
  lel=1:lev-1; leu=2:lev; 
%   
  if bin == 1, % actuve
     Ci=kron(c,Id(lel,lel)); 
     % select mode
     if mod == 'g' 
       Mi=[Ac(lel,:);
           As(leu,:)];
     elseif mod == 'c', 
       Mi=[Id(lel,:);
           As(leu,:)];
     elseif mod == 'r',
       Mi=[Ac(lel,:);
           Id(leu,:)];
     elseif mod == 'l',
       Mi=[Id(lel,:);
           Id(leu,:)];
     elseif mod == 'n',
       ng=find(nes); nes=nes(ng); 
       ng=size(ng,2);
       Nw=[]; Nb=[]; Ci=[];
       Ab=[Id(1:(ng-1),:);
           Id(2:ng,:)];
       for in=1:ng,
         ni=nes(in);
         if ni>1,
           A=[Ac(1:(ni-1),1:ni);
              As(2:ni,1:ni)];
           Nw=blkdiag(Nw,A);
           e=1:(ni-1);
           Ci=blkdiag(Ci,kron(c,Id(e,e))); 
         else
           rw=size(Nw,1); Nw=[Nw zeros(rw,1)];
         end
         Nb=[Nb Ab(:,in)*ones(1,ni)];
       end
       Mi=[Nw;Nb]; e=1:(ng-1);
       Ci=blkdiag(Ci,kron(c,Id(e,e))); 
     elseif mod == 'p',
       ng=find(nes); nes=nes(ng); 
       ng=size(ng,2);
       Nw=[]; Nb=[]; Ci=[];
       Ab=[Id(1:(ng-1),:);
           Id(2:ng,:)];
       for in=1:ng,
         ni=nes(in);
         if ni>1,
           A=[Id(1:(ni-1),1:ni);
              As(2:ni,1:ni)];
           Nw=blkdiag(Nw,A);
           e=1:(ni-1);
           Ci=blkdiag(Ci,kron(c,Id(e,e))); 
         else
           rw=size(Nw,1); Nw=[Nw zeros(rw,1)];
         end
         Nb=[Nb Ab(:,in)*ones(1,ni)];
       end   % for in
       Mi=[Nw;Nb]; e=1:(ng-1);
       Ci=blkdiag(Ci,kron(c,Id(e,e))); 
     end    % if mod
  else       % if bin
     Ci=1;
     if bin == 0, Mi=ones(1,lev); % marginal
     else, 
         Mi=[1 zeros(1,lev-1)];   % cond-initial
     end    
  end
