function [p,er,dis] = glinve(M,C,eta,p)
%        [p,er,dis] = glinve(M,C,eta,p)
% inverts the GLLM parametrization 
% p = valore iniziale
% eta = C*log(M*p)

% starting values
  [m,k]=size(M); H=dfm(k); 
  G=H'*inv(H*H'); eps=10^(-80);
% prepare to iterate
  if nargin == 4,
    th=H*log(p);
  else
    th=zeros(k-1,1);
  end
  it=0; mit=500; tol=10^(-9);  dis=1;
  p=exp(G*th); p=p./sum(p); er = 0;
% iterate
  while (it < mit) && (dis > tol),
     th0=th; m=(M*p).^(-1);
     Om=diag(p)-p*p';
     D=C*diagv(m,M)*Om*G;    
     if rcond(D)<10^(-12),
        D=D+eye(k-1)/k;
     end
     dis=eta-C*log(M*p);
     th=th0+inv(D)*dis/(1+4/it);
     dis=sum(abs(dis))+sum(abs(th-th0));
     p=exp(G*th); p=p/sum(p); 
     p=p.*(p>=eps)+eps*(p<eps); p=p/sum(p);
     it=it+1;
     if any(isnan(p)), disp('nan'); break; end
  end
  if (dis) > tol || any(isnan(p)),
    er = 1;
  end
  