function [G,R] = ghiera(Gen)
%        [G,R] = ghiera(Gen)
% given generators in binary form 
% as rows of Gen, produces matrices
% of binary rows G (hierarchical terms) 
% and R (remaining terms)

% preliminaries
  [g,k]=size(Gen);
  T=sq(k); T(1,:)=[];
  nT=length(T(:,1));

% cycle across generators
  for ig=1:g,
    glab=Gen(ig,:); glab=find(glab);
    Gred=sq(length(glab)); Gred(1,:)=[];
    ng=length(Gred(:,1));
    Geg=zeros(ng,k); Geg(:,glab)=Gred;
    if ig == 1, G=Geg;
    else
      nG=length(G(:,1)); e=[];
    % remove duplicates   
      for id=1:ng,
        Gid=ones(nG,1)*Geg(id,:);
        dif=sum(abs(Gid-G)');
        if all(dif), e=[e;id]; end
      end
    G=[G;Geg(e,:)];
    end
  end
% residual generators
  nG=length(G(:,1)); e=[];
  for id=1:nT,
    Tid=ones(nG,1)*T(id,:);
    dif=sum(abs(Tid-G)');
    if all(dif), e=[e;id]; end
  end
  R=T(e,:);  