function [LL,be,F,P] = fiscor(y,V,G,Con,Mar,D,be)
%        [LL,be,F,P] = fiscor(y,V,G,Con,Mar,D,be)
% ML of marginal models by Fisher scoring with equality
% and inequality constraints

% preliminaries
  t=max(y); st=size(y,1);
  ep=10^(-80); [X,of]=model(V(1,:));
  xc=size(X,2); acc=0.0001; mit=250; 
  seta=size(Con,1); rD=size(D,1);
  
% Iterate  
  QK=ceil(st*(1:70)/70);  
  disp('----o----1----o----2----o----3----o----4----o----5----o----6----o----7'); 
  it=0; test=1; 
  while test==1,
    LL=0; sc=zeros(xc,1); F=zeros(xc); 
    it=it+1; P=zeros(t,st);
    for is=1:st,  % cycle across strata
      X=model(V(is,:));  
      eta=X*be+of; [p,er]=binve(Con,Mar,G,eta);
      if er==1, disp('no prob'); return, end
      p=p+ep*(p<ep); p=p/sum(p);
      Op=diag(p)-p*p';
      P(:,is)=p; LL=LL+log(p(y(is))); mp=Mar*p; 
      Op=diag(p)-Op*Op'; R=Con*diag(mp.^(-1))*Mar*Op*G;
      while rcond(R)<10^(-12), 
         R=R+5*eye(seta); fprintf('!'); end             
      R=inv(R); A=G*R*X; sc=sc+A(y(is),:)'-A'*p;
      F=F+A'*Op*A; 
      if any(QK==is), fprintf('-'); end
    end
    b0=be; v=inv(F)*sc+b0; fprintf('\n');  
    if rD==0, de=v-b0; 
    else % inequalities
        Fi=inv(F); Li=chol(Fi)'; Di=D*Li; 
        de=v-b0+Li*ldp(Di,-D*v);
    end
    dm=max(de)-min(de); % shorten step
    dd=(dm>2);  de=de/((5+mit/it)^(1.25)+dd*(dm^(.8)));  
%    de=de/(1+dd*(dm^(.75)));  
%    les=de'*sc/(de'*F*de); les=les*(les<=2)+2*(les>2); de=de*les;
    be=b0+de; dis=sum(abs(be-b0));
    test=(dis>acc)*(it<mit);  disp([it LL/100 dis])
    if it==floor(it/10)*10,  save temp be P F; end    
  end
  
