function [t01,t12,p,F] = fiscat(M,G,Cont,Mart,C,D)
%        [t01,t12,p,F] = fiscat(M,G,Cont,Mart,C,D)
% Fisher scoring of a set of frequency tables by column
% in M, covariates by row in V, with equality 
% and inequality constraints

% preliminaries
  t=size(M,1);   ep=10^(-80);
  seta=size(Cont,1);   
  acc=0.00001; mit=100; 
  [rc cc]=size(C);  [rd,cd]=size(D);
  if seta ~= cc, disp('check col C'); end
  if seta ~= cd, disp('check col D'); end
  if rc>0, Z=null(C); end 
     
% replace zeros
  ms=sum(M,1); 
  M=M+(M<10^(-6))*(10^(-6)); 
  M=M.*(ones(t,1)*(ms./sum(M,1))); 
% inizital estimates
  y=M; LLo=y'*log(M/ms);
  Mi=M+0.8; po=Mi/sum(Mi);
  eta=Cont*log(Mart*po); 
% constrained maximization
  it=0; test=1; 
  while test==1,
    it=it+1; 
    [p,er]=glinve(Mart,Cont,eta); 
     if er==1, disp('no prob'); keyboard, end
     p=p+ep*(p<ep); p=p/sum(p); 
     LL=y'*log(p); Op=diag(p)-p*p';  mp=Mart*p; 
     R=Cont*diag(mp.^(-1))*Mart*Op*G;
     while rcond(R)<10^(-12), 
        R=R+5*eye(seta); fprintf('!'); end             
     R=inv(R); A=G*R; sc=A'*(y-ms*p);
     F=ms*A'*Op*A; 
     et0=eta; v=et0+inv(F)*sc; 
     if rc==0 && rd==0,
        de=v-et0;    
     elseif rc == 0, % only inequalities
        Fi=inv(F); Li=chol(Fi)'; Di=D*Li; 
        de=v-et0+Li*ldp(Di,-D*v);
     elseif rd == 0,  % only equalities
        Ai=inv(Z'*F*Z);
        de=Z*Ai*Z'*F*v-et0;
     else      % equalities and inequalities
        Ai=inv(Z'*F*Z);
        Li=chol(Ai)'; Dz=D*Z; ta=Ai*Z'*F*v;
        de=Z*(ta+Li*ldp(Dz*Li,-Dz*ta))-et0;
     end  
     dis0=sum(abs(de)); dm=max(de)-min(de); % shorten step
     dd=(dm>2); de=de/((1+mit/it)^(0.5)+dd*(dm^(.75)));  
     eta=et0+de; dis=sum(abs(eta-et0));
 %    disp([it LL/100 dis0 dis])
     test=(dis0>acc)*(it<mit);
  end
  t12=2*(LLo-LL); T=shape(M,sqrt(t))'/ms;
  r=sum(T,2); c=sum(T,1); P=r*c;
  p=shape(P',1)'; LLi=y'*log(p);
  t01=2*(LL-LLi);
  
  
  
 