function [M,C,Ter] = cofoba(lev,Bm,Md)
%        [M,C,Ter] = cofoba(lev,Bm,Md)
% Bartolucci-Colombi-Forcina marginal link function
% number of levels in lev, marginals of interest in Bm
% by row in binary form; corresponding logit types 
% 'l', 'c', 'g', 'r' in Md which may have a single row
% when logit type is constant across marginals 

% preliminaries
  J=length(lev); 
  if nargin == 1, 
     Bm=ones(1,J); Md='l'*ones(1,J); end 
  if nargin == 2, 
     Md='l'*ones(1,J); end
  m=size(Bm,1); 
  if size(Md,1)==1, 
      Md=ones(m,1)*Md; end
  Par=sq(J); Par(1,:)=[]; p=size(Par,1);
  C=[]; M=[];  Ter=[];

% size of nested factors
  N=zeros(J,10); % at most 10 blocks allowed
  for j=1:J, % will prompt for input
    if Md(1,j) == 'n' || Md(1,j) == 'p',
      disp('factor'); disp(j);
      n=input('nested levels ');
      ni=size(n,2); 
      N(j,:)=[n zeros(1,10-ni)];
    end
  end
  
% cycle across marginals
  for im=1:m,
    ip=1;
    while ip<=p,
      if all(Bm(im,:)>=Par(ip,:)),
        bm=Par(ip,:); Ter=[Ter;im bm]; Par(ip,:)=[]; p=p-1;
        bm=bm.*(bm==Bm(im,:))-(bm<Bm(im,:));
        mod=Md(im,:); 
        [C1,M1]=globserv(lev(1),mod(1),bm(1),N(1,:));   
        for j=2:J,
          [C2,M2]=globserv(lev(j),mod(j),bm(j),N(j,:));
          M1=kron(M1,M2); C1=kron(C1,C2);
        end
        C=blkdiag(C,C1); M=[M;M1]; 
      else ip=ip+1; 
      end
    end
  end