function [p,err,it,div] = binve(C,M,G,eta)
%        [p,err,it,div] = binve(C,M,G,eta)
% inverts marginal parametrization under the 
% assumption that higher order log linear
% terms are 0,  eta = C*log(M*p)
 
% starting values
  k=size(C,1); pmin=10^(-100);
  err=0; th0=randn(k,1)/50;
 
% prepare to iterate
  it=0; mit=500; tol=10^(-9); 
  p=exp(G*th0); p=p./sum(p);  t=M*p; 
  d=eta-C*log(t); div0=d'*d; 
  div=div0+1;
  while (it<mit)&&(div>tol),
    R0=C*diagv(t.^(-1),M)*diagv(p,G); 
    rco=rcond(R0)>tol; 
    while rco==0,     
      R0=R0+eye(k); rco=rcond(R0)>tol; 
    end
    de=inv(R0)*d; dem=max(abs(de)); 
    de=(dem<=4)*de+(dem>4)*4*de/dem;
    th=th0+de; p=exp(G*th); p=p/sum(p); 
    p=p+pmin*(p<pmin); p=p/sum(p);
    t=M*p; d=eta-C*log(t); div=d'*d;
    rid=(.01+div0)/(.01+div); iw=0;
    while (rid<0.96) && (iw<10),
      th=th0+(rid.^(iw+1))*de; 
      p=exp(G*th); p=p/sum(p); p=p+pmin*(p<pmin);
      p=p/sum(p); t=M*p; d=(eta-C*log(M*p)); 
      div=d'*d; rid=(.01+div)/(.01+div0);
      iw=iw+1; it=it+1; 
    end
    if rid<0.96, it=mit; else it=it+1; th0=th; end
  end
  if div > tol || any(isnan(p)),      
    err=1;
  end  
