%% Performs the non-parametric analysis described in Section 6
%% searches for suitable aggregation of tables tthat avoids damaging zeros
% read data
  load dnew; D=data;
% social class
  css=D(:,1)-1; % son social class
  csf=D(:,2)-1; % father s.c.
% education
  edu=D(:,3)+2*D(:,4)+3*D(:,5);
% ability scores
  acg=D(:,6); ct=qtile(acg,3); acg=discrete(acg,ct);
  ang=D(:,7); ct=qtile(ang,3); ang=discrete(ang,ct);
% father's age
  age=D(:,8); ct=qtile(age,2); age=discrete(age,ct);
% tabulate
  N=tabel([age,edu,acg,ang,csf,css]); N=shape(N,9);
% eliminate empty tables
  n=sum(N); N=N(:,(n>0)); n=sum(N);
% define totals that have to be non empty
  Z=[1 0 0 1 0 0 0 0 0
     0 0 1 0 0 1 0 0 0
     0 0 0 1 0 0 1 0 0
     0 0 0 0 0 1 0 0 1
     1 1 1 1 1 1 0 0 0
     1 1 1 0 0 0 1 1 1
     0 0 0 1 1 1 1 1 1];
% initialize
  c=size(N,2); iz=[]; ep=10^(-8);
% detect tables with unadmissible empty patterns  
  for i=1:c
      if any(Z*N(:,i)==0)||(sum(N(:,i))<10), iz=[iz i]; end
  end
% searches for tables to be merged among those with empty patterns
  ic=stract((1:c),iz); 
  for i=iz
      Ni=shape(N(:,i),3)'; iz=stract(iz,i);
      Pi=Ni+ep*(Ni==0); ni=sum(Pi,2); Pi=diag(ni.^(-1))*Pi;
      for j=ic,
          Nj=shape(N(:,j),3)';          
          Pj=Nj+ep*(Nj==0); nj=sum(Pj,2); Pj=diag(nj.^(-1))*Pj;
          Nt=Ni+Nj; P=Nt+ep*(Nt==0); nt=sum(P,2); Pt=diag(nt.^(-1))*P;
          T=sum(sum(((Pi-Pj).^2)./P));  Nt=shape(Nt',9); 
          if (T<7)
              N(:,j)=Nt; disp([i j T]);   break; 
          end          
      end
  end
  N=N(:,ic);
  N=N+ep*(N==0);
% defines marginal model
  lev=[3 3]; md=['g' 'g';'g' 'g';'l' 'g'];
  B=[eye(2);1 1];
  [Ma,Co]=cofoba(lev,B,md);
  G=hdes(lev,['l' 'l'],[1 1]); G(:,1)=[]; 
% defines inequality constraints in D
  cN=size(N,2); sb=8; C=zeros(0,sb); D=C;
  D=[zeros(4) eye(4)]; 
% computes LR tests and saves Fisher information
  Out=zeros(cN,2);  F=[];
  for j=1:cN
      M=N(:,j); disp(j)
      [t01,t12,p,Fa] = fiscat(M,G,Co,Ma,C,D);      
      Out(j,:)=[t01 t12]; F=blkdiag(F,Fa);
  end
  T01=sum(Out(:,1)); T12=sum(Out(:,2)); 
  D=kron(eye(cN),D); C=zeros(0,size(D,2));
      
      
      
          
      