        @ Entering and transforming the data @;

cls; " Type 1 for a file.FMT or 2 for an ASCII file ";;
i=con(1,1); cls; if i==2;
" Number of observations = ";; t = con(1,1);
" Number of variables = ";; k = con(1,1); cls;
" Type the name of your ASCII file (free format) ";;
name = cons; load y[t,k] = ^name; endif;
if i==1; " Type the name of your file.FMT ";; name=cons; loadm y=^name;
k=cols(y); t=rows(y); endif; cls;

y0=y-lagn(y,4);
y1=lag(y)+lagn(y,2)+lagn(y,3)+lagn(y,4);
y2=lag(y)-lagn(y,2)+lagn(y,3)-lagn(y,4);
y3=lag(y)-lagn(y,3);
y4=lag(y3);
y=y[5:t,.];
y0=y0[5:t,.];
y1=y1[5:t,.];
y2=y2[5:t,.];
y3=y3[5:t,.];
y4=y4[5:t,.];
t=t-4;

" Input the SECM order = ";; p=con(1,1);
@ x=ones(t,1); @
@ x=ones(t,1)~seqa(1,1,t); @
@ x=ones(t,1)~seqa(1,1,t)~cos(seqa(1,1,t)*pi)~
  cos(seqa(1,1,t)*pi/2)~sin(seqa(1,1,t)*pi/2); @
    x=ones(t,1)~cos(seqa(1,1,t)*pi)~
    cos(seqa(1,1,t)*pi/2)~sin(seqa(1,1,t)*pi/2);
nd=cols(x);
@ Note: nd = number of deterministics included in the analysis @;
l=y0;
j=1; do while j<=p;
l=lag(l);
l=l[2:t,.];
y=y[2:t,.];
y0=y0[2:t,.];
y1=y1[2:t,.];
y2=y2[2:t,.];
y3=y3[2:t,.];
y4=y4[2:t,.];
x=x[2:t,.]~l;
t=t-1; j=j+1; endo; cls;
@ Note: y0=y-y(-4); yi=Si(L)y(-1) for i=1,2,3; y4=Ly(3) @;
@ x=deterministics~[y0(-1),...,y0(-p)]; @;


        @ Cointegration analysis at frequency zero @;

z     = x~y2~y3~y4;
r0    = y0 - z*inv(z'z)*z'*y0;
r1    = y1 - z*inv(z'z)*z'*y1;
s11   = r1'r1;
s10   = r1'r0;
s00   = r0'r0;
sig   = s10*inv(s00)*(s10');
tmp   = inv(s11);
{a1,b,d1,c} = eigrg2(tmp*sig);

@ Note: ordering eigenvalues and eigenvectors @;
c = (-a1)~(d1');
c = sortc(c,1);
a1 = -c[.,1];
d1 = c[.,2:k+1]';

@ Note: normalizing eigenvectors @;
j=1; do while j<=k;
d1[.,j] = d1[.,j]/d1[j,j];
j=j+1; endo;

@ Computing the trace statistics @;
lr=zeros(k,1);
j=1; do while j<=k;
lr[j,1] = -t*sumc(trimr(ln(1-a1),j-1,0));
j=j+1; endo;

@ Writing the results @;
output file = gc_gauss.out reset;
screen off;
" Cointegration analysis at frequency zero ";
" Trace statistics: [H0: r1 <= j vs H1: r1 > j, for j=1,...k] ";; lr;
" Normalized eigenvectors: ";; d1;


        @ Cointegration analysis at frequency 1/2 @;

z     = x~y1~y3~y4;
r0    = y0 - z*inv(z'z)*z'*y0;
r2    = y2 - z*inv(z'z)*z'*y2;
s22   = r2'r2;
s20   = r2'r0;
s00   = r0'r0;
sig   = s20*inv(s00)*(s20');
tmp   = inv(s22) ;
{a2,b,d2,c} = eigrg2(tmp*sig);

@ Note: ordering eigenvalues and eigenvectors @;
c = (-a2)~(d2');
c = sortc(c,1);
a2 = -c[.,1];
d2 = c[.,2:k+1]';

@ Note: normalizing eigenvectors @;
j=1; do while j<=k;
d2[.,j] = d2[.,j]/d2[j,j];
j=j+1; endo;

@ Computing the trace statistics @;
lr=zeros(k,1);
j=1; do while j<=k;
lr[j,1] = -t*sumc(trimr(ln(1-a2),j-1,0));
j=j+1; endo;

@ Writing the results @;
" "; " Cointegration analysis at frequency 1/2 ";
" Trace statistics: [H0: r2 <= j vs H1: r2 > j, for j=1,...k] ";; lr;
" Normalized eigenvectors: ";; d2;


        @ Cointegration analysis at frequency 1/4 @;

z     = x~y1~y2;
r0    = y0 - z*inv(z'z)*z'*y0;
r4    = y4 - z*inv(z'z)*z'*y4;
s44   = r4'r4;
s40   = r4'r0;
s00   = r0'r0;
sig   = s40*inv(s00)*(s40');
tmp   = inv(s44) ;
{a4,b,d4,c} = eigrg2(tmp*sig);

@ Note: ordering eigenvalues and eigenvectors @;
c = (-a4)~(d4');
c = sortc(c,1);
a4 = -c[.,1];
d4 = c[.,2:k+1]';

@ Note: normalizing eigenvectors @;
j=1; do while j<=k;
d4[.,j] = d4[.,j]/d4[j,j];
j=j+1; endo;

@ Computing the trace statistics @;
lr=zeros(k,1);
j=1; do while j<=k;
lr[j,1] = -t*sumc(trimr(ln(1-a4),j-1,0));
j=j+1; endo;

@ Writing the results @;
" "; " Cointegration analysis at frequency 1/4 ";
" Trace statistics: [H0: r3 <= j vs H1: r3 > j, for j=1,...k] ";; lr;
" Normalized eigenvectors: ";; d4;


        @ Restricting cointegrating vectors @;

@ ### Note: this section enables the use of restricted CV ### @;
@ d1[.,1]=1|-1; " "; " Note: henceforth restricted CV are used "; @


        @ Showing cointegration results @;
""; " Number of deterministics in the analysis: ";; nd;
output file = gc_gauss.out off;
screen on;
dos edit gc_gauss.out;


        @ Forming ECM terms @;

cls;
" Type the cointegration rank at frequency 0 ";;
i=con(1,1);
if i > 0;
ec1=y1*d1[.,1:i];
if nd > 1;
d = x[.,1:2];
ec1 = ec1-d*inv(d'd)*d'ec1;
endif;
x=x~ec1;
endif;
r=i;

cls;
" Type the cointegration rank at frequency 1/2 ";;
i=con(1,1);
if i > 0;
ec2=y2*d2[.,1:i];
if nd > 2;
d = x[.,1]~x[.,3];
ec2 = ec2-d*inv(d'd)*d'ec2;
endif;
x=x~ec2;
endif;
r=r+i;

cls;
" Type the cointegration rank at frequency 1/4 ";;
i=con(1,1);
if i > 0;
ec4=y4*d4[.,1:i];
if nd > 2;
d = x[.,1]~x[.,4:5];
ec4 = ec4-d*inv(d'd)*d'ec4;
endif;
x=x~ec4;
endif;
cls;
r=r+i;

        @ Separating deterministics from other instruments @;

if nd > 0;
d = x[.,1];
x = x[.,nd+1:cols(x)];
endif;


        @ Codependence analysis of order zero @;

y0 = y0-d*inv(d'd)*d'y0;
x = x-d*inv(d'd)*d'x;
sxx   = x'x;
sxy   = x'y0;
syy   = y0'y0;
sig   = sxy'*inv(sxx)*(sxy);
tmp   = inv(syy);
{a,b,e,c} = eigrg2(tmp*sig);

@ Note: ordering eigenvalues and eigenvectors @;
c = (a)~(e');
c = sortc(c,1);
a = c[.,1];
e = c[.,2:k+1]';

@ Note: normalizing eigenvectors @;
j=1; do while j<=k;
e[.,j] = e[.,j]/e[j,j];
j=j+1; endo;

@ Computing tests statistics and relative p-values @;
lr=zeros(k,1);
pv=zeros(k,1);
j=1; do while j<=k;
lr[j,1] = -t*sumc(ln(1-a[1:j]));
pv[j,1]=cdfchic(lr[j,1],(j*(k*p+r+j-k)));
j=j+1; endo;

@ Writing the results @;
output file = gc_gauss.out on;
screen off;
""; " Codependence analysis: order 0 ";
" Test statistics for H0: r <= j vs H1: r > j (j=1,...k) and their p-values ";;
lr~pv;
" Normalized eigenvectors: ";; e;


        @ Codependence analysis of higher orders @;

library auto;
i=1;
do while i<=3;
y0=y0[2:t,.];
x=lag(x);
x=x[2:t,.];
d=d[2:t,.];
y0 = y0-d*inv(d'd)*d'y0;
x = x-d*inv(d'd)*d'x;
t=t-1;

@ Note: computing canonical correlation part I @;
sxx   = x'x;
sxy   = x'y0;
syy   = y0'y0;
sig   = sxy*inv(syy)*(sxy');
tmp   = inv(sxx);
{a,b,f,c} = eigrg2(tmp*sig);

@ Note: ordering eigenvalues and eigenvectors part I @;
c = (a)~(f');
c = sortc(c,1);
a = c[.,1];
f = c[.,2:cols(c)]';
f = f[.,(cols(f)-k+1):cols(f)]

@ Note: computing canonical correlation part II @;
sig   = sxy'*inv(sxx)*(sxy);
tmp   = inv(syy);
{a,b,e,c} = eigrg2(tmp*sig);

@ Note: ordering eigenvalues and eigenvectors part II @;
c = (a)~(e');
c = sortc(c,1);
a = c[.,1];
e = c[.,2:k+1]';

@ Note: computing deviances of canonical correlation @;
vy = autocor(y0*e,1,i);
vx = autocor(x*f,1,i);
a = a./(ones(k,1)+2*sumc(vx.*vy));


@ Note: normalizing eigenvectors @;
j=1; do while j<=k;
e[.,j] = e[.,j]/e[j,j];
j=j+1; endo;

@ Computing tests statistics and relative p-values @;
lr=zeros(k,1);
pv=zeros(k,1);
j=1; do while j<=k;
lr[j,1] = -t*sumc(ln(1-a[1:j]));
pv[j,1]=cdfchic(lr[j,1],(j*(k*p+r+j-k)));
j=j+1; endo;

@ Writing the results @;
output file = gc_gauss.out on;
""; " Codependence analysis: order ";; i;
" Test statistics for H0: r <= j vs H1: r > j (j=1,...k) and their p-values ";;
lr~pv;
" Normalized eigenvectors: ";; e;
i=i+1;
endo;

@ Showing codependence results @;
output file = gc_gauss.out off;
screen on;
dos edit gc_gauss.out;
