%--------------------------------------------------------------------------
%
% Sample code to reproduces the T=100 results of "Table 1: Summary of 
% Monte Carlo Results" described in the  paper: "Likelihood Evaluation 
% of DSGE Models with Occassionally Binding Constraints" 
% 
% This code requires distdraws_MC100GAM1_*.mat files to be created using
% script_mcmc_drawcredsets.m, see Readme.txt for implementation details.
%
% Pablo Cuba-Borda, Luca Guerrieri, Matteo Iacoviello and Molin Zhong
% Federal Reserve Board. Washington, D.C. 
%
% Created: 11/01/2017.
% Last modified: 04/23/2019.
%--------------------------------------------------------------------------

clear; clc;

basename = 'MC100GAM1_';  % Do not change
basesample = 'sample100';
specname = 'VFIINV_';

load(['distdraws_' basename specname basesample '.mat']);

nburn = 5000;
credlevel = 0.9;

clear credsetdraws

count_out = 0;
count_fail = 0;
for iDraw=0:99
    %What do the 90% credible sets look like?
%     credsetdraws(1,iDraw+1) = quantile(gammadraws(:,iDraw+1),0.05);
%     credsetdraws(2,iDraw+1) = quantile(gammadraws(:,iDraw+1),0.95);
    
    [credsetdraws(1,iDraw+1),credsetdraws(2,iDraw+1)] = hpd_cred(gammadraws(nburn+1:end,iDraw+1),credlevel);

    if credsetdraws(2,iDraw+1) - credsetdraws(1,iDraw+1) > quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2)-quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2)
    count_fail = count_fail + 1;
    credsetdraws(2,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2);
    credsetdraws(1,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2);
    end
    
    if credsetdraws(1,iDraw+1) > 1 || credsetdraws(2,iDraw+1) < 1
    count_out = count_out + 1; 
    end
    
    quantiletrue(iDraw+1) = mean(gammadraws(nburn+1:end,iDraw+1)<1);
end

lowerinv = mean(credsetdraws(1,:));
upperinv = mean(credsetdraws(2,:));
credsetdrawsinv=  credsetdraws;
count_failinv = count_fail;
count_outinv = count_out;

fprintf('\n----------------------------------------------------------\n')
fprintf(' Montecarlo results for %s \n',[specname basesample]);
fprintf(' Lower \t Upper \t Freq outside \t Avg quant true \n')
fprintf(' %4.4f  %4.4f  %4.4f  \t\t %4.4f \n', lowerinv, upperinv, count_outinv,mean(quantiletrue));


%% Compare the INV filter to the misspecified versions
%% VFI ME5
specname = 'VFI_ME5_';

load(['distdraws_' basename specname basesample '.mat']);

clear credsetdraws
clear quantiletrue

count_out = 0;
count_fail = 0;
for iDraw=0:99
    %What do the 90% credible sets look like?
    
    [credsetdraws(1,iDraw+1),credsetdraws(2,iDraw+1)] = hpd_cred(gammadraws(nburn+1:end,iDraw+1),credlevel);

    if credsetdraws(2,iDraw+1) - credsetdraws(1,iDraw+1) > quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2)-quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2)
    count_fail = count_fail + 1;
    credsetdraws(2,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2);
    credsetdraws(1,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2);
    end
    
    if credsetdraws(1,iDraw+1) > 1 || credsetdraws(2,iDraw+1) < 1
    count_out = count_out + 1; 
    end

    quantiletrue(iDraw+1) = mean(gammadraws(nburn+1:end,iDraw+1)<1);    
end

lowerME5 = mean(credsetdraws(1,:));
upperME5 = mean(credsetdraws(2,:));
credsetdrawsME5=  credsetdraws;
count_failME5 = count_fail;
count_outME5 = count_out;

fprintf('\n----------------------------------------------------------\n')
fprintf(' Montecarlo results for %s \n',[specname basesample]);
fprintf(' Lower \t Upper \t Freq outside \t Avg quant true \n')
fprintf(' %4.4f  %4.4f  %4.4f  \t\t %4.4f \n', lowerME5, upperME5, count_outME5,mean(quantiletrue));



%% VFI ME20
specname = 'VFI_ME20_';

load(['distdraws_' basename specname basesample '.mat']);

clear credsetdraws
clear quantiletrue

count_out = 0;
count_fail = 0;
for iDraw=0:99
    %What do the 90% credible sets look like?
    
    [credsetdraws(1,iDraw+1),credsetdraws(2,iDraw+1)] = hpd_cred(gammadraws(nburn+1:end,iDraw+1),credlevel);

    if credsetdraws(2,iDraw+1) - credsetdraws(1,iDraw+1) > quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2)-quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2)
    count_fail = count_fail + 1;
    credsetdraws(2,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2);
    credsetdraws(1,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2);
    end
    
    if credsetdraws(1,iDraw+1) > 1 || credsetdraws(2,iDraw+1) < 1
    count_out = count_out + 1; 
    end
    
    quantiletrue(iDraw+1) = mean(gammadraws(nburn+1:end,iDraw+1)<1);    
    
end

lowerME20 = mean(credsetdraws(1,:));
upperME20 = mean(credsetdraws(2,:));
credsetdrawsME20=  credsetdraws;
count_failME20 = count_fail;
count_outME20 = count_out;

fprintf('\n----------------------------------------------------------\n')
fprintf(' Montecarlo results for %s \n',[specname basesample]);
fprintf(' Lower \t Upper \t Freq outside \t Avg quant true \n')
fprintf(' %4.4f  %4.4f  %4.4f  \t\t %4.4f \n', lowerME20, upperME20, count_outME20,mean(quantiletrue));

%% OCC INV
specname = 'OCCINV_';

load(['distdraws_' basename specname basesample '.mat']);

clear credsetdraws
clear quantiledraws

count_out = 0;
count_fail = 0;
for iDraw=0:99
    %What do the 90% credible sets look like?
    
    [credsetdraws(1,iDraw+1),credsetdraws(2,iDraw+1)] = hpd_cred(gammadraws(nburn+1:end,iDraw+1),credlevel);

    if credsetdraws(2,iDraw+1) - credsetdraws(1,iDraw+1) > quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2)-quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2)
    count_fail = count_fail + 1;
    credsetdraws(2,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2);
    credsetdraws(1,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2);
    end
    
    if credsetdraws(1,iDraw+1) > 1 || credsetdraws(2,iDraw+1) < 1
    count_out = count_out + 1; 
    end
    
    quantiletrue(iDraw+1) = mean(gammadraws(nburn+1:end,iDraw+1)<1);    
    
end

loweroccinv = mean(credsetdraws(1,:));
upperoccinv = mean(credsetdraws(2,:));
credsetdrawsoccinv=  credsetdraws;
count_failoccinv = count_fail;
count_outoccinv = count_out;

fprintf('\n----------------------------------------------------------\n')
fprintf(' Montecarlo results for %s \n',[specname basesample]);
fprintf(' Lower \t Upper \t Freq outside \t Avg quant true \n')
fprintf(' %4.4f  %4.4f  %4.4f  \t\t %4.4f \n', loweroccinv, upperoccinv, count_outoccinv,mean(quantiletrue));


%% OCC ME5
specname = 'OCC_ME5_';

load(['distdraws_' basename specname basesample '.mat']);

clear credsetdraws
clear quantiletrue

count_out = 0;
count_fail = 0;
for iDraw=0:99
    %What do the 90% credible sets look like?
    
    [credsetdraws(1,iDraw+1),credsetdraws(2,iDraw+1)] = hpd_cred(gammadraws(nburn+1:end,iDraw+1),credlevel);

    if credsetdraws(2,iDraw+1) - credsetdraws(1,iDraw+1) > quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2)-quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2)
    count_fail = count_fail + 1;
    credsetdraws(2,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2);
    credsetdraws(1,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2);
    end
    
    if credsetdraws(1,iDraw+1) > 1 || credsetdraws(2,iDraw+1) < 1
    count_out = count_out + 1; 
    end
    
    quantiletrue(iDraw+1) = mean(gammadraws(nburn+1:end,iDraw+1)<1);    
    
end

loweroccME5 = mean(credsetdraws(1,:));
upperoccME5 = mean(credsetdraws(2,:));
credsetdrawsoccME5=  credsetdraws;
count_failoccME5 = count_fail;
count_outoccME5 = count_out;

fprintf('\n----------------------------------------------------------\n')
fprintf(' Montecarlo results for %s \n',[specname basesample]);
fprintf(' Lower \t Upper \t Freq outside \t Avg quant true \n')
fprintf(' %4.4f  %4.4f  %4.4f  \t\t %4.4f \n', loweroccME5, upperoccME5, count_outoccME5,mean(quantiletrue));


%% OCC ME20
specname = 'OCC_ME20_';

load(['distdraws_' basename specname basesample '.mat']);

clear credsetdraws
clear quantiletrue

count_out = 0;
count_fail = 0;
for iDraw=0:99
    %What do the 90% credible sets look like?
    
    [credsetdraws(1,iDraw+1),credsetdraws(2,iDraw+1)] = hpd_cred(gammadraws(nburn+1:end,iDraw+1),credlevel);

    if credsetdraws(2,iDraw+1) - credsetdraws(1,iDraw+1) > quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2)-quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2)
    count_fail = count_fail + 1;
    credsetdraws(2,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5+credlevel/2);
    credsetdraws(1,iDraw+1) = quantile(gammadraws(nburn+1:end,iDraw+1),0.5-credlevel/2);
    end
    
    if credsetdraws(1,iDraw+1) > 1 || credsetdraws(2,iDraw+1) < 1
    count_out = count_out + 1; 
    end
    
    quantiletrue(iDraw+1) = mean(gammadraws(nburn+1:end,iDraw+1)<1);    
    
end

loweroccME20 = mean(credsetdraws(1,:));
upperoccME20 = mean(credsetdraws(2,:));
credsetdrawsoccME20=  credsetdraws;
count_failoccME20 = count_fail;
count_outoccME20 = count_out;

fprintf('\n----------------------------------------------------------\n')
fprintf(' Montecarlo results for %s \n',[specname basesample]);
fprintf(' Lower \t Upper \t Freq outside \t Avg quant true \n')
fprintf(' %4.4f  %4.4f  %4.4f  \t\t %4.4f \n', loweroccME20, upperoccME20, count_outoccME20,mean(quantiletrue));
