function [out1, out2] = solve_VFI(GAMMAIN,R,BETA,M,P,B,Z,nz,nb,options)
    %-----------------------------------------------------
    % Initialization of value functionb
    %-----------------------------------------------------
    V = ones(nz,nb)/(1-BETA);

    %-----------------------------------------------------
    % Initialize choices and value
    %-----------------------------------------------------

    newV = V;
    EV = V;
    BPRIME = B ;
    Bdec_old = V*1;
    Bdec = V*0;

    %-----------------------------------------------------
    % Iterate on value function until convergence
    %-----------------------------------------------------
    diffB = 1;
    diffV   = 1;
    iter    = 1;


     while (iter <= 50) && (diffB > 0.000001)
         disp([ iter diffB ])
%
%         % Calculate expected future value
          VPP=interp1(B,V','*spline','pp');
          %
         for iz = 1:nz
             for ib = 1:nb

                coh=Z(iz)-R*B(ib) ;
                bold=B(ib);

                 f = @(x)vincent_value(x,coh,BETA,GAMMAIN,Z,M,iz,P,VPP) ;
                 %
%                 % "c", "v", EV(iz,:) are vectors of size [1,nb]
%                 % We look in each state for the BPRIME that maximizes v
%
                   [ Bdec(iz,ib), newminusV(iz,ib)] = fminbnd(f,B(1),B(end),options);

%                 % bdecold=Bdec(iz,ib);
                   newV(iz,ib)=-newminusV(iz,ib);

             end
         end

        %---------------------------------------
        % HOWARD IMPROVEMENT
        %---------------------------------------
        % Given the deciosn rule so far..
        % construct a grid for income assets nz,nb
        [ Zm Bm ] = ndgrid(Z,B);



        % consumption ib a grid too of dimension nz,nb
        Cd = max( 1e-200, Zm + Bdec - R.*Bm ) ;
        Cd(Bdec>M*Zm) = 1e-200 ;

        % evaluate utility
        if GAMMAIN==1
        U =  log(Cd) ;
        else
        U = Cd.^(1-GAMMAIN)/(1-GAMMAIN)  ;
        end

        % Iterate over the policy function for 50 periods or so...
        % that ib, assume the same policy ib used forever
        % use this as new expected utility
        for iHOWARD = 1:50

                 newVPRIME = interp1(B,newV',Bdec,'spline') ;
                 newVPRIME2 = permute(newVPRIME,[3 1 2]);
                 for iz=1:nz
                    EVPRIME(iz,:)=P(iz,:)*squeeze(newVPRIME2(:,iz,:));
                 end

                 newV = U + BETA * EVPRIME;

        end

%------------------------------------
         diffB = max(abs((Bdec(:)-Bdec_old(:))));
         Bdec_old = Bdec ;
         iter  = iter + 1;
         V     = newV;
%
     end
     disp([ iter diffB ])

    if iter == 50
      warning('Max number of iterations reached in solution');
    end
     out1 = Bdec;
%
%
%     %-----------------------------------------------------
%     % Calculate Decision Rules
%     %-----------------------------------------------------
    Cdec = NaN*Bdec;

    % Calculate policy function for C: Cdec
    for iz = 1:nz
        for ib = 1:nb
            Cdec(iz,ib) = max( 1e-200, Z(iz) + Bdec(iz,ib) - R*B(ib) )  ;
        end
    end

    out2 = Cdec;
%
%     clear Cdecinterp ECdec ECdec_old INV* newV  Cd Cm U newVPRIME*
