function [outsim grad init_out E newviolvecbool relaxconstraint iter] = simulate_occbin_v2(...
    err_vals,err_list,obs_list,current_obs,init_val,...
    constraint1,constraint_relax1,i1,i2,nvars,ys_,endog_,exog_,params,...
    decrulea,decruleb,cof,Jbarmat,cof10,Jbarmat10,Dbarmat10)


nper = 100;
curb_retrench = 0;

maxiter = 100; % You might want to have large number here, depends a lot on model 10-24-14


% Map Constraints;
constraint1_difference = constraint1;
constraint_relax1_difference = constraint_relax1;

% Map objects from global structures. 
scalefactormod = err_vals';
irfshock       = err_list;

% Map Steady State
b_ss=ys_(1);
bnot_ss=ys_(2);
c_ss=ys_(3);
ec_ss=ys_(4);
lb_ss=ys_(5);
maxlev_ss=ys_(6);
y_ss=ys_(7);

% Map parameters
RHO=params(1);
BETA=params(2);
M=params(3);
R=params(4);
STD_U=params(5);
GAMMAC=params(6);

% Number of shocks
nshocks = size(err_vals',1);

% Housekeeping
init = init_val;
zdataconcatenated = zeros(nper,nvars);
violvecbool = zeros(nper+1,1);  % This sets the first guess for when
% the constraints are going to hold.
% The variable is a boolean with one
% columns. The first column refers to
% constraint1; Each row is a period in time.
% If the boolean is true it indicates
% the relevant constraint is expected
% to evaluate to true.
% The default initial guess is
% consistent with the base model always
% holding -- equivalent to the linear
% solution.


for ishock = 1:nshocks
        
    changes=1;
    iter = 0;
    
    while (changes && iter<maxiter)
        
        iter = iter +1;
        
        % analyse violvec and isolate contiguous periods in the other
        % regime.
        [regime1, regimestart1]=map_regime(violvecbool(:,1));
        
        [zdatalinear_, Ecurrent ]=mkdatap_anticipated_1constraints_fast(nper,decrulea,decruleb,...
            cof,Jbarmat,...
            cof10,Jbarmat10,Dbarmat10,...
            regime1,regimestart1,...
            violvecbool,endog_,exog_,...
            irfshock,scalefactormod(ishock,:),init);
        
        
        % Map differences
        b_difference=zdatalinear_(:,1);
        bnot_difference=zdatalinear_(:,2);
        lb_difference=zdatalinear_(:,5);

                
        % Update guess of binding constraints
        newviolvecbool = eval(constraint1_difference);
        relaxconstraint = eval(constraint_relax1_difference);
        
        % check if changes
        if (max(newviolvecbool(:)-violvecbool(:)>0)) || sum(relaxconstraint(find(violvecbool==1))>0)
            changes = 1;
        else
            changes = 0;
        end
        
        
        if curb_retrench   % apply Gauss-Sidel idea of slowing down the change in the guess
            % for the constraint -- only relax one
            % period at a time starting from the last
            % one when each of the constraints is true.
            retrench = 0*violvecbool(:);
            if ~isempty(find(relaxconstraint1 & violvecbool(:,1)))
                retrenchpos = max(find(relaxconstraint1 & violvecbool(:,1)));
                retrench(retrenchpos) = 1;
            end
            violvecbool = (violvecbool(:) | newviolvecbool(:))-retrench(:);
        else
            violvecbool = (violvecbool(:) | newviolvecbool(:))-(relaxconstraint(:) & violvecbool(:));
        end
        
        
    end
    if changes ==1
        %         display('Did not converge')
        error_flag = 1;
    else
        error_flag = 0;
    end
    
    init = zdatalinear_(1,:);
    zdataconcatenated(ishock,:)=init;
    init= init';
    
    % update the guess for constraint violations for next period
    % update is consistent with expecting no additional shocks next period
    violvecbool=[violvecbool(2:end,:);zeros(1,1)];
    
    % overwrite guess for next period -- reset guess to expect no
    % constraint wil hold
    violvecbool=0*violvecbool;
    
end

init_out = init;
zdataconcatenated(ishock+1:end,:)=zdatalinear_(2:nper-ishock+1,:);

zdata = mkdata_fullendog(nper,decrulea,decruleb,endog_,exog_,irfshock,scalefactormod,init_val);

zdatap = zdataconcatenated;

E = Ecurrent;

%%
grad = E(i1,i2);
nobs = size(obs_list,1);
resids = zeros(nobs,1);

% error_flag = 0;

if error_flag == 0
    
    outsim = zdatap;
    
else
    keyboard;
    %    resids = resids+100;
end


end