%--------------------------------------------------------------------------
%
% This code reproduces "Figure 3: Consumption Functions for Alternative 
% Values of the Coefficient of Relative Risk Aversion" described in the 
% paper: "Likelihood Evaluation of DSGE Models with Occassionally Binding 
% Constraints" 
% 
% Pablo Cuba-Borda, Luca Guerrieri, Matteo Iacoviello and Molin Zhong
% Federal Reserve Board. Washington, D.C. 
%
% Created: 11/01/2017.
% Last modified: 04/23/2019.
%--------------------------------------------------------------------------

nperiods = 100;
STD_U=0.01;
shockssequence=randn(nperiods,1)*STD_U;
gridpoints.nb=500;
gridpoints.ny=51;

%--------------------------------------------------------------------------
% FIXED PARAMTERS
%--------------------------------------------------------------------------
format short

R = 1.05;
BETA = 0.945;
RHO   = 0.9;
STD_U = 0.01; 
M = 1;

format compact 



%--------------------------------------------------------------------------
% SOLVE MODEL FOR GAMMA = {0.5, 1, 1.5}
%--------------------------------------------------------------------------
filename='vincent1';

GAMMAC = 0.5;
save PARAM_EXTRA R BETA RHO STD_U GAMMAC M
[ zdataglobal Emat polfun1 gridvals1 ] = solve_global(filename,shockssequence,gridpoints);


GAMMAC = 1;
save PARAM_EXTRA R BETA RHO STD_U GAMMAC M
[ zdataglobal Emat polfun2 gridvals2 ] = solve_global(filename,shockssequence,gridpoints);


GAMMAC = 1.5;
save PARAM_EXTRA R BETA RHO STD_U GAMMAC M
[ zdataglobal Emat polfun3 gridvals3 ] = solve_global(filename,shockssequence,gridpoints);


ib= findnearest(gridvals3.B,1) ;
iy1 = findnearest(gridvals3.Z,0.98) ;
iy2 = findnearest(gridvals3.Z,1.02) ;

%---------------------
% PLOT DECISION RULES
%---------------------
close all
plot(polfun1.Z(iy1:iy2,ib),polfun1.C(iy1:iy2,ib),'r--','Linewidth',3); hold on
plot(polfun2.Z(iy1:iy2,ib),polfun2.C(iy1:iy2,ib),'b','Linewidth',2); hold on
plot(polfun3.Z(iy1:iy2,ib),polfun3.C(iy1:iy2,ib),'k--','Linewidth',1); hold on
% plot(polfun3.Z(iy1:iy2,ib),(polfun1.C(iy1:iy2,ib)+polfun2.C(iy1:iy2,ib)+polfun3.C(iy1:iy2,ib))/3,'g','Linewidth',2); hold on

axis tight
xlim([0.985 1.015])
legend('\gamma=0.5','\gamma=1','\gamma=1.5','Location','NorthWest')
xlabel('Income')
ylabel('Consumption')
grid on


dim = [5,4]*1.25;
set(gcf,'paperpositionmode','manual','paperunits','inches');
set(gcf,'papersize',dim,'paperposition',[0,0,dim]);
print('-dpdf','Figure3.pdf'); 



