%--------------------------------------------------------------------------
%
% This code reproduces "Figure 2: Likelihood Contours for Alternative
% Solution Methods and filters. The Case of No Measurement Error in the DGP
% described in the  paper: "Likelihood Evaluation of  DSGE Models with 
% Occassionally Binding Constraints" 
% 
% Pablo Cuba-Borda, Luca Guerrieri, Matteo Iacoviello and Molin Zhong
% Federal Reserve Board. Washington, D.C. 
%
% Created: 11/01/2017.
% Last modified: 04/23/2019.
%--------------------------------------------------------------------------

clear; clc;
samplesize = 100;
basepath = ''; 
basesample = ['sample' num2str(samplesize)];

% Do not change
basename = 'MC100GAM1_';  
M = dlmread([basename num2str(1) '_VFI_ME5_' basesample '.txt'],',');
gammagrid = M(:,2);


for iDraw=1

    %--------------------------------------------------------------------------
    % VFI + PF
    %--------------------------------------------------------------------------

    M = dlmread([basepath basename num2str(iDraw) '_VFI_ME5_' basesample '.txt'],',');
    keep_temp = M(:,3)';
    LIKIMAT.VFI.ME5(iDraw+1,:) = keep_temp;
    [~,i]= max(keep_temp);
    GAMMAMAT.VFI.ME5(iDraw+1,1) = gammagrid(i);
 
    M = dlmread([basepath basename num2str(iDraw) '_VFI_ME20_' basesample '.txt'],',');
    keep_temp = M(:,3)';
    LIKIMAT.VFI.ME20(iDraw+1,:) = keep_temp;
    [~,i]= max(keep_temp);
    GAMMAMAT.VFI.ME20(iDraw+1,1) = gammagrid(i);

    %--------------------------------------------------------------------------
    % OCC + PF
    %--------------------------------------------------------------------------
    
    M = dlmread([basepath basename num2str(iDraw) '_OCC_ME5_' basesample '.txt'],',');
    keep_temp = M(:,3)';
    LIKIMAT.OCC.ME5(iDraw+1,:) = keep_temp;
    
    [~,i]= max(keep_temp);
    GAMMAMAT.OCC.ME5(iDraw+1,1) = gammagrid(i);
    
    M = dlmread([basepath basename num2str(iDraw) '_OCC_ME20_' basesample '.txt'],',');
    keep_temp = M(:,3)';
    LIKIMAT.OCC.ME20(iDraw+1,:) = keep_temp;

    [~,i]= max(keep_temp);
    GAMMAMAT.OCC.ME20(iDraw+1,1) = gammagrid(i);


    %--------------------------------------------------------------------------
    % VFI + INV
    %--------------------------------------------------------------------------

    M = dlmread([basepath basename num2str(iDraw) '_VFIINV_'  basesample '.txt'],',');
    keep_temp = M(:,3)';
    LIKIMAT.VFI.INV(iDraw+1,:) = keep_temp;
    [~,i]= max(keep_temp);
    GAMMAMAT.VFI.INV(iDraw+1,1) = gammagrid(i);

    %--------------------------------------------------------------------------
    % OCC + INV
    %--------------------------------------------------------------------------

    M = dlmread([basepath basename num2str(iDraw) '_OCCINV_'  basesample '.txt'],',');
    keep_temp = M(:,3)';
    LIKIMAT.OCC.INV(iDraw+1,:) = keep_temp;
    [~,i]= max(keep_temp);
    GAMMAMAT.OCC.INV(iDraw+1,1) = gammagrid(i);


end




%% Figure 2: Results for 2nd sample 
gammagrid = M(:,2);
figure(1);clf;
set(figure(1),'PaperType','usletter','PaperOrientation','Portrait','PaperPosition',[0.1 0.1 8 11 ]);
subplot(321)
plot(gammagrid, smooth(LIKIMAT.VFI.INV(2,:)),'-','LineWidth',3); hold on;
title({'Minimal Solution Error,', 'No Measurement Error'})
legend('VFI,IF','Location','South'); legend boxoff; xlim([0 4.5]); ylim([180 280]*samplesize/100);
[C,I] = max((LIKIMAT.VFI.INV(2,:)));
plot([gammagrid(I),gammagrid(I)],[180 280]*samplesize/100,'linewidth',1,'color','r','linestyle',':')
plot([1 1],[180 280]*samplesize/100,'linewidth',2','color','k')
ylabel('Likelihood (log scale)')

subplot(322)
plot(gammagrid, smooth(LIKIMAT.VFI.INV(2,:)),'-','LineWidth',3); hold on
plot(gammagrid, smooth(LIKIMAT.OCC.INV(2,:))-log(2*pi)*samplesize/2,'--','LineWidth',3); 
title({'Some Solution Error,', 'No Measurement Error'})
legend('VFI,IF','OccBin,IF','Location','South'); legend boxoff; xlim([0 4.5]); ylim([180 280]*samplesize/100);
[C,I] = max((LIKIMAT.OCC.INV(2,:)));
plot([gammagrid(I),gammagrid(I)],[180 280]*samplesize/100,'linewidth',1,'color','r','linestyle',':')
plot([1 1],[180 280]*samplesize/100,'linewidth',2','color','k')

subplot(323)
plot(gammagrid, smooth(LIKIMAT.VFI.INV(2,:)),'-','LineWidth',3); hold on
plot(gammagrid, smooth(LIKIMAT.VFI.ME5(2,:)),'--','LineWidth',3); 
title({'Minimal Solution Error,', '5% Measurement Error'})
legend('VFI,IF','VFI,PF 5%','Location','South'); legend boxoff; xlim([0 4.5]); ylim([180 280]*samplesize/100);
[C,I] = max((LIKIMAT.VFI.ME5(2,:)));
plot([gammagrid(I),gammagrid(I)],[180 280]*samplesize/100,'linewidth',1,'color','r','linestyle',':')
plot([1 1],[180 280]*samplesize/100,'linewidth',2','color','k')
ylabel('Likelihood (log scale)')

subplot(324)
plot(gammagrid, smooth(LIKIMAT.VFI.INV(2,:)),'-','LineWidth',3); hold on
plot(gammagrid, smooth(LIKIMAT.OCC.ME5(2,:)),'--','LineWidth',3); 
title({'Some Solution Error,', '5% Measurement Error'})
legend('VFI,IF','OCC,PF 5%','Location','South'); legend boxoff; xlim([0 4.5]); ylim([180 280]*samplesize/100);
[C,I] = max((LIKIMAT.OCC.ME5(2,:)));
plot([gammagrid(I),gammagrid(I)],[180 280]*samplesize/100,'linewidth',1,'color','r','linestyle',':')
plot([1 1],[180 280]*samplesize/100,'linewidth',2','color','k')

subplot(325)
plot(gammagrid, smooth(LIKIMAT.VFI.INV(2,:)),'-','LineWidth',3); hold on
plot(gammagrid, smooth(LIKIMAT.VFI.ME20(2,:)),'--','LineWidth',3); 
title({'Minimal Solution Error,', '20% Measurement Error'})
legend('VFI,IF','VFI,PF 20%','Location','South'); legend boxoff; xlim([0 4.5]); ylim([180 280]*samplesize/100);
[C,I] = max((LIKIMAT.VFI.ME20(2,:)));
plot([gammagrid(I),gammagrid(I)],[180 280]*samplesize/100,'linewidth',1,'color','r','linestyle',':')
plot([1 1],[180 280]*samplesize/100,'linewidth',2','color','k')
xlabel('Parameter \gamma')
ylabel('Likelihood (log scale)')

subplot(326)
plot(gammagrid, smooth(LIKIMAT.VFI.INV(2,:)),'-','LineWidth',3); hold on
plot(gammagrid, smooth(LIKIMAT.OCC.ME20(2,:)),'--','LineWidth',3); 
title({'Some Solution Error,', '20% Measurement Error'})
legend('VFI,IF','OCC,PF 20%','Location','South'); legend boxoff; xlim([0 4.5]); ylim([180 280]*samplesize/100);
[C,I] = max((LIKIMAT.OCC.ME20(2,:)));
plot([gammagrid(I),gammagrid(I)],[180 280]*samplesize/100,'linewidth',1,'color','r','linestyle',':')
plot([1 1],[180 280]*samplesize/100,'linewidth',2','color','k')
xlabel('Parameter \gamma')


print(1,'-dpdf','-r300','Figure2.pdf');

