[ P, logz, probst, alambda, asigmay ] = markovappr(RHO,STD_U/(1-RHO^2)^.5,widthz,nz) ;
Z=exp(logz);

bmin=0.75*M;
simB1=M;
bmax=M*Z(end) ;

RHOB=0;


B=linspace(bmin,bmax,nb);


%-----------------------------------------------------
% Initialization of value function
%-----------------------------------------------------

v=ones(nz,nb);
c=ones(1,nb);

V = ones(nz,nb)/(1-BETA);




%-----------------------------------------------------
% Iterate on value function until convergence
%-----------------------------------------------------

diffV   = 1;
iter    = 1;

% Initialize choices and value
newV = V;
EV = V;
idecB = zeros(nz,nb);
BPRIME = B ;


while (iter <= 500) && (diffV > 1e-8)

    % Calculate expected future value
    EV(:,1:nb)=P*V(:,1:nb) ;
    

     
    for iz = 1:nz
        BETAEV=BETA*EV(iz,:); 
        ZB=Z(iz)+BPRIME;
        for ib = 1:nb
            
            c = max( 1e-200, ZB - R*B(ib) ) ;
            c(BPRIME>M*Z(iz))=1e-200;
            
            if GAMMAC==1
            v = log(c) + BETAEV ;
            else
            v = ((c).^(1-GAMMAC))/(1-GAMMAC) + BETAEV ;
            end
 
            % "c", "v", EV(iz,:) are vectors of size [1,nb] 
            % We look in each state for the BPRIME that maximizes v

            [newV(iz,ib), idecB(iz,ib)] = max ( v ) ;

        end
    end

    
    % Use howard improvement algorithm to speed up calculationb
    vincent_hwd

    diffV = max(abs((newV(:)-V(:))./newV(:)));
    iter  = iter + 1;
    V     = newV ;
    disp(diffV);
    
end


%-----------------------------------------------------
% Calculate Decision Rules
%-----------------------------------------------------
Cdec = NaN*Bdec;

% Calculate policy function for C: Cdec
for iz = 1:nz
  for ib = 1:nb
    Cdec(iz,ib) = max( 1e-200, Z(iz) + Bdec(iz,ib) - R*B(ib) )  ;
  end
end

clear Cdecinterp ECdec ECdec_old INV* newV Zm Cd Cm U Bm