* ----------------------------------------------------------
* Table C2: Both proxies strong, but both noisy
* Table C3: Both proxies weak, but both precise
* Table C4: Both weak and both noisy
* Table C5: One weak and noisy, the other strong and precise
* Table C6: One weak and noisy, the other strong but noisy
* Table C7: One weak and noisy, the other weak but precise
* ----------------------------------------------------------


clear all
set scheme s1color 

set seed 1234


program define mc_two_proxies, rclass
syntax , N1(string) B(string) GA(string) GB(string) VARX(string) VARE(string)  VARUA(string) VARUB(string) COVU(string) H(string) 

* DGP 
drop _all

local n2 = `n1'
global n = `n1'+`n2'
global from = `n1'+1
set obs $n
gen 	sample = 1
replace sample = 2 in $from/$n

gen double x = rnormal(0, sqrt(`varx'))


matrix U = (`vare', 0, 0 \ 0, `varua', `covu' \ 0, `covu', `varub')
mat list U
drawnorm u1 u2 u3, cov(U)

gen double e  = u1*sqrt(exp(`h'*x))
gen double y  = 1 + `b'*x + e  
gen double uA = u2*sqrt(exp(`h'*y))
gen double uB = u3*sqrt(exp(`h'*y))


gen 	zA = 1 + `ga'*y + uA
gen 	zB = 1 + `gb'*y + uB

replace x=. if sample==1
replace y=. if sample==2




* RRP 
reg y if sample==1, r
scalar R2_A = e(r2)
reg y zA zB   if sample==1, r
est store stage1
scalar R2_B = e(r2)
scalar Rsq = (R2_B-R2_A)/(1-R2_A)

return scalar R2 = Rsq

if `h'==0 {
	rrp x  if sample==2, impute(yhat) proxies(zA zB) partialrsq(Rsq) first(stage1)
}
else {
	rrp x  if sample==2, impute(yhat) proxies(zA zB) partialrsq(Rsq) first(stage1) robust
}

return scalar  bRRP    =   _b[x]

drop yhat 

local b0hat  = _b[_cons]*Rsq
local bhat   = _b[x]
reg zA y
local g0Ahat = _b[_cons]
local gAhat  = _b[y]
reg zB y
local g0Bhat = _b[_cons]
local gBhat  = _b[y]

gen double vA = (zA - `g0Ahat' - `gAhat'*`b0hat' - `gAhat'*`bhat'*x) if sample==2
gen double vB = (zB - `g0Bhat' - `gBhat'*`b0hat' - `gBhat'*`bhat'*x) if sample==2
expand 2 if sample==2, gen(dup)
gen ndup=1-dup
gen double v=vA*(1-dup)+vB*dup 
gen double xdup=x*dup
if `h'==0 {
	regress v dup ndup x xdup, nocons 
}
else {
	regress v dup ndup x xdup, nocons robust
}
test dup ndup x xdup
return scalar RRPp = r(p)
drop if dup==1
drop vA vB v dup ndup xdup


* GMM 
gen	s1 = 0
replace s1 = 1 if sample==1
gen	s2 = 0
replace s2 = 1 if sample==2

if `h'==0 {
gmm (zA*s1 - {gA0} - {gA1}*y*s1) ///
    (zA*s2 - {gA0} - {gA1}*{b0} - {gA1}*{b1}*x*s2) ///
    (zB*s1 - {gB0} - {gB1}*y*s1) ///
    (zB*s2 - {gB0} - {gB1}*{b0} - {gB1}*{b1}*x*s2) , ///
    instruments(1: y ) instruments(2: x) instruments(3: y ) instruments(4: x) ///
    twostep winitial(identity) nocommonesample  ///
    deriv(1/gA0 = -1)              ///
    deriv(1/gA1 = -y*s1)           ///
    deriv(2/gA0 = -1)              ///
    deriv(2/gA1 = -{b0}-{b1}*x*s2) ///
    deriv(2/b0 = -{gA1})           ///
    deriv(2/b1 = -{gA1}*x*s2)      ///
    deriv(3/gB0 = -1)              ///
    deriv(3/gB1 = -y*s1)           ///
    deriv(4/gB0 = -1)              ///
    deriv(4/gB1 = -{b0}-{b1}*x*s2) ///
    deriv(4/b0 = -{gB1})           ///
    deriv(4/b1 = -{gB1}*x*s2)  
}
else {
gmm (zA*s1 - {gA0} - {gA1}*y*s1) ///
    (zA*s2 - {gA0} - {gA1}*{b0} - {gA1}*{b1}*x*s2) ///
    (zB*s1 - {gB0} - {gB1}*y*s1) ///
    (zB*s2 - {gB0} - {gB1}*{b0} - {gB1}*{b1}*x*s2) , ///
    instruments(1: y ) instruments(2: x) instruments(3: y ) instruments(4: x) ///
    twostep winitial(identity) nocommonesample  ///
    deriv(1/gA0 = -1)              ///
    deriv(1/gA1 = -y*s1)           ///
    deriv(2/gA0 = -1)              ///
    deriv(2/gA1 = -{b0}-{b1}*x*s2) ///
    deriv(2/b0 = -{gA1})           ///
    deriv(2/b1 = -{gA1}*x*s2)      ///
    deriv(3/gB0 = -1)              ///
    deriv(3/gB1 = -y*s1)           ///
    deriv(4/gB0 = -1)              ///
    deriv(4/gB1 = -{b0}-{b1}*x*s2) ///
    deriv(4/b0 = -{gB1})           ///
    deriv(4/b1 = -{gB1}*x*s2) vce(robust) 
}

return scalar  bAM =  _b[/b1]
return scalar converged =  e(converged)

estat overid
return scalar AMp=r(J_p)

end




* Replications


drop _all
local MC = 10000



*** one weak and noisy, the other varying weak/strong and noisy/precise 

foreach ga     in .3  {
foreach gb     in .3 .6 {
foreach varua  in 2    {
foreach varub  in 2 1    {
foreach n1     in 100 400 800 {
foreach h      in .0 .3   {
foreach b      in 1 2 {	
foreach covu   in .2 .8  {
foreach varx   in 1    {
foreach vare   in 1   {



preserve
simulate R2=r(R2) bRRP=r(bRRP) bAM=r(bAM) RRPp=r(RRPp) AMp=r(AMp) converged=r(converged) , reps(`MC'): mc_two_proxies, n1(`n1') b(`b') ga(`ga') gb(`gb') varx(`varx') vare(`vare') varua(`varua') varub(`varub') covu(`covu') h(`h') 

drop if converged==0     

gen BiasRRP = bRRP - `b'
gen BiasAM  = bAM  - `b'

sum bRRP, d
gen ADbRRP = abs(bRRP-r(p50))

sum bAM, d
gen ADbAM = abs(bAM-r(p50))

gen rejRRPp  = (RRPp<0.05)
gen rejAMp   = (AMp <0.05)

cor RRPp AMp
gen double pcor = r(rho)

gen ga=`ga'
gen gb=`gb'
gen varua=`varua'
gen varub=`varub'
gen h=`h'
gen n1=`n1'
gen b=`b'
gen covu=`covu'
save sim_`ga'_`gb'_`varua'_`varub'_`h'_`n1'_`b'_`covu' , replace


collapse  (mean) R2= R2 MeanBiasRRP= BiasRRP MeanBiasAM= BiasAM rejRRPp=rejRRPp rejAMp=rejAMp pcor=pcor (median) MADbRRP = ADbRRP MADbAM = ADbAM (sd) SDbRRP = bRRP SDbAM = bAM 

gen double n1     = `n1'
gen double b      = `b'
gen double ga     = `ga'
gen double gb     = `gb'
gen double varx   = `varx'
gen double vare   = `vare'
gen double varua  = `varua'
gen double varub  = `varub'
gen double covu   = `covu'
gen double h      = `h'

save temp, replace
restore 
append using temp

}
}
}
}
}
}
}
}
}
}



*** both precise but weak  

local ga     = .3
local gb     = .3
local varua  = 1
local varub  = 1


foreach n1     in 100 400 800 {
foreach h      in .0 .3   {
foreach b      in 1 2 {	
foreach covu   in .2 .8  {
foreach varx   in 1    {
foreach vare   in 1   {




preserve
simulate R2=r(R2) bRRP=r(bRRP) bAM=r(bAM) RRPp=r(RRPp) AMp=r(AMp) converged=r(converged) , reps(`MC'): mc_two_proxies, n1(`n1') b(`b') ga(`ga') gb(`gb') varx(`varx') vare(`vare') varua(`varua') varub(`varub') covu(`covu') h(`h') 

drop if converged==0     

gen BiasRRP = bRRP - `b'
gen BiasAM  = bAM  - `b'

sum bRRP, d
gen ADbRRP = abs(bRRP-r(p50))

sum bAM, d
gen ADbAM = abs(bAM-r(p50))

gen rejRRPp  = (RRPp<0.05)
gen rejAMp   = (AMp <0.05)

cor RRPp AMp
gen double pcor = r(rho)

gen ga=`ga'
gen gb=`gb'
gen varua=`varua'
gen varub=`varub'
gen h=`h'
gen n1=`n1'
gen b=`b'
gen covu=`covu'
save sim_`ga'_`gb'_`varua'_`varub'_`h'_`n1'_`b'_`covu' , replace

collapse  (mean) R2= R2 MeanBiasRRP= BiasRRP MeanBiasAM= BiasAM rejRRPp=rejRRPp rejAMp=rejAMp pcor=pcor  (median) MADbRRP = ADbRRP MADbAM = ADbAM (sd) SDbRRP = bRRP SDbAM = bAM 

gen double n1     = `n1'
gen double b      = `b'
gen double ga     = `ga'
gen double gb     = `gb'
gen double varx   = `varx'
gen double vare   = `vare'
gen double varua  = `varua'
gen double varub  = `varub'
gen double covu   = `covu'
gen double h      = `h'

save temp, replace
restore 
append using temp

}
}
}
}
}
}




*** both strong but noisy 


local ga     = .6
local gb     = .6
local varua  = 2
local varub  = 2


foreach n1     in 100 400 800 {
foreach h      in .0 .3   {
foreach b      in 1 2 {	
foreach covu   in .2 .8  {
foreach varx   in 1    {
foreach vare   in 1   {



preserve
simulate R2=r(R2) bRRP=r(bRRP) bAM=r(bAM) RRPp=r(RRPp) AMp=r(AMp) converged=r(converged) , reps(`MC'): mc_two_proxies, n1(`n1') b(`b') ga(`ga') gb(`gb') varx(`varx') vare(`vare') varua(`varua') varub(`varub') covu(`covu') h(`h') 

drop if converged==0     

gen BiasRRP = bRRP - `b'
gen BiasAM  = bAM  - `b'

sum bRRP, d
gen ADbRRP = abs(bRRP-r(p50))

sum bAM, d
gen ADbAM = abs(bAM-r(p50))

gen rejRRPp  = (RRPp<0.05)
gen rejAMp   = (AMp <0.05)

cor RRPp AMp
gen double pcor = r(rho)

gen ga=`ga'
gen gb=`gb'
gen varua=`varua'
gen varub=`varub'
gen h=`h'
gen n1=`n1'
gen b=`b'
gen covu=`covu'
save sim_`ga'_`gb'_`varua'_`varub'_`h'_`n1'_`b'_`covu' , replace

collapse  (mean) R2= R2 MeanBiasRRP= BiasRRP MeanBiasAM= BiasAM rejRRPp=rejRRPp rejAMp=rejAMp  pcor=pcor (median) MADbRRP = ADbRRP MADbAM = ADbAM (sd) SDbRRP = bRRP SDbAM = bAM 

gen double n1     = `n1'
gen double b      = `b'
gen double ga     = `ga'
gen double gb     = `gb'
gen double varx   = `varx'
gen double vare   = `vare'
gen double varua  = `varua'
gen double varub  = `varub'
gen double covu   = `covu'
gen double h      = `h'

save temp, replace
restore 
append using temp

}
}
}
}
}
}


rm temp.dta


order ga gb varua varub h n1 b covu R2 h

drop vare varx 
bro



clear all
foreach ga     in .3 .6 {
foreach gb     in .3 .6 {
foreach varua  in 2 1   {
foreach varub  in 2 1    {
foreach h      in .0 .3   {
foreach n1     in 100 400 800 {
foreach b      in 1 2 {	
foreach covu   in .2 .8  {
cap append using sim_`ga'_`gb'_`varua'_`varub'_`h'_`n1'_`b'_`covu' 
}
}
}
}
}
}
}
}



*save pool_simulations, replace

collapse  (mean) R2= R2 MeanBiasRRP= BiasRRP MeanBiasAM= BiasAM  rejRRPp=rejRRPp rejAMp=rejAMp  pcor=pcor  (median) MADbRRP = ADbRRP MADbAM = ADbAM (sd) SDbRRP = bRRP SDbAM = bAM , by(ga gb varua varub h n1 b covu)


format MeanBias* SDb* MAD* rej*  %9.3f
format R2 pcor %9.2f

bysort ga gb varua varub h: list n1 b covu R2 MeanBias* SDb* MAD* rej* pcor , sep(4)

















