* ---------------------------------
* Table C1
* Monte Carlo Experiment: One proxy
* ---------------------------------

clear all
set scheme s1color 

set seed 12345


program define mc_one_proxy, rclass
syntax , N1(string) N2(string) B(string) GA(string) GB(string) VARX(string) VARE(string)  VARUA(string) VARUB(string) COVU(string) H(string) 


drop _all

global n = `n1'+`n2'
global from = `n1'+1
set obs $n
gen 	sample = 1
replace sample = 2 in $from/$n

gen double x = rnormal(0, sqrt(`varx'))


matrix U = (`vare', 0 \ 0, `varua')
mat list U
drawnorm u1 u2, cov(U)

gen double e  = u1*sqrt(exp(`h'*x))
gen double y  = 1 + `b'*x + e  
gen double uA = u2*sqrt(exp(`h'*y))

gen 	zA = 1 + `ga'*y + uA

replace x=. if sample==1
replace y=. if sample==2


* RP 
reg y zA if sample==1
predict yhat 

if `h'==0 {
	reg yhat x if sample==2
}
else {
	reg yhat x if sample==2, vce(robust)
}

return scalar  bRP    =   _b[x]
return scalar seRP    =  _se[x]
sum yhat
return scalar ymRP    =  r(mean)
return scalar yvRP    =  r(Var)


drop yhat


* RP+ 
reg y zA if sample==1
predict yhat 
local Sigma_error = e(rmse)
gen error = rnormal(0, `Sigma_error')
replace yhat = yhat + error

if `h'==0 {
	reg yhat x if sample==2
}
else {
	reg yhat x if sample==2, vce(robust)
}

return scalar  bRPp    =   _b[x]
return scalar seRPp    =  _se[x]

sum yhat
return scalar ymRPp    =  r(mean)
return scalar yvRPp    =  r(Var)

drop yhat error



* RRP 
reg y if sample==1, r
scalar R2_A = e(r2)
reg y zA if sample==1, r
est store stage1
scalar R2_B = e(r2)
scalar Rsq = (R2_B-R2_A)/(1-R2_A)

return scalar R2 = Rsq


if `h'==0 {
	rrp x  if sample==2, impute(yhat) proxies(zA) partialrsq(Rsq) first(stage1)
}
else {
	rrp x  if sample==2, impute(yhat) proxies(zA) partialrsq(Rsq) first(stage1) robust
}

return scalar  bRRP    =   _b[x]
return scalar seRRP    =  _se[x]

if `h'==0 {
	reg yhat x if sample==2
}
else {
	reg yhat x if sample==2, vce(robust)
}

return scalar   seRRPols  =  _se[x]

sum yhat
return scalar ymRRP    =  r(mean)
return scalar yvRRP    =  r(Var)

drop yhat 


* BPP 
reg zA y if sample==1
gen yhat = (zA - _b[_cons]) / _b[y]


if `h'==0 {
	reg yhat x if sample==2
}
else {
	reg yhat x if sample==2, vce(robust)
}


return scalar  bBPPa    =   _b[x]
return scalar seBPPa    =  _se[x]

sum yhat
return scalar ymBPPa    =  r(mean)
return scalar yvBPPa    =  r(Var)

drop yhat


* AM 
gen	s1 = 0
replace s1 = 1 if sample==1
gen	s2 = 0
replace s2 = 1 if sample==2

if `h'==0 {
	gmm (zA*s1 - {gA0} - {gA1}*y*s1) ///
    (zA*s2 - {gA0} - {gA1}*{b0} - {gA1}*{b1}*x*s2) , ///
    instruments(1: y ) instruments(2: x)  ///
    twostep winitial(identity) nocommonesample  ///
    deriv(1/gA0 = -1)              ///
    deriv(1/gA1 = -y*s1)           ///
    deriv(2/gA0 = -1)              ///
    deriv(2/gA1 = -{b0}-{b1}*x*s2) ///
    deriv(2/b0 = -{gA1})           ///
    deriv(2/b1 = -{gA1}*x*s2) 
}
else {
	gmm (zA*s1 - {gA0} - {gA1}*y*s1) ///
    (zA*s2 - {gA0} - {gA1}*{b0} - {gA1}*{b1}*x*s2) , ///
    instruments(1: y ) instruments(2: x)  ///
    twostep winitial(identity) nocommonesample  ///
    deriv(1/gA0 = -1)              ///
    deriv(1/gA1 = -y*s1)           ///
    deriv(2/gA0 = -1)              ///
    deriv(2/gA1 = -{b0}-{b1}*x*s2) ///
    deriv(2/b0 = -{gA1})           ///
    deriv(2/b1 = -{gA1}*x*s2)  vce(robust)
}


    
return scalar  bAM =  _b[/b1]
return scalar seAM = _se[/b1]
return scalar converged =  e(converged)


end



drop _all
local MC = 10000

foreach n1     in 400 {
foreach n2     in `n1' {
foreach b      in 1 {
foreach ga     in .5 {
foreach gb     in `ga'{
foreach varx   in 1    {
foreach vare   in 1   {
foreach varua  in 1    {
foreach varub  in 1    {
foreach covu   in .2   {
foreach h      in .0 .3   {


preserve
simulate bRP=r(bRP) seRP=r(seRP) bRPp=r(bRPp) seRPp=r(seRPp) R2=r(R2) bRRP=r(bRRP) seRRP=r(seRRP) seRRPols=r(seRRPols) bBPPa=r(bBPPa) seBPPa=r(seBPPa) bAM=r(bAM) seAM=r(seAM) converged=r(converged) ymRP = r(ymRP) yvRP = r(yvRP) ymRPp = r(ymRPp) yvRPp = r(yvRPp) ymRRP = r(ymRRP) yvRRP = r(yvRRP) ymBPPa = r(ymBPPa) yvBPPa = r(yvBPPa) , reps(`MC'): mc_one_proxy, n1(`n1')  n2(`n2') b(`b') ga(`ga') gb(`gb') varx(`varx') vare(`vare') varua(`varua') varub(`varub') covu(`covu') h(`h') 

drop if converged==0     

collapse  (mean) bRP= bRP seRP= seRP bRPp= bRPp seRPp= seRPp R2= R2 bRRP= bRRP seRRP= seRRP seRRPols= seRRPols bBPPa= bBPPa seBPPa= seBPPa bAM= bAM seAM= seAM ymRP = ymRP yvRP = yvRP ymRPp = ymRPp yvRPp = yvRPp ymRRP = ymRRP yvRRP = yvRRP ymBPPa = ymBPPa yvBPPa = yvBPPa  (sd) SDbRP = bRP SDbRPp = bRPp SDbRRP = bRRP SDbBPPa = bBPPa SDbAM = bAM



gen double n1     = `n1'
gen double n2     = `n2'
gen double b      = `b'
gen double ga     = `ga'
gen double gb     = `gb'
gen double varx   = `varx'
gen double vare   = `vare'
gen double varua  = `varua'
gen double varub  = `varub'
gen double covu   = `covu'
gen double h      = `h'
save temp, replace
restore 
append using temp

}
}
}
}
}
}
}
}
}
}
}

order b* SD* se* ym* yv* 
format b* SD* se* ym* yv* %9.3f



list bRP-bAM  h
list SDbRP-SDbAM h
list seRP-seAM h
list ymRP-ymBPPa h
list yvRP-yvBPPa h




