clear all
set obs 200
gen sample = 1
replace sample = 2 in 101/200

gen double x = rnormal(0, 1)
gen double e = rnormal(0, 1)
gen double u = rnormal(0, 1)
gen double y = 1 + 1*x + e
gen double z = 1 + .5*y + u

replace x=. if sample==1
replace y=. if sample==2

reg y if sample==1
scalar R2_A = e(r2)
reg y z if sample==1
mat coef    = e(b)
mat vars    = e(V)
scalar n1   = e(N)
scalar R2_B = e(r2)
scalar Rsq  = (R2_B-R2_A)/(1-R2_A)
predict yhat
replace yhat=yhat/Rsq
foreach var in z {
	mat gamma   = nullmat(gamma),coef[1,"`var'"]
	mat varcols = nullmat(varcols),vars[.,"`var'"]
}
foreach var in z {
	mat Vg = nullmat(`Vg')\ varcols["`var'",.]
}
mat list gamma
mat list varcols
mat list Vg

reg yhat x if sample==2
scalar n2 = e(N)
mat Vb    = e(V)
matrix accum Z1X = z x if sample==2
scalar p  = colsof(gamma)
scalar v  = colsof(Z1X)-p
scalar p1 = p+1
scalar pv = p+v
mat ZZ    = Z1X[1..p, 1..p]
mat XX    = Z1X[p1..pv, p1..pv]
mat XZ    = Z1X[p1..pv,1.. p]
mat ZX    = XZ'
mat Vnew  = Vb + (n2/n1)*syminv(XX)*XZ*Vg*ZX*syminv(XX)/Rsq/Rsq

program define reg_correctSE, eclass
        ereturn repost V = Vnew
        reg
end

reg_correctSE


