
use "cexexp", clear

gen monthlyutilities = UTILITIES - motfuel
gen monthlyfoodin = FOODIN
gen monthlyfoodout = FOODOUT
gen monthlynondurable_psid = CLOTHING + FOODIN + FOODOUT + LEISURE + UTILITIES + motorins + trepair

foreach var in utilities foodin foodout nondurable_psid {
	egen `var' = sum(monthly`var'), by(datayear newid)
}

bys datayear newid (spend_mo): gen count = _n
keep if count==1
drop count

keep newid utilities foodin foodout nondurable_psid
 
merge 1:m newid using "cexdemogs"
drop if _merge!=3
drop _merge

*generate a family size variable
bys newid: gen numpeeps = _N

keep if head==1

*identify households whose last interview was in one of the psid waves
gen interviewedinpsidyeartemp = 1 if intno==5 & (int_yr==1999|int_yr==2001|int_yr==2003|int_yr==2005|int_yr==2007|int_yr==2009|int_yr==2011|int_yr==2013)
egen interviewedinpsidyear = min(interviewedinpsidyeartemp), by(cuid)
drop interviewedinpsidyeartemp

bys cuid (intno): gen n= _N
assert n<=4
keep if n==4 & interviewedinpsidyear==1
keep if intno==5
drop n

foreach var in utilities foodin foodout {
	egen mean`var' = mean(`var'), by(cuid)
	replace `var'= mean`var'
	*annualise
	replace `var' = `var'*4
	drop mean`var'
}

gen year = int_yr
merge m:1 year using "cpi"
drop if _merge==2
drop _merge
 
gen allfood = foodin + foodout

foreach var in utilities foodin foodout allfood salaryx nondurable_psid {
	gen r`var' = `var'/cpi
	gen lnr`var' = ln(r`var')
}

gen bandedncars = max(vehq,2)

gen owner = inlist(cutenure,1,2)

gen age2 = age^2
replace sex = 0 if sex==2

*prepare heads earnings
gen lnrearnings_head = lnrsalaryx
*dummy for those who are unemployed and so have zero earnings
gen rearnings_head_zero = (!inlist(employstat,1,2)) 
replace lnrearnings_head=0 if rearnings_head_zero==1

keep if (int_yr==1999|int_yr==2001|int_yr==2003|int_yr==2005|int_yr==2007|int_yr==2009|int_yr==2011|int_yr==2013)

*drop redundant variables
drop fssix unemplx welfarex intearnx savacctx ckbkactx usbndx secestx occucode grospayx payperd finincx salaryx salaryx_t incweekq inc_hrsq reltohoh incnonwk employstat spouseinhh vehq

export delimited "cexdata.csv", replace

