/*

This do file can be used to generate results from

Measurement Error in Discrete Health Facility Choice Models:an Example from Urban Senegal
Authors: Christopher J. Cronin, David K. Guilkey, Ilene S. Speizer

To generate the data file MaternalCareChoice.dta, see Clean_Data.do

*/

* NUISANCE DATA FILES AND THE ESTIMATION DATA FILE WILL BE STORED HERE:
cd "XXX"





***********************
** Sample Statistics
***********************

set more off
set seed 12353
set matsize 800

**************
* Make Table 1
**************

use "MaternalCareChoice.dta", clear

*
ta choice_1 if indid!=indid[_n-1]
*

drop if choice_1!=1
drop if facid=="9990"|facid=="9991"
sort indid distance
gen count=0
replace count=1 if facid==mcid & indid!=indid[_n-1]

*
ta count if indid!=indid[_n-1]
*
drop count

gen n_factype=.
replace n_factype=1 if factype==11
replace n_factype=2 if factype==12
replace n_factype=2 if factype==13
replace n_factype=2 if factype==16
replace n_factype=3 if factype==21
replace n_factype=3 if factype==26
replace n_factype=4 if factype==22
replace n_factype=4 if factype==31
label define types 1 "1.Public Hospital" 2 "2.Other Public" 3 "3.Private" 4 "4.Denom/NGO"
label values n_factype types
sort indid n_factype distance
gen count=0
replace count=1 if facid==mcid & n_factype!=n_factype[_n-1]
replace count=1 if facid==mcid & indid!=indid[_n-1]
gsort indid -count 

*
su count if indid!=indid[_n-1]
*

sort indid distance

gen counter=0 if facid==mcid
forvalues i=1/250{
replace counter=counter+1 if indid==indid[_n-`i'] & facid==mcid
}

*
su counter, detail
*

**************
* Make Table 2
**************

use "$path/MaternalCareChoice.dta", clear

drop if facid=="9990"|facid=="9991"

gen n_factype=.
replace n_factype=1 if factype==11
replace n_factype=2 if factype==12
replace n_factype=2 if factype==13
replace n_factype=2 if factype==16
replace n_factype=3 if factype==21
replace n_factype=3 if factype==26
replace n_factype=4 if factype==22
replace n_factype=4 if factype==31
label define types 1 "1.Public Hospital" 2 "2.Other Public" 3 "3.Private" 4 "4.Denom/NGO"
label values n_factype types

ta n_factype, gen(ft)

rename ft1 Pub_Hosp
rename ft2 Pub_Oth
rename ft3 Priv
rename ft4 Dnm_NGO

*col. 1
su distance

su Pub_Hosp Pub_Oth Priv Dnm_NGO participate if indid=="100302404" 

su fage openall hours anyiec ndoc nnurse nmidw ahsw /*
*/ offernum commtlk electric pwater phone privrm if participate==1 & indid=="100302404"

*col 2
su distance Pub_Hosp Pub_Oth Priv Dnm_NGO participate if choice_2==1

su fage openall hours anyiec ndoc nnurse nmidw ahsw /*
*/ offernum commtlk electric pwater phone privrm if participate==1 & choice_2==1


*col 3
sort indid distance

su distance Pub_Hosp Pub_Oth Priv Dnm_NGO participate if choice_1==1 & indid!=indid[_n-1]

su fage openall hours anyiec ndoc nnurse nmidw ahsw /*
*/ offernum commtlk electric pwater phone privrm if choice_1==1 & indid!=indid[_n-1] & participate==1















**************************
* Make Table A1, A2, and 3 
**************************

** first, create weights and merge in

use "MaternalCareChoice.dta", clear

*Create weights for all weighted regressions

keep if indid!=indid[_n-1]

order indid choice_1 choice_2 facid - age agesq - _Ises1_5 eduL1-eduL4 muslim - prego child2009 partner - pmorchld paccomphf2-ownbicycle Guediawaye - Kaolack /*
*/ num_Pub_Hos-num_Dnm_NGO num_pharmacy allnonpat ave_hf_dist-prb_hf_privrm

foreach x of varlist _Ises1_2-Kaolack ave_hf_dist{
gen age_`x'=age*`x'
}

foreach x of varlist age-_Ises1_5 muslim-Kaolack ave_hf_dist{
gen edu_`x'=(eduL3+eduL4)*`x'
}

********************
** Appendix table A2
********************
mlogit choice_1 age-prb_hf_privrm age__Ises1_2 - edu_ave_hf_dist

predict p1,outcome(1)  
keep indid p1
sort indid
save temp1_all,replace

*Merge in weights
use "MaternalCareChoice.dta", clear
merge indid using temp1_all
drop _merge

sort indid

gen wp1=1/p1  
label var wp1 "inverse probability weights"

*Manipulate data for estimation
drop if choice_1!=1
drop if facid=="9991"|facid=="9990"

gen n_factype=.
replace n_factype=1 if factype==11
replace n_factype=2 if factype==12
replace n_factype=2 if factype==13
replace n_factype=2 if factype==16
replace n_factype=3 if factype==21
replace n_factype=3 if factype==26
replace n_factype=4 if factype==22
replace n_factype=4 if factype==31
label define types 1 "1.Public Hospital" 2 "2.Other Public" 3 "3.Private" 4 "4.Denom/NGO"
label values n_factype types

ta n_factype, gen(ft)

rename ft1 Pub_Hosp
rename ft2 Pub_Oth
rename ft3 Priv
rename ft4 Dnm_NGO

gen Priv_Dnm_NGO=(Priv==1|Dnm_NGO==1)

gen price=.
replace price=7.5 if factype==11
replace price=3 if factype==12|factype==13|factype==16
replace price=15 if factype==22|factype==31
replace price=30 if factype==26
replace price=300 if factype==21

save "mc_weights_all.dta", replace

**************************
** Appendix table A1 and 3
**************************


** Col. 1, A1
use "mc_weights_all.dta", clear

local hfvars distance Pub_Oth Priv Dnm_NGO participate fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm

clogit choice_2 `hfvars', group(indid) cluster(indid)
estimates store CL1

* McFadden and Train (2000) test
predict prob
foreach x of local hfvars {
egen new_`x' = total(`x'*prob), by(indid)
gen w_`x'= .5*(`x'-new_`x')^2
}

local w_hfvars w_distance w_Pub_Oth w_Priv w_Dnm_NGO w_participate w_fage w_openall w_hours w_ndoc w_nnurse w_nmidw w_ahsw w_offernum w_anyiec w_commtlk /*
*/ w_electric w_phone w_privrm

qui clogit choice_2 `hfvars' `w_hfvars', group(indid) cluster(indid)
estimates store CL2

lrtest CL1 CL2, force


** Col. 2, A1 (which is also Table 3)
destring indid, replace

mixlogit choice_2, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)


** Col. 3, A1
clogit choice_2 `hfvars' [pweight=wp1], group(indid) cluster(indid)
estimates store CL1W

* McFadden and Train (2000) test for weighted model
qui clogit choice_2 `hfvars' `w_hfvars' [pweight=wp1], group(indid) cluster(indid)
estimates store CL2W

lrtest CL1W CL2W, force


** Col. 4, A1 
mixlogit choice_2 [pweight=wp1], group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)











*****************
* Make Table A3 
*****************


* Col. 1
drop if participate==0

local hfvars distance Pub_Oth Priv Dnm_NGO fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm

mixlogit choice_2, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)


* Prepare for Col. 2 and 3
clear
set more off
set seed 12353
set matsize 1000

use "mc_weights_all.dta", clear

drop if choice_1!=1
drop if facid=="9991"|facid=="9990"
destring indid, replace

gen HomeRegion=(Dakar==1|Guediawaye==1|Mbao==1|Pikine==1)
replace HomeRegion=2 if Mbour==1
replace HomeRegion=3 if Kaolack==1

gen FacRegion=(city<5)
replace FacRegion=2 if city==5
replace FacRegion=3 if city==6

ta HomeRegion FacRegion if choice_2==1

local hfvars distance Pub_Oth Priv Dnm_NGO participate fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm

* Col. 2
drop if HomeRegion!=FacRegion & choice_2==1

mixlogit choice_2, group(indid) rand(`hfvars') cluster(indid) nrep(50)

* Col. 3
keep if HomeRegion==FacRegion

mixlogit choice_2, group(indid) rand(`hfvars') cluster(indid) nrep(50)
















*****************
* Make Table A4 
*****************
use "mc_weights_all.dta", clear

local hfvars distance Pub_Oth Priv Dnm_NGO participate fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm

destring indid, replace

mixlogit choice_2 [pweight=wp1], group(indid) rand(`hfvars') cluster(indid) nrep(400) iter(100)








*****************
* Make Table A5 
*****************
clear
set more off
set seed 12353

use "MaternalCareChoice.dta", clear
drop if choice_1!=1
drop if facid=="9990"|facid=="9991"


** Col. 1

gen price=.
replace price=7.5 if factype==11
replace price=3 if factype==12|factype==13|factype==16
replace price=15 if factype==22|factype==31
replace price=30 if factype==26
replace price=300 if factype==21

local hfvars distance price fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm participate

clogit choice_2 `hfvars' , group(indid) vce(cl indid)


** Col. 2

local hfvars distance i.factype fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm participate

destring indid, replace

clogit choice_2 `hfvars', group(indid) vce(cl indid)












*****************
* Make Table A6 
*****************

set more off
set seed 12353
set matsize 1000

use "mc_weights_all.dta", clear

local hfvars distance Pub_Oth Priv Dnm_NGO participate fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm


** Col. 1
gen low_inc=1
replace low_inc=0 if _Ises1_3==1|_Ises1_4==1|_Ises1_5==1

foreach i in `hfvars'{
gen li_`i'=`i'*low_inc
}

local li_int li_distance - li_privrm

destring indid, replace

mixlogit choice_2 `li_int', group(indid) rand(`hfvars') cluster(indid) nrep(50)

** Col. 2
foreach i in `hfvars'{
gen le_`i'=`i'*eduL0
}

local le_int le_distance - le_privrm

destring indid, replace

mixlogit choice_2 `le_int', group(indid) rand(`hfvars') cluster(indid) nrep(50)









*************************
* Make Table 4, 5, and A7 
*************************

use "mc_weights_all.dta", clear

gen fac_type=.
replace fac_type=1 if Pub_Hosp==1 & Pub_Oth==0 & Priv==0 & Dnm_NGO==0
replace fac_type=2 if Pub_Hosp==0 & Pub_Oth==1 & Priv==0 & Dnm_NGO==0
replace fac_type=3 if Pub_Hosp==0 & Pub_Oth==0 & Priv==1 & Dnm_NGO==0
replace fac_type=4 if Pub_Hosp==0 & Pub_Oth==0 & Priv==0 & Dnm_NGO==1

ta fac_type

destring indid, replace

gen chosen_type=.
replace chosen_type=fac_type if mcid==facid
bysort indid (chosen_type) : replace chosen_type = chosen_type[1]
recode chosen_type .=0

ta chosen_type

sort indid fac_type distance
keep if fac_type!=fac_type[_n-1]
ta fac_type

gen choice2=0
replace choice2=1 if chosen_type==fac_type
ta choice2
ta fac_type if choice2==1

save "ME_all.dta", replace

* Col. 1, table 4

* Standard specification with clogit
local hfvars distance Pub_Oth Priv Dnm_NGO participate fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm

clogit choice2 `hfvars', group(indid) cluster(indid)            /* this is actually column 3*/


* Col. 2, Table 4 (see Table A1, Col. 1)

* Col. 3, Table 4

local hfvars distance participate fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/  electric phone privrm

mixlogit choice2 Pub_Oth Priv Dnm_NGO, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)

* Col. 1, Table A7
local hfvars distance price participate fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/  electric phone privrm

mixlogit choice2, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)


* Col. 4, Table 4

use "mc_weights_all.dta", clear

destring indid, replace

local hfvars distance participate fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm

mixlogit choice_2 Pub_Oth Priv Dnm_NGO, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)

* Col. 2, Table A7
local hfvars distance price participate fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm

mixlogit choice_2, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)

* Table 5 (see Table 4 results)











***************
* Make Table A8 
***************

use "mc_weights_all.dta", clear

destring indid, replace

local hfvars distance ahsw

* Col. 1
mixlogit choice_2, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)

* Col. 2

gen fac_type=.
replace fac_type=1 if Pub_Hosp==1 & Pub_Oth==0 & Priv==0 & Dnm_NGO==0
replace fac_type=2 if Pub_Hosp==0 & Pub_Oth==1 & Priv==0 & Dnm_NGO==0
replace fac_type=3 if Pub_Hosp==0 & Pub_Oth==0 & Priv==1 & Dnm_NGO==0
replace fac_type=4 if Pub_Hosp==0 & Pub_Oth==0 & Priv==0 & Dnm_NGO==1

ta fac_type

gen chosen_type=.
replace chosen_type=fac_type if mcid==facid
bysort indid (chosen_type) : replace chosen_type = chosen_type[1]

ta chosen_type

sort indid fac_type distance
keep if fac_type!=fac_type[_n-1] | mcid==facid

gen choice2=0
replace choice2=1 if mcid==facid
forvalues i=-5/5{
replace chosen_type=0 if choice2[_n+`i']==1 & indid==indid[_n+`i'] 
}
replace choice2=1 if fac_type==chosen_type
ta choice2

mixlogit choice2, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)

* Col. 3

use "mc_weights_all.dta", clear

destring indid, replace

local hfvars distance ahsw

gen fac_type=.
replace fac_type=1 if Pub_Hosp==1 & Pub_Oth==0 & Priv==0 & Dnm_NGO==0
replace fac_type=2 if Pub_Hosp==0 & Pub_Oth==1 & Priv==0 & Dnm_NGO==0
replace fac_type=3 if Pub_Hosp==0 & Pub_Oth==0 & Priv==1 & Dnm_NGO==0
replace fac_type=4 if Pub_Hosp==0 & Pub_Oth==0 & Priv==0 & Dnm_NGO==1

ta fac_type

gen chosen_type=.
replace chosen_type=fac_type if mcid==facid
bysort indid (chosen_type) : replace chosen_type = chosen_type[1]

ta chosen_type

sort indid fac_type distance
gen counter=1 if fac_type!=fac_type[_n-1]
replace counter=counter[_n-1]+1 if counter==.
keep if counter<=5 | mcid==facid
drop counter

gen choice2=0
replace choice2=1 if mcid==facid
// forvalues i=-5/5{
// replace chosen_type=0 if choice2[_n+`i']==1 & indid==indid[_n+`i'] 
// }
// replace choice2=1 if fac_type==chosen_type
// ta choice2

mixlogit choice2, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)

* Col. 4

use "mc_weights_all.dta", clear

destring indid, replace

local hfvars distance ahsw

gen fac_type=.
replace fac_type=1 if Pub_Hosp==1 & Pub_Oth==0 & Priv==0 & Dnm_NGO==0
replace fac_type=2 if Pub_Hosp==0 & Pub_Oth==1 & Priv==0 & Dnm_NGO==0
replace fac_type=3 if Pub_Hosp==0 & Pub_Oth==0 & Priv==1 & Dnm_NGO==0
replace fac_type=4 if Pub_Hosp==0 & Pub_Oth==0 & Priv==0 & Dnm_NGO==1

ta fac_type

gen chosen_type=.
replace chosen_type=fac_type if mcid==facid
bysort indid (chosen_type) : replace chosen_type = chosen_type[1]

ta chosen_type

sort indid fac_type distance
gen choice2=(fac_type==chosen_type & fac_type!=fac_type[_n-1])

mixlogit choice2, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)

* Col. 5

drop choice2

gen counter=1 if fac_type!=fac_type[_n-1]
replace counter=counter[_n-1]+1 if counter==.

gen choice2=(fac_type==chosen_type & counter==round(.5+3*runiform()))

mixlogit choice2, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)

* Col. 6

use "ME_all.dta", clear

local hfvars distance ahsw

mixlogit choice2, group(indid) rand(`hfvars') cluster(indid) nrep(50) iter(100)

















***************
* Make Table A9 
***************

use "ME_all.dta", clear

gen eduL2plus=(eduL2==1|eduL3==1|eduL4==1)
foreach i of varlist Pub_Oth Priv Dnm_NGO {
foreach j of varlist age eduL1 eduL2plus muslim worknow owntrans Guediawaye Pikine Mbao Mbour Kaolack _Ises1_2 _Ises1_3 _Ises1_4 _Ises1_5 {
gen `i'_`j' = `i'*`j'
}
}

local hfvars distance  fage openall hours ndoc nnurse nmidw ahsw offernum anyiec commtlk /*
*/ electric phone privrm participate
local ind Pub_Oth Pub_Oth_age - Pub_Oth__Ises1_5 Priv Priv_age - Priv__Ises1_5 Dnm_NGO Dnm_NGO_age - Dnm_NGO__Ises1_5

clogit choice2 `hfvars' `ind', group(indid) cluster(indid)            /* this is actually column 3*/









