clear all

// prog mata to compute the interval each duration belongs to
cap program drop Inter
mata:
	void Inter(string scalar t)
	{
	// import variables and matrices into mata
	st_view(vt,.,t)
	Tcut = st_matrix("Tcut")
	N = rows(vt)
	// interval to which t belongs (consider all intervals strictly included in [0,t] and add 1)
	Tcut_sup = Tcut[.,2..cols(Tcut)]
	nint = rowsum((vt :> (J(N,1,1) * Tcut_sup))) + J(N,1,1)
	// compute t minus the lower bound of the interval t belongs to
	Tcut_inf = Tcut[.,1..cols(Tcut) - 1]
	Ikt = (vt :> (J(N,1,1) * Tcut_inf)) :* ((vt :<= (J(N,1,1) * Tcut_sup))) 
	Ik_length = Tcut_sup-Tcut_inf,0
	lint = rowsum((vt * J(1,cols(Tcut) - 1,1) - J(N,1,1) * Tcut_inf) :* Ikt)
	// send results to stata
	st_addvar(("double", "double"), ("nint", "lint"))
	st_store(.,"nint",nint)
	st_store(.,"lint",lint)
	}
end

use table_75

drop *A1 *A2 *A3 *A4 *A5 *B1 *B2 *B3 *B4 *B5

// create intervals for piecewise constant hazards
foreach vv of varlist P Z Y{
	su t`vv' if `vv'==1, det
	_pctile t`vv' if `vv'==1, nq(11)
	matrix Tcut_`vv' = (0, r(r1), r(r2), r(r3), r(r4), r(r5), r(r6), r(r7), r(r8), r(r9), r(r10), .)
}
// length of each interval (used later to compute integrated hazard rates)
qui foreach vv of varlist P Z Y{
	local K_`vv' = colsof(Tcut_`vv')-2
	matrix LTcut_`vv' = Tcut_`vv'[1,2]
	foreach cc of numlist 2(1)`K_`vv''{
		matrix LTcut_`vv' = LTcut_`vv', Tcut_`vv'[1,`cc'+1]-Tcut_`vv'[1,`cc']
	}
	noi matrix list Tcut_`vv'
	noi matrix list LTcut_`vv'
}

gen la_P = .0001 if _n<1200
gen la_Z = .0001 if _n<1200
gen la_Y = .0001 if _n<1200

// results taken from estimation in estim_PminZY with K=2
matrix la_P = (   9.537113,   9.6372291,   9.8418243,   10.378356,   10.620476,   10.652683,   10.280072,   10.638303,   10.695249,   11.216232  )
matrix la_Z = (  9.1874534,   9.0148853,   8.9984458,   8.9808978,   8.9989469,   9.1619369,   9.2599856,   9.5100019,   9.6700191,   10.798227  )
matrix la_Y = (  8.4370248,   9.0404183,   9.1821782,   9.2980656,   9.2032322,   9.1423952,   9.2789357,   9.3796869,   9.3096287,   9.1191907  )

gen tt = _n if _n < 1200

foreach cc of numlist 1(1)10{
	replace la_P = exp(-la_P[1,`cc']) / (1+exp(-la_P[1,`cc'])) if tt > Tcut_P[1,`cc'+1] & tt<= Tcut_P[1,`cc'+2]
}
foreach cc of numlist 1(1)10{
	replace la_Z = exp(-la_Z[1,`cc']) / (1+exp(-la_Z[1,`cc'])) if tt > Tcut_Z[1,`cc'+1] & tt<= Tcut_Z[1,`cc'+2]
}
foreach cc of numlist 1(1)10{
	replace la_Y = exp(-la_Y[1,`cc']) / (1+exp(-la_Y[1,`cc'])) if tt > Tcut_Y[1,`cc'+1] & tt<= Tcut_Y[1,`cc'+2]
}

replace la_P = la_P*10000
replace la_Z = la_Z*10000
replace la_Y = la_Y*10000

sc la_P tt if tt <= 1000, c(l) ms(i) sort xt("") yt("")
//gr export la_P.png, replace
sc la_Z tt if tt <= 1000, c(l) ms(i) sort xt("") yt("")
//gr export la_Z.png, replace
sc la_Y tt if tt <= 1000, c(l) ms(i) sort xt("") yt("")
//gr export la_Y.png, replace














