clear all

use spell
keep if uniform()<=1
drop ident

keep if substr(gcom,1,2)=="75"    // select one department only (Paris) 
drop gcom                         // comment out these three lines if whole IdF region (and uncomment below)

// outcome
gen Y = (gend~=.)
replace gend = mdy(1,1,2008) if Y==0
gen tY = gend-gbeg
// treatment
gen Z = gbegt~=.
replace gbegt = gend if Z==0
gen tZ = gbegt-gbeg
// notification
gen P = (gprop~=. & gprop<gbegt)
replace gprop = gbegt if P==0
gen tP = gprop-gbeg
// information shocks before notification
qui foreach aa of numlist 1 2 3 4 5{
	gen A`aa' = (prop`aa'~=. & prop`aa'<gprop)
	gen tA`aa' = prop`aa'-gbeg if A`aa'==1
	replace tA`aa' = gprop-gbeg if A`aa'==0
}
// information shocks after notification
qui foreach bb of numlist 1 2 3 4 5{
	gen B`bb' = 0
	gen tB`bb' = .
	local aa_start = `bb'+1
	foreach aa of numlist `aa_start'(1)25{
		local aa_lag = `aa'-`bb'
		replace B`bb' = (prop`aa'~=. & prop`aa'>gprop & prop`aa'<gbegt & prop`aa_lag'==gprop & P==1) if B`bb'==0
		if `bb'>1{
			local bw0 = `aa_lag'+1
			local bw1 = `aa'-1
			foreach cc of numlist `bw0'(1)`bw1'{
				replace B`bb' = 0 if B`bb'==1 & prop`cc'==gprop & P==1
			}
		}
		replace tB`bb' = prop`aa'-gprop if B`bb'==1 & tB`bb'==.
	}
	replace tB`bb' = gbegt-gprop+(P==0) if B`bb'==0
}

// drop the few (about 2.5%) spells of duration 0 and make room
drop if tY==0 | tZ==0 | tP==0 | tA1==0 | tA2==0 | tA3==0 | tA4==0 | tA5==0
drop action* prop* gend gbegt gendt gprop 
compress

// re-scale tA2-5, tB2-5
foreach aa of numlist 2 3 4 5{
	local aa1 = `aa'-1
	replace tA`aa' = tA`aa'-tA`aa1'
	replace tB`aa' = tB`aa'-tB`aa1'
}

// individual characteristics
gen X_male = (sexe=="1")
gen X_french = (nation=="01")
gen X_kid = (nenf~="0")
gen X_married = (gmat=="M")
replace gqual = "3" if gqual=="1" | gqual=="2" | gqual=="4"    // worker qualification (6 categories), the reference is executive
drop if gqual=="0"
tab gqual, gen(X_qual)
drop X_qual6

//destring gcom, replace                        // department (where the worker lives), the reference is Paris (75)
//gen dep = int(gcom/1000)
//foreach dd of numlist 77 78 91 92 93 94 95{
//	gen X_dep`dd' = (dep==`dd')
//}

gen X_age = int((gbeg-datnais)/365)           // age, age2, exp and exp2 are normalized
gen A2_age = X_age  // keep age for stat desc
destring gtenu, gen(X_exp)
gen X_age2 = X_age^2
gen X_exp2 = X_exp^2
foreach vv of varlist X_age* X_exp*{
	qui su `vv', det
	replace `vv' = (`vv'-r(mean))/r(sd)
}
gen X_educ1 = (nivetude=="00" | nivetude=="52" | nivetude=="60") 					                  // junior high school drop out
gen X_educ2 = (nivetude=="41" | nivetude=="42" | nivetude=="51") 					                  // bepc, bep, cap
gen X_educ3 = (nivetude=="3A" | nivetude=="3B" | nivetude=="3C" | nivetude=="3D" |  ///
               nivetude=="3E" | nivetude=="3F" | nivetude=="3G" | nivetude=="43")     		          // high school drop out
gen X_educ4 = (nivetude=="31" | nivetude=="32" | nivetude=="33" | nivetude=="34" |  ///
               nivetude=="35" | nivetude=="36" | nivetude=="37")					                  // bac
gen X_educ5 = (nivetude=="1A" | nivetude=="2A" | nivetude=="2B" | nivetude=="2C" | nivetude=="2D")	  // college drop out (ref is college degree) 

// variables at the ALE (local unemployment agency) level
gen y0 = year(gbeg)
qui bys galoc y0: egen EZylag = mean(Z*(tZ<=365))                 // % of treated within 12 months among previous year inflow for each ALE
qui bys galoc y0: gen firstm = (_n==1)
qui bys firstm galoc (y0): gen X_EZylag = EZylag[_n-1] if _n>1
qui bys galoc y0 (firstm): replace X_EZylag = X_EZylag[_N]
qui bys galoc y0: gen NU = _N
bys firstm galoc (y0): gen X_rU = (NU-NU[_n-1])/NU[_n-1] if _n>1  // evolution of the unemployment inflow since last year
qui bys galoc y0 (firstm): replace X_rU = X_rU[_N]
drop EZylag NU firstm

// check that the market variables are defined for every spell after 2003
count if X_rU==. & y0>=2003
tab galoc if X_rU==. & y0>=2003
drop if X_rU==. & y0>=2003

//drop if galoc=="75023" | galoc=="75028" // these two areas only have very few obs (hence EZYlag and rU not reliable)

// clean, make room and save
keep if y0 >= 2003
keep if y0 <= 2005
keep X* tY tZ tP Y Z P A* B* tA* tB*
order X_male X_age X_age2 X_exp X_exp2 X_* tP P tZ Z tY Y tA* A* tB* B* A2_age
compress
save table_75, replace


