clear all

cap program drop expdur
mata:
function expdur(scalar dP, scalar dZ)
{

	t = range(1,3000,1)'

	ikt = st_matrix("ikt")
	ikt0 = 0\ ikt
	ikt1 = ikt\ 9999
	lambda = (  8.439815\ 9.045245\ 9.189907\ 9.305245\ 9.216465\    ///
				9.161499\ 9.291423\ 9.410387\ 9.353674\ 9.097528  )
	lambda = .0001\ exp(-lambda)

	dt = (dP\ dZ\ dZ+4*30\ dZ+12*30)
	dt0 = 0\ dt
	dt1 = dt\ 9999
	delta = (0\ -.3344354\ -.6330707\ .4123607\ .9061751)
	delta = exp(delta)

	ladel = colsum((ikt0:<=t#J(rows(lambda),1,1)):*(t#J(rows(lambda),1,1):<ikt1):*lambda)   ///
		  :*colsum((dt0:<=t#J(rows(delta),1,1)):*(t#J(rows(delta),1,1):<dt1):*delta)		  
		  
	b = (  .0510769, -1.259163,  1.116888, -.2541548,  .1921755,   ///
		  -.2110358, -.0230283,   .020497,   .067584,   .071714,   ///
		  -.0398207, -.1931422, -.0507433,  .2061595,   .112486,   ///
			.131766,  .0038036, -.0072679,  3.114333, -.7074469  )
	st_view(Xb = ., ., tokens("X_*"))
	phi = exp(Xb*b')

	v1 = 2.852635
	v2 = 3.654469
	pv1 = 1/(1+exp(.5912943))

	phiv = phi:*exp(v1)
	haz = phiv#ladel
	surv = exp(-phiv#runningsum(ladel))
	f1 = (haz:*surv)
	F1 = J(rows(phi),1,0)
	i = 1
	while (i<=cols(t)){
		F1 = F1+f1[.,i]
		i++
	}
	EY1 = rowsum((haz:*surv):*t)

	phiv = phi:*exp(v2)
	haz = phiv#ladel
	surv = exp(-phiv#runningsum(ladel))
	f2 = (haz:*surv)
	F2 = J(rows(phi),1,0)
	i = 1
	while (i<=cols(t)){
		F2 = F2+f2[.,i]
		i++
	}
	EY2 = rowsum((haz:*surv):*t)

	EY = EY1:*pv1+EY2:*(1-pv1)
	st_store(.,"EY",EY)
	st_store(.,"F1",F1)
	st_store(.,"F2",F2)
}
end

cap program drop ey
program define ey
args dP dZ mm
	qui{
	use table_75, clear
	drop if X_rU>2 // about 12 observations pertain to a very small area where rU is not reliable
	gen ident = _n
	su tY if Y==1, det
	_pctile tY if Y==1, nq(11)
	matrix ikt = (r(r1)\ r(r2)\ r(r3)\ r(r4)\ r(r5)\ r(r6)\ r(r7)\ r(r8)\ r(r9)\ r(r10))
	gen EY = .
	gen F1 = .
	gen F2 = .
	forv qq = 1/4{
	noi di `qq'
	preserve
		keep if _n>(`qq'-1)*_N/4 & _n<=`qq'*_N/4
		mata: expdur(`dP',`dZ')
		keep ident Z EY F1 F2
		if `qq'==1 save EY, replace
		if `qq'>1 append using EY
		if `qq'>1 save EY, replace
	restore
	}
	use EY, clear
	noi su EY, det
	matrix EY = `dP', `dZ', r(mean)
	noi su EY if Z==1, det
	matrix EY = EY, r(mean)
	if `mm'==0 matrix mm = EY
	if `mm'==1 matrix mm = mm \ EY
	su F1, det
	matrix F1 = r(min), r(p1), r(p5), r(p10), r(mean)
	su F2, det
	matrix F2 = r(min), r(p1), r(p5), r(p10), r(mean)
	if `mm'==0 matrix ff = F1, ., F2
	if `mm'==1 matrix ff = ff \ (F1, ., F2)
	}
	mata: round(st_matrix("mm"),1)
	mata: round(st_matrix("ff"),.00001)
end

ey   0   30 0
ey  30   30 1
ey   0   60 1
ey  30   60 1
ey  60   60 1
ey   0   90 1
ey  30   90 1
ey  60   90 1
ey  90   90 1
ey   0  180 1
ey  30  180 1
ey  60  180 1
ey  90  180 1
ey 150  180 1
ey 180  180 1
ey   0  360 1
ey  30  360 1
ey  60  360 1
ey  90  360 1
ey 150  360 1
ey 180  360 1
ey 270  360 1
ey 330  360 1
ey 360  360 1
ey 9999 9999 1

mata: msim = st_matrix("mm")
mata: msim[.,1..2], round(msim[.,3],1)
