clear all

// prog mata to compute the interval each duration belongs to
cap program drop Inter
mata:
	void Inter(string scalar t)
	{
	// import variables and matrices into mata
	st_view(vt,.,t)
	Tcut = st_matrix("Tcut")
	N = rows(vt)
	// interval to which t belongs (consider all intervals strictly included in [0,t] and add 1)
	Tcut_sup = Tcut[.,2..cols(Tcut)]
	nint = rowsum((vt :> (J(N,1,1) * Tcut_sup))) + J(N,1,1)
	// compute t minus the lower bound of the interval t belongs to
	Tcut_inf = Tcut[.,1..cols(Tcut) - 1]
	Ikt = (vt :> (J(N,1,1) * Tcut_inf)) :* ((vt :<= (J(N,1,1) * Tcut_sup))) 
	Ik_length = Tcut_sup-Tcut_inf,0
	lint = rowsum((vt * J(1,cols(Tcut) - 1,1) - J(N,1,1) * Tcut_inf) :* Ikt)
	// send results to stata
	st_addvar(("double", "double"), ("nint", "lint"))
	st_store(.,"nint",nint)
	st_store(.,"lint",lint)
	}
end

// prog that declares model and maximizes likelihood
cap program drop maxlik
program define maxlik
syntax [, NV(real 1) MINIT]
	// declare model - parameters are ordered as follows: bz dz0 dz4 dz12 by I_z I_y vz vy zy
	local K_ALL = 0
	foreach vv of varlist Z Y{
		local K_Tcut = colsof(Tcut_`vv')-2
		foreach kk of numlist 1(1)`K_Tcut'{
			local dkk = 5+`K_ALL'+`kk'
			local deltaIk_`vv' = "`deltaIk_`vv'' (delta`dkk':)"
		}
		local K_ALL = `K_ALL'+`K_Tcut'
	}
	scalar nv = `nv'
	local nv_all = 3*`nv'-1
	foreach hh of numlist 1(1)`nv_all'{
		local dhh = 5+`K_ALL'+`hh'
		local deltahet = "`deltahet' (delta`dhh':)"
	}

	ml model lf lik (delta1: X*, nocons) (delta2:) (delta3:) (delta4:) (delta5: X*, nocons)    ///
					`deltaIk_A1' `deltaIk_P' `deltaIk_B1' `deltaIk_Z' `deltaIk_Y' `deltahet' , technique(bhhh 10 bfgs 50)
	// starting values
	if "`minit'"~=""{
		ml init M, copy
	}
	else{
		ml search
	}
	// maximize likelihood
	ml max, difficult
end

// prog to compute hazard rates and add the different bits of the likelihood
//clear mata
mata:
function LL(string bvars, string dvars, string intz, string inty, string mehaz)
{
	me = st_matrix("effects")
	st_view(MEHAZ = ., ., tokens(mehaz))

	st_view(NINT = ., ., tokens(intz))
	PCUT = st_matrix("Pcut_Z")
	SPCUT = st_matrix("SPcut_Z")
	LINT = NINT[.,2]
	NINT = NINT[.,1]
	H = PCUT[NINT,1]
	HINT = SPCUT[NINT:-1+(NINT:==1),1]:*(NINT:>1) + PCUT[NINT,1]:*LINT
	
	st_view(NINT = ., ., tokens(inty))
	PCUT = st_matrix("Pcut_Y")
	SPCUT = st_matrix("SPcut_Y")
	m = cols(NINT)/2
	LINT = NINT[.,m+1..2*m]
	NINT = NINT[.,1..m]
	H = H, PCUT[NINT[.,m],1]
	NINT = colshape(NINT',1)
	LINT = colshape(LINT',1)
	T = exp((0, me[1,1..3])) * (   I(m) + ( J(1,m,0)\(-I(m-1),J(m-1,1,0)) )   )	
	HINT = HINT, (  rowshape(SPCUT[NINT:-1+(NINT:==1),1]:*(NINT:>1) + PCUT[NINT,1]:*LINT, m)' * T'  )	

	st_view(BETA = ., ., tokens(bvars))
	st_view(D = ., ., tokens(dvars))
	BETA = BETA
	D = D
	mp = st_matrix("probas")
	mv = st_matrix("vhet")
	R = cols(mp)
	N = rows(D)
	
	L = rowshape(	rowsum(   (mv#J(N,1,1)) :* (J(R,1,1)#D) - (J(R,1,1)#HINT) :* exp(J(R,1,1)#BETA + mv#J(N,1,1))   )   ,   R)'
	L = log(rowsum(exp(mp:+L))) + rowsum(D:*(log(H)+BETA)) :- log(rowsum(exp(mp)))
	L = L + D[.,1]:*D[.,2]:*MEHAZ
	st_store(.,"lnvrais",L)	
}
end

// likelihood
cap program drop lik
program define lik
	
	local nv = nv
	foreach vv in "Z" "Y"{
		local K_`vv' = colsof(Tcut_`vv') - 1
		local I_`vv' = "I2_`vv'"
		foreach kk of numlist 3(1)`K_`vv''{
			local I_`vv' = "`I_`vv'' I`kk'_`vv'"
		}
	}
	foreach bb of numlist 1(1)`nv'{
		local vzhet  = "`vzhet' vz`bb'"
		local vyhet  = "`vyhet' vy`bb'"
		if `bb' ~= `nv'{
			local zyhet = "`zyhet' zy`bb'"
		}
	}
	local zy`nv' = 0
		
	args lnf bz dz0 dz4 dz12 by `I_Z' `I_Y' `vzhet' `vyhet' `zyhet'
	tempvar dz

	foreach vv in "Z" "Y"{
		matrix Pcut_`vv' = .0001
		matrix SPcut_`vv' = (.0001 * LTcut_`vv'[1,1]) \ J(`K_`vv''-1,1,0)
		foreach kk of numlist 2(1)`K_`vv''{
			matrix Pcut_`vv' = Pcut_`vv' \ (exp(-`I`kk'_`vv''[1]) / (1+exp(-`I`kk'_`vv''[1])))
			matrix SPcut_`vv'[`kk',1] = SPcut_`vv'[`kk'-1,1] + Pcut_`vv'[`kk',1]*LTcut_`vv'[1,`kk']
		}
	}
	gen double `dz' = `dz0'*(tZ<tY)*(tY<=tZ4) + `dz4'*(tZ4<tY)*(tY<=tZ12) + `dz12'*(tZ12<tY)
	matrix effects = (`dz0'[1],`dz4'[1],`dz12'[1])
	matrix probas = `zy`nv''
	matrix vhet = (`vz`nv''[1], `vy`nv''[1])
	if `nv'>1{
		local nv1 = `nv'-1
		foreach rr of numlist `nv1'(1)1{
			matrix probas = `zy`rr''[1], probas
			matrix vhet = (`vz`rr''[1], `vy`rr''[1]) \ vhet
		}
	}
	gen double lnvrais = 0
	mata: LL("`bz' `by'", "Z Y", "nint_Z lint_Z",   ///
	                           "nint_YtZ nint_YtZ4 nint_YtZ12 nint_Y lint_YtZ lint_YtZ4 lint_YtZ12 lint_Y", "`dz'")
	qui replace `lnf' = lnvrais
	drop lnvrais
end

use table_75

drop *A1 *A2 *A3 *A4 *A5 *B1 *B2 *B3 *B4 *B5

// create intervals for piecewise constant hazards
foreach vv of varlist Z Y{
	su t`vv' if `vv'==1, det
	_pctile t`vv' if `vv'==1, nq(11)
	matrix Tcut_`vv' = (0, r(r1), r(r2), r(r3), r(r4), r(r5), r(r6), r(r7), r(r8), r(r9), r(r10), .)
}
// length of each interval (used later to compute integrated hazard rates)
qui foreach vv of varlist Z Y{
	local K_`vv' = colsof(Tcut_`vv')-2
	matrix LTcut_`vv' = Tcut_`vv'[1,2]
	foreach cc of numlist 2(1)`K_`vv''{
		matrix LTcut_`vv' = LTcut_`vv', Tcut_`vv'[1,`cc'+1]-Tcut_`vv'[1,`cc']
	}
	noi matrix list Tcut_`vv'
	noi matrix list LTcut_`vv'
}

// find which interval each duration belongs to
foreach vv of varlist Z Y{
	matrix Tcut = Tcut_`vv'
	mata: Inter("t`vv'")
	rename nint nint_`vv'
	rename lint lint_`vv'
}
foreach tt of numlist 4 12{
	gen tZ`tt' = tZ + 30*`tt'
	replace tZ`tt' = tY if tY<=tZ`tt'
	matrix Tcut = Tcut_Y
	mata: Inter("tZ`tt'")
	rename nint nint_YtZ`tt'
	rename lint lint_YtZ`tt'
}
matrix Tcut = Tcut_Y
mata: Inter("tZ")
rename nint nint_YtZ
rename lint lint_YtZ

matrix M = (   .0175435,    .21257, -.2468874, -.1202709,  .0176472,  .2856564,   .092082, -.1155073,  J(1,10,0),   .868573, -.0933729,  ///
                       0, 0, 0,  ///
			    .0257108,  -.293862,  .2077054, -.1198025,  .1008009, -.1571439, -.0316994,  .0117151,  J(1,10,0),  .1349749, -.3851028,  ///
			    J(1,10,9),  J(1,10,8),  0, 0  )

maxlik, nv(1) minit
matrix eb1 = e(b)
matrix M = eb1[1,1..colsof(eb1)-2],  1.7, -.9, 2.6, 3.5, -.5
maxlik, nv(2) minit
matrix eb2 = e(b)




