clear all

// prog mata to compute the interval each duration belongs to
cap program drop Inter
mata:
	void Inter(string scalar t)
	{
	// import variables and matrices into mata
	st_view(vt,.,t)
	Tcut = st_matrix("Tcut")
	N = rows(vt)
	// interval to which t belongs (consider all intervals strictly included in [0,t] and add 1)
	Tcut_sup = Tcut[.,2..cols(Tcut)]
	nint = rowsum((vt :> (J(N,1,1) * Tcut_sup))) + J(N,1,1)
	// compute t minus the lower bound of the interval t belongs to
	Tcut_inf = Tcut[.,1..cols(Tcut) - 1]
	Ikt = (vt :> (J(N,1,1) * Tcut_inf)) :* ((vt :<= (J(N,1,1) * Tcut_sup))) 
	Ik_length = Tcut_sup-Tcut_inf,0
	lint = rowsum((vt * J(1,cols(Tcut) - 1,1) - J(N,1,1) * Tcut_inf) :* Ikt)
	// send results to stata
	st_addvar(("double", "double"), ("nint", "lint"))
	st_store(.,"nint",nint)
	st_store(.,"lint",lint)
	}
end

// prog that declares model and maximizes likelihood
cap program drop maxlik
program define maxlik
syntax [, NV(real 1) MINIT]
	// declare model - parameters are ordered as follows: bp gp bz dp by I_p I_z I_y vp vz vy pzy
	local K_ALL = 0
	foreach vv of varlist P Z Y{
		local K_Tcut = colsof(Tcut_`vv')-2
		foreach kk of numlist 1(1)`K_Tcut'{
			local dkk = 5+`K_ALL'+`kk'
			local deltaIk_`vv' = "`deltaIk_`vv'' (delta`dkk':)"
		}
		local K_ALL = `K_ALL'+`K_Tcut'
	}
	scalar nv = `nv'
	local nv_all = 4*`nv'-1
	foreach hh of numlist 1(1)`nv_all'{
		local dhh = 5+`K_ALL'+`hh'
		local deltahet = "`deltahet' (delta`dhh':)"
	}

	ml model lf lik (delta1: X*, nocons) (delta2:) (delta3: X*, nocons) (delta4:) (delta5: X*, nocons)    ///
					`deltaIk_A1' `deltaIk_P' `deltaIk_B1' `deltaIk_Z' `deltaIk_Y' `deltahet' , technique(bhhh 10 bfgs 50)
	// starting values
	if "`minit'"~=""{
		ml init M, copy
	}
	else{
		ml search
	}
	// maximize likelihood
	ml max, difficult
end

// prog to compute hazard rates and add the different bits of the likelihood
//clear mata
mata:
function LL(string bvars, string dvars, string intp, string intz, string inty)
{
	me = st_matrix("effects")

	st_view(NINT = ., ., tokens(intp))
	PCUT = st_matrix("Pcut_P")
	SPCUT = st_matrix("SPcut_P")
	LINT = NINT[.,2]
	NINT = NINT[.,1]
	H = PCUT[NINT,1]
	HINT = SPCUT[NINT:-1+(NINT:==1),1]:*(NINT:>1) + PCUT[NINT,1]:*LINT
	
	st_view(NINT = ., ., tokens(intz))
	PCUT = st_matrix("Pcut_Z")
	SPCUT = st_matrix("SPcut_Z")
	m = cols(NINT)/2
	LINT = NINT[.,m+1..2*m]
	NINT = NINT[.,1..m]
	H = H, PCUT[NINT[.,m],1]
	NINT = colshape(NINT',1)
	LINT = colshape(LINT',1)
	T = exp((0, me[1,1])) * (   I(m) + ( J(1,m,0)\(-I(m-1),J(m-1,1,0)) )   )	
	HINT = HINT, (  rowshape(SPCUT[NINT:-1+(NINT:==1),1]:*(NINT:>1) + PCUT[NINT,1]:*LINT, m)' * T'  )

	st_view(NINT = ., ., tokens(inty))
	PCUT = st_matrix("Pcut_Y")
	SPCUT = st_matrix("SPcut_Y")
	m = cols(NINT)/2
	LINT = NINT[.,m+1..2*m]
	NINT = NINT[.,1..m]
	H = H, PCUT[NINT[.,m],1]
	NINT = colshape(NINT',1)
	LINT = colshape(LINT',1)
	T = exp((0, me[1,2])) * (   I(m) + ( J(1,m,0)\(-I(m-1),J(m-1,1,0)) )   )	
	HINT = HINT, (  rowshape(SPCUT[NINT:-1+(NINT:==1),1]:*(NINT:>1) + PCUT[NINT,1]:*LINT, m)' * T'  )	

	st_view(BETA = ., ., tokens(bvars))
	st_view(D = ., ., tokens(dvars))
	BETA = BETA
	D = D
	mp = st_matrix("probas")
	mv = st_matrix("vhet")
	R = cols(mp)
	N = rows(D)
	
	L = rowshape(	rowsum(   (mv#J(N,1,1)) :* (J(R,1,1)#D) - (J(R,1,1)#HINT) :* exp(J(R,1,1)#BETA + mv#J(N,1,1))   )   ,   R)'
	L = log(rowsum(exp(mp:+L))) + rowsum(D:*(log(H)+BETA)) :- log(rowsum(exp(mp)))
	L = L + D[.,2]:*me[1,1]:*D[.,1] + D[.,3]:*me[1,2]:*D[.,1]
	st_store(.,"lnvrais",L)	
}
end

// likelihood
cap program drop lik
program define lik
	
	local nv = nv
	foreach vv in "P" "Z" "Y"{
		local K_`vv' = colsof(Tcut_`vv') - 1
		local I_`vv' = "I2_`vv'"
		foreach kk of numlist 3(1)`K_`vv''{
			local I_`vv' = "`I_`vv'' I`kk'_`vv'"
		}
	}
	foreach bb of numlist 1(1)`nv'{
		local vphet  = "`vphet' vp`bb'"
		local vzhet  = "`vzhet' vz`bb'"
		local vyhet  = "`vyhet' vy`bb'"
		if `bb' ~= `nv'{
			local pzyhet = "`pzyhet' pzy`bb'"
		}
	}
	local pzy`nv' = 0
		
	args lnf bp gp bz dp by `I_P' `I_Z' `I_Y' `vphet' `vzhet' `vyhet' `pzyhet'

	foreach vv in "P" "Z" "Y"{
		matrix Pcut_`vv' = .0001
		matrix SPcut_`vv' = (.0001 * LTcut_`vv'[1,1]) \ J(`K_`vv''-1,1,0)
		foreach kk of numlist 2(1)`K_`vv''{
			matrix Pcut_`vv' = Pcut_`vv' \ (exp(-`I`kk'_`vv''[1]) / (1+exp(-`I`kk'_`vv''[1])))
			matrix SPcut_`vv'[`kk',1] = SPcut_`vv'[`kk'-1,1] + Pcut_`vv'[`kk',1]*LTcut_`vv'[1,`kk']
		}
	}
	matrix effects = (`gp'[1],`dp'[1])
	matrix probas = `pzy`nv''
	matrix vhet = `vp`nv''[1], `vz`nv''[1], `vy`nv''[1]
	if `nv'>1{
		local nv1 = `nv'-1
		foreach rr of numlist `nv1'(1)1{
			matrix probas = `pzy`rr''[1], probas
			matrix vhet = (`vp`rr''[1], `vz`rr''[1], `vy`rr''[1]) \ vhet
		}
	}
	gen double lnvrais = 0
	mata: LL("`bp' `bz' `by'", "P Z Y", "nint_P lint_P", "nint_ZtP nint_Z lint_ZtP lint_Z", "nint_YtP nint_Y lint_YtP lint_Y")
	qui replace `lnf' = lnvrais
	drop lnvrais

end

use table_75

drop *A1 *A2 *A3 *A4 *A5 *B1 *B2 *B3 *B4 *B5

// create intervals for piecewise constant hazards
foreach vv of varlist P Z Y{
	su t`vv' if `vv'==1, det
	_pctile t`vv' if `vv'==1, nq(11)
	matrix Tcut_`vv' = (0, r(r1), r(r2), r(r3), r(r4), r(r5), r(r6), r(r7), r(r8), r(r9), r(r10), .)
}
// length of each interval (used later to compute integrated hazard rates)
qui foreach vv of varlist P Z Y{
	local K_`vv' = colsof(Tcut_`vv')-2
	matrix LTcut_`vv' = Tcut_`vv'[1,2]
	foreach cc of numlist 2(1)`K_`vv''{
		matrix LTcut_`vv' = LTcut_`vv', Tcut_`vv'[1,`cc'+1]-Tcut_`vv'[1,`cc']
	}
	noi matrix list Tcut_`vv'
	noi matrix list LTcut_`vv'
}

// tZ (resp. tY) is censored by tY (resp. tZ)
replace Y = 0 if tZ < tY
replace tY = tZ if tZ < tY

// find which interval each duration belongs to
foreach vv of varlist P Z Y{
	matrix Tcut = Tcut_`vv'
	mata: Inter("t`vv'")
	rename nint nint_`vv'
	rename lint lint_`vv'
}
foreach vv of varlist Z Y{
	matrix Tcut = Tcut_`vv'
	mata: Inter("tP")
	rename nint nint_`vv'tP
	rename lint lint_`vv'tP
}



// Maximising likelihood for different values of K (K=2 is the main specification)

// K=1
matrix M = (    -.159064,  .2089773, -.2809988, -.3288755,  .1853685, -.1674548,  .0256896, -.0076392,  J(1,10,0), -3.246765, -.0370113,  ///
                       0,  ///
                .0175435,    .21257, -.2468874, -.1202709,  .0176472,  .2856564,   .092082, -.1155073,  J(1,10,0),   .868573, -.0933729,  ///
                       0,  ///
			    .0257108,  -.293862,  .2077054, -.1198025,  .1008009, -.1571439, -.0316994,  .0117151,  J(1,10,0),  .1349749, -.3851028,  ///
			    J(1,10,8),  J(1,10,9),  J(1,10,8),  0, 0, 0  )
maxlik, nv(1) minit
matrix eb1 = e(b)
				 
// K=2
matrix M = eb1[1,1..colsof(eb1)-3],   2, 2.7158355,    .5, .71227121,     3, 3.4830554,   -.5
maxlik, nv(2) minit
matrix eb2 = e(b)
matrix eV2 = e(V)
matrix bb = eb2[1,21], eb2[1,42]
matrix VV = (eV2[21,21], eV2[21,42]) \ (eV2[42,21], eV2[42,42])
matrix sd = (eb2[1,42], eb2[1,21]) * VV * (eb2[1,42], eb2[1,21])'
matrix sd = sqrt(sd[1,1])
noi matrix list bb
noi matrix list sd

// K=3
matrix M = eb2[1,1..colsof(eb2)-7],   2, 1.9975848,  2.8835348,     -1, 1.7170154, -1.4054494,     3, 2.7497042,  3.6431803,    0, -.92023522
maxlik, nv(3) minit
matrix eb3 = e(b)
matrix eV3 = e(V)
matrix bb = eb3[1,21], eb3[1,42]
matrix VV = (eV3[21,21], eV3[21,42]) \ (eV3[42,21], eV3[42,42])
matrix sd = (eb3[1,42], eb3[1,21]) * VV * (eb3[1,42], eb3[1,21])'
matrix sd = sqrt(sd[1,1])
noi matrix list bb
noi matrix list sd



