function W = wnorm(W)
% PURPOSE: normalize a spatial weight matrix
%          to have row sums of unity
% -------------------------------------------------
% NOTES: some rows can be zero, 
% ------------------------------------------------- 
[n1 n2] = size(W);
if n1 ~= n2,
    error('normw: W matrix must be square');
end;

nterm = sum(W,2);

nterm(nterm==0) = 1;

nterm = 1./nterm;

A = sparse(1:n1,1:n2,nterm);
W = A*W;