% Generate dependent variables and regressors
clear
load data\data_inhome.mat
%% deletion due to no valid ID information
ind = data(:,strcmp('AID',colheaders));
ind(isnan(ind)) = 0;
data = data(ind>0,:);
%% deletion due to no valid age information
ind = data(:,strcmp('IMONTH',colheaders));
ind(isnan(ind)) = 0;
data = data(ind>0,:);

ind = data(:,strcmp('IYEAR',colheaders));
ind(isnan(ind)) = 0;
data = data(ind>0,:);

ind = data(:,strcmp('H1GI1M',colheaders));
ind(isnan(ind)) = 100;
data = data(ind<=12,:);

ind = data(:,strcmp('H1GI1Y',colheaders));
ind(isnan(ind)) = 100;
data = data(ind<=83,:);
%% deletion due to no valid sex information
ind = data(:,strcmp('BIO_SEX',colheaders));
ind(isnan(ind)) = 100;
data = data(ind<=2,:);
%% deletion due to no valid grade information
ind = data(:,strcmp('H1GI20',colheaders));
ind(isnan(ind)) = 100;
data = data(ind<=12,:);
%% deletion due to no valid GPA information
ind = data(:,strcmp('H1ED11',colheaders));
ind(isnan(ind)) = 10;
data = data(ind<=4,:);

ind = data(:,strcmp('H1ED12',colheaders));
ind(isnan(ind)) = 10;
data = data(ind<=4,:);

ind = data(:,strcmp('H1ED13',colheaders));
ind(isnan(ind)) = 10;
data = data(ind<=4,:);

ind = data(:,strcmp('H1ED14',colheaders));
ind(isnan(ind)) = 10;
data = data(ind<=4,:);
%% deletion due to no valid TV information
ind = data(:,strcmp('H1DA8',colheaders));
ind(isnan(ind)) = 1000;
data = data(ind<=99,:);

ind = data(:,strcmp('H1DA9',colheaders));
ind(isnan(ind)) = 1000;
data = data(ind<=99,:);

ind = data(:,strcmp('H1DA10',colheaders));
ind(isnan(ind)) = 1000;
data = data(ind<=99,:);
%% deletion due to no self TV time decision
%ind = data(:,strcmp('H1WP4',colheaders));
%ind(isnan(ind)) = 10;
%data = data(ind==1,:);
%% IDS
n = size(data,1);

AID   = data(:,strcmp('AID',colheaders)); % respondent id
SCID  = data(:,strcmp('SCID',colheaders)); % school id
%SCID  = 1000*SCID+data(:,strcmp('H1GI20',colheaders)); % grade id
SSCID = data(:,strcmp('SSCID',colheaders)); % sister school id

DAT = data;
NAM = colheaders;

save input\data_xy.mat AID SCID SSCID DAT NAM