#delimit;
clear all;
set more off;
set memory 1500m;
set matsize 1000;
global basedirectory "~/Documents/Research/Gas Demand Elasticity/cdks/";
graph set eps fontface Garamond;
graph set print logo off;

*Monthly Prices Gasoline By State (83-07);
*In DOE site, select "area" for the State breakdown, open EXCEL file, delete heading (top two rows), and save as .csv file;
*http://tonto.eia.doe.gov/dnav/pet/pet_pri_allmg_d_nus_PTA_cpgal_m.htm;

*Prime Supplier Sales Volumes;
*In DOE site, select "area" for the State breakdown, open EXCEL file, delete heading (top two rows), and save as .csv file;
*http://tonto.eia.doe.gov/dnav/pet/pet_cons_prim_dcu_SDE_m.htm;

*----------------------------------------*;
*--------------VOLUMES-------------------*;
*----------------------------------------*;
insheet using "${basedirectory}pet_cons_prim_a_EPM0_P00_Mgalpd_m.csv";
rename alab xAL; rename alas xAK;   rename ariz xAZ;   rename arka xAR;   rename cali xCA;  rename colo xCO;   rename conn xCT;
rename dela xDE; rename dist xDC;   rename flor xFL;   rename geor xGA;   rename hawa xHI;  rename idah xID;   rename illi xIL; 
rename indi xIN; rename iowa xIA;   rename kans xKS;   rename kent xKY;   rename loui xLA;  rename main xME;   rename mary xMD; 
rename mass xMA; rename mich xMI;   rename minn xMN;   rename missi xMS;  rename misso xMO; rename mont xMT;   rename nebr xNE; 
rename neva xNV; rename newh xNH;   rename newj xNJ;   rename newm xNM;   rename newy xNY;  rename northc xNC; rename northd xND; 
rename ohio xOH; rename okla xOK;   rename oreg xOR;   rename penn xPA;   rename rhod xRI;  rename southc xSC; rename southd xSD;
rename tenn xTN; rename texa xTX;   rename utah xUT;   rename verm xVT;   rename virg xVA;  rename wash xWA;   rename west xWV;   
rename wisc xWI; rename wyom xWY;   rename usto xUS;
drop padd* newenglandpadd centralatlanticpadd loweratlanticpadd;
reshape long x, i(date) j(state) string; rename x volume; sort state date; save "${basedirectory}temp1.dta", replace; clear;

*----------------------------------------*;
*--------------PRICES--------------------*;
*----------------------------------------*;
insheet using "${basedirectory}PET_PRI_ALLMG_A_EPM0_PTA_CPGAL_M.csv";
rename alab xAL; rename alas xAK;   rename ariz xAZ;   rename arka xAR;   rename cali xCA;  rename colo xCO;   rename conn xCT;
rename dela xDE; rename dist xDC;   rename flor xFL;   rename geor xGA;   rename hawa xHI;  rename idah xID;   rename illi xIL; 
rename indi xIN; rename iowa xIA;   rename kans xKS;   rename kent xKY;   rename loui xLA;  rename main xME;   rename mary xMD; 
rename mass xMA; rename mich xMI;   rename minn xMN;   rename missi xMS;  rename misso xMO; rename mont xMT;   rename nebr xNE; 
rename neva xNV; rename newh xNH;   rename newj xNJ;   rename newm xNM;   rename newy xNY;  rename northc xNC; rename northd xND; 
rename ohio xOH; rename okla xOK;   rename oreg xOR;   rename penn xPA;   rename rhod xRI;  rename southc xSC; rename southd xSD;
rename tenn xTN; rename texa xTX;   rename utah xUT;   rename verm xVT;   rename virg xVA;  rename wash xWA;   rename west xWV;   
rename wisc xWI; rename wyom xWY;   rename usto xUS;
drop padd* newenglandpadd centralatlanticpadd loweratlanticpadd;
reshape long x, i(date) j(state) string; rename x price; sort state date; 
merge state date using "${basedirectory}temp1.dta"; drop _merge; erase "${basedirectory}temp1.dta";

*----------------------------------------*;
*--------USE STANDARD STATE FIPS---------*;
*----------------------------------------*;
gen statefip=.;   
replace statefip=1 if state=="AL";  replace statefip=2 if state=="AK";  replace statefip=4 if state=="AZ";  replace statefip=5 if state=="AR";
replace statefip=6 if state=="CA";  replace statefip=8 if state=="CO";  replace statefip=9 if state=="CT";  replace statefip=10 if state=="DE";
replace statefip=11 if state=="DC"; replace statefip=12 if state=="FL"; replace statefip=13 if state=="GA"; replace statefip=15 if state=="HI";
replace statefip=16 if state=="ID"; replace statefip=17 if state=="IL"; replace statefip=18 if state=="IN"; replace statefip=19 if state=="IA";
replace statefip=20 if state=="KS"; replace statefip=21 if state=="KY"; replace statefip=22 if state=="LA"; replace statefip=23 if state=="ME";
replace statefip=24 if state=="MD"; replace statefip=25 if state=="MA"; replace statefip=26 if state=="MI"; replace statefip=27 if state=="MN";
replace statefip=28 if state=="MS"; replace statefip=29 if state=="MO"; replace statefip=30 if state=="MT"; replace statefip=31 if state=="NE";
replace statefip=32 if state=="NV"; replace statefip=33 if state=="NH"; replace statefip=34 if state=="NJ"; replace statefip=35 if state=="NM";
replace statefip=36 if state=="NY"; replace statefip=37 if state=="NC"; replace statefip=38 if state=="ND"; replace statefip=39 if state=="OH";
replace statefip=40 if state=="OK"; replace statefip=41 if state=="OR"; replace statefip=42 if state=="PA"; replace statefip=44 if state=="RI";
replace statefip=45 if state=="SC"; replace statefip=46 if state=="SD"; replace statefip=47 if state=="TN"; replace statefip=48 if state=="TX";
replace statefip=49 if state=="UT"; replace statefip=50 if state=="VT"; replace statefip=51 if state=="VA"; replace statefip=53 if state=="WA";
replace statefip=54 if state=="WV"; replace statefip=55 if state=="WI"; replace statefip=56 if state=="WY"; rename state statename;
save "${basedirectory}temp2.dta", replace;

*----------------------------------------*;
*-------------PREPARE CPI DATA-----------*;
*----------------------------------------*;
*CPI downloaded from BLS, all urban consumers, excluding energy;
insheet using "${basedirectory}cpi.csv", clear;
rename value cpi; rename period mon; drop seriesid;
gen month=0; replace month=1 if mon=="Jan"; replace month=2  if mon=="Feb"; replace month=3  if mon=="Mar"; replace month=4  if mon=="Apr"; 
		 replace month=5 if mon=="May"; replace month=6  if mon=="Jun"; replace month=7  if mon=="Jul"; replace month=8  if mon=="Aug";  
		 replace month=9 if mon=="Sep"; replace month=10 if mon=="Oct"; replace month=11 if mon=="Nov"; replace month=12 if mon=="Dec"; drop mon;
drop if year<1989; drop if year>=2008 & month>3; sort year month; save "${basedirectory}cpi.dta", replace; clear;

*----------------------------------------*;
*--------CREATE YEAR AND MONTH-----------*;
*----------------------------------------*;
use "${basedirectory}temp2.dta", clear; erase "${basedirectory}temp2.dta";
gen year=real(substr(date,5,9));
gen mon=substr(date,1,3); drop date;
gen month=0; replace month=1 if mon=="Jan"; replace month=2  if mon=="Feb"; replace month=3  if mon=="Mar"; replace month=4  if mon=="Apr"; 
		 replace month=5 if mon=="May"; replace month=6  if mon=="Jun"; replace month=7  if mon=="Jul"; replace month=8  if mon=="Aug";  
		 replace month=9 if mon=="Sep"; replace month=10 if mon=="Oct"; replace month=11 if mon=="Nov"; replace month=12 if mon=="Dec"; drop mon;
gen date=year+(month-1)/12;

*----------------------------------------*;
*----IMPUTE MISSING PRICES AND VOLUMES---*;
*----------------------------------------*;
bysort statefip: ipolate volume date, gen(i_volume) epolate;
bysort statefip: ipolate price date, gen(i_price) epolate;
replace volume=i_volume if volume==.;
replace price=i_price   if price==.;
drop i_volume i_price;

*-----------------------------------------------------*;
*----------MERGE WITH UNEMPLOYMENT DATA---------------*;
*-----------------------------------------------------*;
sort statefip year month;
merge statefip year month using "${basedirectory}Unemployment Rates from BLS/unemp.dta";
keep if _merge==3; drop _merge;

*-----------------------------------------------------*;
*----------MERGE WITH POPULATION DENSITY--------------*;
*-----------------------------------------------------*;
sort statefip year month;
merge statefip year month using "${basedirectory}Pop Density from Census/popdensity.dta";
keep if _merge==3; drop _merge;

*-----------------------------------------------------*;
*----------------MERGE WITH TAX DATA------------------*;
*-----------------------------------------------------*;
*THE DOT DATA DESCRIBE ONLY THE PER UNIT TAX, AD VALOREM TAXES ARE ADDED IN BELOW;
drop if statefip==.;
sort statefip year month;
merge statefip year month using "${basedirectory}Tax Rates from Highway Statistics/taxrates.dta";
keep if _merge==3; drop _merge;

*---------------------------------------------------*;
*-----INCORPORATE AD VALOREM TAX WHERE NECESSARY----*;
*---------------------------------------------------*;
gen Utax=statetax+fedtax;   *Utax denotes the tax, here nominal, in cents per gallon;
gen AfterTaxPrice=price+statetax+fedtax;
replace AfterTaxPrice=(price+statetax+fedtax)*(1.06) if state=="California";
replace AfterTaxPrice=(price+fedtax)*(1.04)+statetax if state=="Georgia" & year>=1992;
replace AfterTaxPrice=(price+fedtax)*(1.03)+statetax if state=="Georgia" & year<1992;
replace AfterTaxPrice=(price)*(1.04)+statetax+fedtax if state=="Hawaii";
replace AfterTaxPrice=(price)*(1.06)+statetax+fedtax if state=="Illinois" & year<1990;
replace AfterTaxPrice=(price)*(1.0625)+statetax+fedtax if state=="Illinois" & year>=1990 & year<=2000;
replace AfterTaxPrice=(price)*(1.06)+statetax+fedtax if state=="Indiana" & year>=2003;
replace AfterTaxPrice=(price)*(1.05)+statetax+fedtax if state=="Indiana" & year<2003;
replace AfterTaxPrice=(price+fedtax)*(1.06)+statetax if state=="Michigan" & year>=1994;
replace AfterTaxPrice=(price+fedtax)*(1.04)+statetax if state=="Michigan" & year<1994;
replace AfterTaxPrice=(price+statetax+fedtax)*(1.06) if state=="Mississippi" & year<=1987;
replace AfterTaxPrice=(price+fedtax)*(1.04)+statetax if state=="New York";
replace AfterTaxPrice=(price+fedtax)*(1.0425)+statetax if state=="New York" & ((year==2003 & month>=6) | year==2004 | (year==2005 & month<6));
replace AfterTaxPrice=(price+fedtax+statetax)*(1.02) if state=="Virginia" & year<=1994;

*-----------------------------------------------------*;
*----------------DEFLATE USING CPI--------------------*;
*-----------------------------------------------------*;
*Base period January 2008 (cpi=212.281);
sort year month;
merge year month using "${basedirectory}cpi.dta";
replace cpi=(cpi/212.281)*100;
drop if _merge!=3; drop _merge;
replace AfterTaxPrice=AfterTaxPrice/(cpi); 
replace Utax=Utax/cpi;
save "${basedirectory}prices&volumes.dta", replace;

*----------------------------------------------------*;
*----------------CREATE VARIABLES--------------------*;
*----------------------------------------------------*;
*PREPARE DATA;
use "${basedirectory}prices&volumes.dta", clear;

drop v62;

gen timevariable = year*12 + month;
rename timevariable time;
tsset statefip time;

gen logprice = log(AfterTaxPrice);
gen logvolume = log(volume);
gen logtax = log(Utax);
gen logpopdensity = log(popdensity); 
gen dlogprice = D.logprice;
gen dlogvolume = D.logvolume;
gen dlogtax = D.logtax;
gen dstatetax = D.statetax;

save "${basedirectory}CleanData.dta", replace;

*------------------------------------------------------------*;
*-----------Create Pairwise Dataset Using Joinby-------------*;
*------------------------------------------------------------*;

*Residualize;
quietly reg d.logtax d.unemployment i.time; predict dlogtax_resid, residuals;
quietly reg d.logprice d.unemployment i.time; predict dlogprice_resid, residuals;
quietly reg d.logvolume d.unemployment i.time; predict dlogvolume_resid, residuals;
save "${basedirectory}cleandata_resid.dta", replace;
*Make Dataset Describing 162 Nominal Tax Changes Larger Than One Cent;
keep if abs(d.statetax)>=1 & d.statetax!=.;
rename time changedate;
gen increase=(dstatetax>=0);
gen decrease=(dstatetax<=0);
gen twocentincrease=(dstatetax>=2);
gen twocentdecrease=(dstatetax<=-2);
keep statefip changedate increase decrease twocent*;
save "${basedirectory}tax_changes.dta", replace;

*Create Variable Describing Event Study Time, Tax Change Occurs At T=1;
use "${basedirectory}cleandata_resid.dta", clear;
joinby statefip using "${basedirectory}tax_changes.dta", unmatched(both); assert _merge==1 | _merge==3; drop _merge;
gen spelltime=time-changedate+1;
save "${basedirectory}cleandata_joinby.dta", replace;
erase "${basedirectory}cleandata_resid.dta"; erase "${basedirectory}tax_changes.dta";

*------------------------------------------------*;
*--------------Event Study Figures---------------*;
*------------------------------------------------*;

*Bring in data and report the number of tax changes by type;
use "${basedirectory}cleandata_joinby.dta", clear;
keep if spelltime>=-10 & spelltime<=10;

foreach v of varlist increase twocentincrease decrease twocentdecrease {;
tab `v' if spelltime==1;

*Figure 2a: Plot Mean Residuals All 1+ Cent Increases;
binscatter dlogtax_resid spelltime if `v', name(`v'_tax_bs) 
	discrete linetype(connect) xline(0) xtitle("")
	ylabel(, labsize(small))
	xlabel(,labsize(small))
	ytitle("Change in Log", size(small)) 
	title("A. Gasoline Tax", size(medsmall));

binscatter dlogprice_resid spelltime if `v', name(`v'_price_bs)
	discrete linetype(connect) xline(0) xtitle("")
	ylabel(, labsize(small))
	xlabel(,labsize(small))
	ytitle("Change in Log", size(small))  
	title("B. Retail Gasoline Price", size(medsmall));
	
binscatter dlogvolume_resid spelltime if `v', name(`v'_quantity_bs) 
	discrete linetype(connect) xline(0) xtitle("")
	ylabel(,labsize(small))
	xlabel(,labsize(small))
	ytitle("Change in Log", size(small)) 
	title("C. Gasoline Purchases", size(medsmall));
	
graph combine `v'_tax_bs `v'_price_bs `v'_quantity_bs, name(`v')
	col(1) xsize(8.5) ysize(11)
	plotregion(style(none)) graphregion(fcolor(white));
	graph export "${basedirectory}`v'_allseries.eps", replace;
	graph export "${basedirectory}`v'_allseries.png", replace; };


*----------------------------------------------------------*;
*--------Regression Table Analogue to Event Study----------*;
*----------------------------------------------------------*;

*Loop over Categories of Tax Changes;
capture erase "${basedirectory}Event Study Table.xls"; 
capture erase "${basedirectory}Event Study Table.txt";
foreach v in increase twocentincrease decrease twocentdecrease {;
use "${basedirectory}cleandata_joinby.dta", clear;
replace spelltime=999 if spelltime==.; replace spelltime=999 if `v'!=1;
gen abspelltime=abs(spelltime); sort statefip time abspelltime; 
bysort statefip time: gen n=_n; keep if n==1;
tsset statefip time; gen t0=(spelltime==0); gen t1=(spelltime==1); gen t2=(spelltime==2); tab t0; 

*Lead, Contemporaneous, and Single Lag;
quietly reg d.logvolume t0 t1 t2 d.unemployment i.time, cluster(statefip);
	outreg2 using "${basedirectory}Event Study Table.xls", 
	drop(d.unemployment i.time) label nocons excel dec(3)
	addtext("Time Fixed Effects", "Yes", "Change in Unemployment", "Yes"); };


*----------------------------------------------*;
*-------------- IV Regressions   --------------*;
*----------------------------------------------*;

*Clear memory and bring in Data;
use "${basedirectory}CleanData.dta", clear;

*Few Last Definitions;
gen dunemployment = d.unemployment;
gen TwoCentIncrease=(dstatetax>=2 & dstatetax!=.);
gen TwoCentDecrease=(dstatetax<=-2 & dstatetax!=.);
gen Iincrease = TwoCentIncrease * dlogtax;

local options drop(d.unemployment i.time dunemployment_rt) label nocons excel addtext("Time Fixed Effects", "Yes", "Change in Unemployment", "Yes");

* IV using residual projection method;
foreach x of varlist dlogvolume dlogprice  dlogtax dunemployment {;
 quietly reg `x' i.time; predict `x'_rt, residuals;
 quietly reg f.`x' i.time; predict f1`x'_rt, residuals;
 quietly reg f2.`x' i.time; predict f2`x'_rt, residuals;
 quietly reg l.`x' i.time; predict l1`x'_rt, residuals;
 quietly reg l2.`x' i.time; predict l2`x'_rt, residuals;
 quietly reg l3.`x' i.time; predict l3`x'_rt, residuals;
};
foreach x of varlist TwoCentIncrease TwoCentDecrease Iincrease {;
 quietly reg `x' i.time; predict `x'_rt, residuals;
 quietly reg f.`x' i.time; predict f1`x'_rt, residuals;
 quietly reg l.`x' i.time; predict l1`x'_rt, residuals;
};

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
dis "    Regression 1 - OLS Baseline ";
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
regress d.logvolume d.unemployment dlogprice i.time, cluster(statefip);
	lincom dlogprice; outreg2 using "${basedirectory}Table 2.xls", replace addstat("Cumulative Effect", r(estimate),"se", r(se)) `options';

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
dis "    Regression 2 - Baseline Specification";
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
local ivlist "dlogtax_rt";
local endoglist "dlogprice_rt";
global lincomlist "dlogprice_rt";
	ivregress 2sls dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), cluster(statefip); 
	estimates store tsls;
	lincom $lincomlist; 
	local lincomest = r(estimate);
	local lincomse = r(se);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist');
	local craggdonald = e(widstat);
	lincom $lincomlist; 
	outreg2 [tsls] using "${basedirectory}Table 2.xls", addstat("Cumulative Effect", `lincomest', "se", `lincomse', 
		"Cragg-Donald Statistic", `craggdonald') `options';

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
dis "    Regression 3 - Baseline Specification -- Overidentified";
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
local ivlist "f1dlogtax_rt dlogtax_rt l1dlogtax_rt";
local endoglist "dlogprice_rt";
global lincomlist "dlogprice_rt";
	ivregress 2sls dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), cluster(statefip); 
	estimates store tsls;
	lincom $lincomlist; 
	local lincomest = r(estimate);
	local lincomse = r(se);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist');
	local craggdonald = e(widstat);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), gmm2s cluster(statefip);
	local hansenj = e(j);
	local hansenjp = e(jp);
	lincom $lincomlist; 
	outreg2 [tsls] using "${basedirectory}Table 2.xls", addstat("Cumulative Effect", `lincomest',"se", `lincomse', 
		"Cragg-Donald Statistic", `craggdonald', "Hansen J statistic", `hansenj', "Hansen J p-value", `hansenjp', 
		"GMM Cumulative Effect", r(estimate), "GMM se", r(se)) `options';

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
dis "    Regression 4 - OLS With Lead and Lag";
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
regress dlogvolume_rt f1dlogprice_rt dlogprice_rt l1dlogprice_rt dunemployment_rt, cluster(statefip); 
regress d.logvolume d.unemployment f.dlogprice L(0/1).dlogprice i.time, cluster(statefip);
	lincom F.dlogprice + dlogprice + L.dlogprice; outreg2 using "${basedirectory}Table 2.xls", addstat("Cumulative Effect", r(estimate),"se", r(se)) `options';

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
dis "    Regression 5 - With Lead and Lag";
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
local ivlist "f1dlogtax_rt dlogtax_rt l1dlogtax_rt";
local endoglist "f1dlogprice_rt dlogprice_rt l1dlogprice_rt";
global lincomlist "f1dlogprice_rt+dlogprice_rt+l1dlogprice_rt";
	ivregress 2sls dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), cluster(statefip); 
	lincom $lincomlist; 
	local lincomest = r(estimate);
	local lincomse = r(se);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist');
	local craggdonald = e(widstat);
	lincom $lincomlist; 
	outreg2 using "${basedirectory}Table 2.xls", addstat("Cumulative Effect", `lincomest',"se", `lincomse', 
		"Cragg-Donald Statistic", `craggdonald') `options';

* --------- Table 3 regressions ----------------
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
dis "    Regression 6 - with additional lead and lag as instruments";
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
local ivlist "f2dlogtax_rt f1dlogtax_rt dlogtax_rt l1dlogtax_rt l2dlogtax_rt";
local endoglist "f1dlogprice_rt dlogprice_rt l1dlogprice_rt";
global lincomlist "f1dlogprice_rt+dlogprice_rt+l1dlogprice_rt";
	ivregress 2sls dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), cluster(statefip); 
	estimates store tsls;
	lincom $lincomlist; 
	local lincomest = r(estimate);
	local lincomse = r(se);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist');
	local craggdonald = e(widstat);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), gmm2s cluster(statefip);
	local hansenj = e(j);
	local hansenjp = e(jp);
	lincom $lincomlist; 
	outreg2 [tsls] using "${basedirectory}Table 3.xls", replace addstat("Cumulative Effect", `lincomest',"se", `lincomse', 
		"Cragg-Donald Statistic", `craggdonald', "Hansen J statistic", `hansenj', "Hansen J p-value", `hansenjp', 
		"GMM Cumulative Effect", r(estimate), "GMM se", r(se)) `options';

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
dis "    Regression 7 - Changes Greater Than Two Cents, With Lead and Lag";
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
local ivlist "f1TwoCentIncrease_rt f1TwoCentDecrease_rt TwoCentIncrease_rt TwoCentDecrease_rt l1TwoCentIncrease_rt l1TwoCentDecrease_rt";
local endoglist "f1dlogprice_rt dlogprice_rt l1dlogprice_rt";
global lincomlist "f1dlogprice_rt+dlogprice_rt+l1dlogprice_rt";
	ivregress 2sls dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), cluster(statefip); 
	estimates store tsls;
	lincom $lincomlist; 
	local lincomest = r(estimate);
	local lincomse = r(se);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist');
	local craggdonald = e(widstat);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), gmm2s cluster(statefip);
	local hansenj = e(j);
	local hansenjp = e(jp);
	lincom $lincomlist; 
	outreg2 [tsls] using "${basedirectory}Table 3.xls", addstat("Cumulative Effect", `lincomest',"se", `lincomse', 
		"Cragg-Donald Statistic", `craggdonald', "Hansen J statistic", `hansenj', "Hansen J p-value", `hansenjp', 
		"GMM Cumulative Effect", r(estimate), "GMM se", r(se)) `options';
	
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
dis "    Regression 8 - Increases Greater Than Two Cents, With Lead and Lag";
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
local ivlist "f1TwoCentIncrease_rt TwoCentIncrease_rt l1TwoCentIncrease_rt";
local endoglist "f1dlogprice_rt dlogprice_rt l1dlogprice_rt";
global lincomlist "f1dlogprice_rt+dlogprice_rt+l1dlogprice_rt";
	ivregress 2sls dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), cluster(statefip); 
	estimates store tsls;
	lincom $lincomlist; 
	local lincomest = r(estimate);
	local lincomse = r(se);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist');
	local craggdonald = e(widstat);
	lincom $lincomlist; 
	outreg2 [tsls] using "${basedirectory}Table 3.xls", addstat("Cumulative Effect", `lincomest',"se", `lincomse', 
		"Cragg-Donald Statistic", `craggdonald') `options';
	
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
dis "    Regression 9 - Decreases Greater Than Two Cents, With Lead and Lag";
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
local ivlist "f1TwoCentDecrease_rt TwoCentDecrease_rt l1TwoCentDecrease_rt";
local endoglist "f1dlogprice_rt dlogprice_rt l1dlogprice_rt";
global lincomlist "f1dlogprice_rt+dlogprice_rt+l1dlogprice_rt";
	ivregress 2sls dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), cluster(statefip); 
	estimates store tsls;
	lincom $lincomlist; 
	local lincomest = r(estimate);
	local lincomse = r(se);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist');
	local craggdonald = e(widstat);
	lincom $lincomlist; 
	outreg2 using "${basedirectory}Table 3.xls", addstat("Cumulative Effect", `lincomest',"se", `lincomse', 
		"Cragg-Donald Statistic", `craggdonald') `options';

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
dis "    Regression 10 - With Lead and Lag, Instrumenting with Change in Log Tax, Indicators for Changes, and Interactions";
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
local ivlist "f1dlogtax_rt dlogtax_rt l1dlogtax_rt Iincrease f1Iincrease l1Iincrease";
local endoglist "f1dlogprice_rt dlogprice_rt l1dlogprice_rt";
global lincomlist "f1dlogprice_rt+dlogprice_rt+l1dlogprice_rt";
	ivregress 2sls dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), cluster(statefip); 
	estimates store tsls;
	lincom $lincomlist; 
	local lincomest = r(estimate);
	local lincomse = r(se);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist');
	local craggdonald = e(widstat);
	ivreg2 dlogvolume_rt dunemployment_rt (`endoglist' = `ivlist'), gmm2s cluster(statefip);
	local hansenj = e(j);
	local hansenjp = e(jp);
	lincom $lincomlist; 
	outreg2 [tsls] using "${basedirectory}Table 3.xls", addstat("Cumulative Effect", `lincomest',"se", `lincomse', 
		"Cragg-Donald Statistic", `craggdonald', "Hansen J statistic", `hansenj', "Hansen J p-value", `hansenjp', 
		"GMM Cumulative Effect", r(estimate), "GMM se", r(se)) `options';

*ERASE TEMPORARY FILES;
erase "${basedirectory}CleanData.dta";
erase "${basedirectory}cleandata_joinby.dta";
erase "${basedirectory}prices&volumes.dta";
erase "${basedirectory}cpi.dta";
