/* Gauss proc returns the likelihood function of the SVAR(1) under the following restrictions:  */
/* diag cov matrix, given values of the LR response of m to y and y to m. NB: Overidentified.   */
/* SVAR is of form B*X(t) = GAMMA0 + GAMMA1*X(t-1) + U where X = [dm, dy]                       */
/* theta = 0 is LREM, theta = 1 is LRPS, lambda = 0 is LRMN.                                    */

proc svarmo(beta,x) ;
local np, dms, dyr, b12, b21, g10, g20, g11, g12, g21, g22, s11, s22, um, uy, ttt, uuu, cov, imp, llf ;

np = rows(x) ;			/* Number of observations 	*/
dms = x[.,1] ;			/* Money series 			*/
dyr = x[.,2] ;			/* Output series			*/

b12 = beta[1] ;
b21 = beta[2] ;
g10 = beta[3] ;
g20 = beta[4] ;
g11 = beta[5] ;
g22 = beta[6] ;
g12 = b12 + theta*(1-g11)  ;		/* LRMY restriction	*/
g21 = b21 + lambda*(1-g22) ;		/* LRMN restriction	*/
s11 = beta[7] ;
s22 = beta[8] ;

/* Money Equation: dm_t  = gamma10 - beta12*dy_t + gamma11*dm_t-1 + gamma12*dy_t-1 + um  */

 um = dms[2:np] - g10 + b12*dyr[2:np] - g11*dms[1:np-1]- g12*dyr[1:np-1] ;

/* Output Equation: dy_t  = gamma20 - beta21*dm_t + gamma21*dm_t-1 + gamma22*dy_t-1 + uy  */

 uy = dyr[2:np] - g20 + b21*dms[2:np] - g21*dms[1:np-1] - g22*dyr[1:np-1] ;

ttt = rows(um) ;
uuu = um~uy ;
cov = s11~0|0~s22 ;
imp = 1~b12|b21~1 ;

/* Log Likelihood Function */

llf = (-ttt/2)*ln(det(cov)) + ttt*ln(abs(det(imp))) - (ttt/2)*sumc(diag((1/ttt)*inv(cov)*(uuu'uuu))) ;

/* Return Parameter Estimtates and End Procedure */

retp(llf) ;

endp ;