new ;
#lineson ;
library maxlik optmum ;
#include optmum.ext
optset ;
maxset ;

/*  Gauss program for Coe & Nason "Long-run Monetary Neutrality...."        */
/*  1) Calculates t/T statistics using sample data. Valkanov (2003)         */   
/*  2) Generates empirical distribution of t/T under null		            */
/*  3) Calculates size adjusted power of t/T statistics		                */
/*  Requires the following procs: fslrd.g, hodlrd.g, bartwin.g, bartpw.g,   */
/*                                grdbetak.g, svarmo.g, svarivj.g           */

/*  NEED TO SET: ECONOMY, AGGREGATE, PRE-WHITEN HAC?, # BOOTSTRAPS          */

/* Program Settings */
/* **************** */

econ = 4 ;		/* 1 = AU, 2 = CN,  3 = UK,  4 = US 	*/
magg = 2 ;		/* 1 = BASE, 2 = STOCK					*/
pw = 0 ;        /* 0 = no pre-whitening, 1 = pre-whiten */
nrep = 10000 ;	/* Number of bootstrap repititions      */

if econ == 1 ;
    if magg == 1 ;
        output file = lrmn4aub.out reset ;
    elseif magg == 2 ;
        output file = lrmn4aum.out reset ;
    endif ;
elseif econ == 2 ;
    if magg == 1 ;
        output file = lrmn4cnb.out reset ;
    elseif magg == 2 ;
        output file = lrmn4cnm.out reset ;
    endif ;
elseif econ == 3 ;
    if magg == 1 ;
        output file = lrmn4ukb.out reset ;
    elseif magg == 2 ;
        output file = lrmn4ukm.out reset ;
    endif ;
elseif econ == 4 ;
    if magg == 1 ;
        output file = lrmn4usb.out reset ;
    elseif magg == 2 ;
        output file = lrmn4usm.out reset ;
    endif ;
endif ;

output on ;

/* Load Sample Data and Take 1st Differences */
/* ***************************************** */

if econ == 1 ;
  	np = 94 ;
	load audat[np,3] = au.mat ;
   	m = audat[.,magg] ;
	y = audat[.,3] ;
    print " AUSTRALIA 1900/01-1993/94 " ;
    print " ------------------------- " ;
elseif econ == 2 ;
	np = 123 ;
    load cndat[np,3] = cn.mat ;
    m = cndat[.,magg] ;
    y = cndat[.,3] ;
	print " CANADA 1872-1994 " ;
    print " ---------------- " ;
elseif econ == 3 ;
	np = 123 ;
    load ukdat[np,3] = uk.mat ;
	m = ukdat[.,magg] ;
    y = ukdat[.,3] ;
	print " UNITED KINGDOM 1871-1993 " ;
    print " ------------------------ " ;
elseif econ == 4 ;
	np = 129 ;
    load usdat[np,3] = us.mat ;
	m = usdat[.,magg] ;
    y = usdat[.,3] ;
	print " UNITED STATES 1869-1997 " ;
    print " ----------------------- " ;
endif ;
print ;

if magg == 1 ;
	print " Monetary aggregate is the monetary base " ;
elseif magg == 2 ;
	print " Monetary Aggregate in the money stock " ;
endif ;
print ;

print " Sample Size = " ;;    np ;
print ;

dm = 100*(m[2:np] - m[1:np-1]) ;		/* 1st difference of money series (stock)       */
dy = 100*(y[2:np] - y[1:np-1]) ;		/* 1st difference of output series 			    */
obs = rows(dm) ;                        /* Number of observations of 1st differences    */

/* Estimate betaols & betavar on sample data */
/* ***************************************** */

kk = seqa(1,1,30) ;           /* Horizons to consider, k = 1,2,...,30  */

{ smlrdols } = fslrd(y,m,0) ;
{ smlrdvar } = hodlrd(y,m,0) ;

format /rd 10,4 ;

print " Sample Estimates from Long Horizon Regressions " ;
print " ---------------------------------------------- " ;
print ;
print "       k      beta(ols) t-stat/T  beta(var) t-stat/T" ;
print " ------------------------------------------------------------------------------" ;
kk~smlrdols[.,1]~(smlrdols[.,3]/np)~smlrdvar[.,1]~(smlrdvar[.,3]/np) ;
print " ------------------------------------------------------------------------------" ;
print ;

/* Bootstrap Experiment Under the Null Hypothesis */
/* ********************************************** */

print "  Bootstrap Experiment " ;
print " --------------------- " ;
print ;
print " DGP satisfies: DIAG, LREM & LRMN (SVAR is over-identified) " ;
print ;

/* Estimate SVAR(1) under restrictions using FIML and sample data */

theta = 0 ;					/* long-run response of money to output	is zero => LREM */
lambda = 0 ;				/* long-run response of output to money	is zero => LRMN */

/* Set starting values */

if econ == 1 ;
	if magg == 1 ;
        beta0 = { -0.07, 0.01, 4.3, 3.4, 0.41, -0.11, 59, 22 } ;
	else ;
		beta0 = { 0.06, -0.25, 3.5, 3.4, 0.53, -0.12, 21, 21 } ;
	endif ;
elseif econ == 2 ;
	if magg == 1 ;
		beta0 = { 0.09, -0.29, 1.9, 3.0, 0.68, 0.19, 28, 30 } ;
	else ;
		beta0 = { 0.10, -0.40, 2.5, 3.0, 0.63, 0.19, 19, 30 } ;
	endif ;
elseif econ == 3 ;
	if magg == 1 ;
		beta0 = { 0.41, -0.31, 1.6, 1.5, 0.62, 0.18, 21, 10 } ;
	else ;
		beta0 = { 0.28, -0.50, 0.79, 1.6, 0.84, 0.16, 9.3, 10 } ;
	endif ;
elseif econ == 4 ;
	if magg == 1 ;
		beta0 = { 0.08, -0.47, 1.8, 2.9, 0.65, 0.08, 16, 35 } ;
	else ;
		beta0 = { -0.09, -0.19, 3.1, 2.7, 0.47, 0.15, 34, 33 } ;
	endif ;
endif ;

_Max_Algorithm = 2 ;
__output = 0 ;

{ beta,f,g,cov,retcode } = maxprt(maxlik(dm~dy,0,&svarmo,beta0)) ;

/* Compile SVAR matricies */

 B = 1~beta[1]|beta[2]~1 ;
G0 = beta[3]|beta[4] ;
G1 = beta[5]~(beta[1] + theta*(1-beta[5]))|beta[2]~beta[6] ;
SIGMA = beta[7]~0|0~beta[8] ;

/* Set up bootstrap experiment */

nobs = np*3 ;					                        /* Generate T*3 observations: will discard 1st 2*T                  */
  ns1 = 2468642 ;  
  ns2 = 1234321 ;       								/* Seed numbers						                                */
draw1 = ceil(rndus(nobs-2,nrep,ns1)*100%(obs-2))+1 ;	/* Matrix of draws					                                */
draw2 = ceil(rndus(nobs-2,nrep,ns2)*100%(obs-2))+1 ;	/*If levels series has N obs then SVAR(1) in 1st diff uses N-2 obs	*/

/* Calculate residuals from which to re-sample */
		
u = (dm[2:obs]~dy[2:obs])*B - (dm[1:obs-1]~dy[1:obs-1])*G1 ;
u[.,1] = u[.,1] - G0[1] ;
u[.,2] = u[.,2] - G0[2] ;

/* Set up some empty matricies */

tstato = zeros(1,rows(kk)) ;			/* tag bootstrapped t-stat (ols) onto this row vector	*/
tstatv = zeros(1,rows(kk)) ;			/* tag bootstrapped t-stat (var) onto this row vector	*/
ecv95o = zeros(1,rows(kk)) ;
ecv95v = zeros(1,rows(kk)) ;

/* Begin bootstrap repititions */

j = 1 ;
do while j <= nrep ;

	/* Generate bootstrap sample */

	bsm = zeros(nobs,1) ;				/* store simulated level of m in this vector	*/
	bsy = zeros(nobs,1) ;				/* store simulated level of y in this vector	*/
	bsy[1:2] = 0|0 ;					/* use zeros for initial values					*/
	bsm[1:2] = 0|0 ;					/* as above										*/
	bdx1 = 0|0 ;			            /* initial 1st differences 						*/ 	
	drawj = draw1[.,j]~draw2[.,j] ;     /* random Integers for resampling residuals     */

	/* Rest of time series */

	t = 3 ;
	do while t <= nobs ;	

		drawjt1 = drawj[t-2,1] ;			/* locator for draw from money residuals    */
		drawjt2 = drawj[t-2,2] ;            /* locator for draw from output residuals   */
		be = u[drawjt1,1]|u[drawjt2,2] ;	/* resampled errors for bootstrap	        */

		bdx = inv(B)*G0 + inv(B)*G1*bdx1 + inv(B)*be ;
		bsm[t] = bsm[t-1] + bdx[1]/100 ;
		bsy[t] = bsy[t-1] + bdx[2]/100 ;
		bdx = bdx1 ;

	t = t + 1 ;
	endo ;

    /* Delete 1st 2*np observations */
    
    bsy = bsy[2*np+1:nobs] ;
    bsm = bsm[2*np+1:nobs] ;
        
	/* Estimate long-run derivatives using bootstrap sample */

	{ lrdols } = fslrd(bsy,bsm,pw) ;
	{ lrdvar } = hodlrd(bsy,bsm,pw) ;

	tstato = tstato|(lrdols[.,3]./sqrt(np))' ;		/* stores t-stat(ols)	    */
	tstatv = tstatv|(lrdvar[.,3]./sqrt(np))' ;		/* stores t-stat(var)	    */

j = j + 1 ;
endo ;

/* Take absolute values of t-stats & remove intial row vectors */
	
tstato = abs(tstato[2:nrep+1,.]) ;
tstatv = abs(tstatv[2:nrep+1,.]) ;

/* Obtain 95% empirical critical values */

k = 1 ;
do while k <= rows(kk) ;
    stst = sortc(tstato[.,k],1) ;
    ecv95o[k] = stst[0.95*nrep] ;
    stst = sortc(tstatv[.,k],1) ;
    ecv95v[k] = stst[0.95*nrep] ;
k = k + 1 ;
endo ;

/* Format & print output from bootstrap experiment for k = 5, 10, 15, 20, 25, 30 */

k = 5 ;
do while k <= rows(kk) ;
	
    /* Sort betas and t-stats for k */

	ststato = sortc(tstato[.,k],1) ;		/* Remove intial row vector of zeros & sort absolute value of t-stat(ols)	*/
	ststatv = sortc(tstatv[.,k],1) ;		/* Remove intial row vector of zeros & sort absolute value of t-stat(var)	*/

	format /rd 3,0 ;

	print " Horizon = " ;; kk[k] ;
	print ;

	format /rd 14,4 ; 

	print " Percentile    t-stat(ols)    t-stat(var) " ;
	print " ----------------------------------------- " ;
	print "    5% " ;;	ststato[0.05*nrep]~ststatv[0.05*nrep] ;
	print "   10% " ;;	ststato[0.10*nrep]~ststatv[0.10*nrep] ;
	print "   50% " ;;	ststato[0.50*nrep]~ststatv[0.50*nrep] ;
	print "   90% " ;;	ststato[0.90*nrep]~ststatv[0.90*nrep] ;
	print "   95% " ;;	ststato[0.95*nrep]~ststatv[0.95*nrep] ;
	print " ----------------------------------------- " ;
	print ;
    
	/* Accept / Reject Null */

	gtso = selif(ststato, ststato .gt smlrdols[k,3]/np) ;	/* Select repititions where |t-stat| greater than on sample data */
	gtsv = selif(ststatv, ststatv .gt smlrdvar[k,3]/np) ;

	print ;
	print " Empirical p-value for OLS Estimate = " ;; rows(gtso)/nrep ;	
	print " Empirical p-value for VAR Estimate = " ;; rows(gtsv)/nrep ;	
	print ;

k = k + 5 ;
endo ;

/* Bootstrap Experiment Under the Alternative Hypothesis */
/* ***************************************************** */

kk = seqa(5,5,6) ;           /* Horizons to consider, k = 5,10,...,30 */

print "  Bootstrap Experiment " ;
print " --------------------- " ;
print ;
print " DGP satisfies: DIAG & LREM (SVAR is just-identified)        " ;
print ;

/* Estimate SVAR(1) under restrictions using IV and sample data */

theta = 0 ;					/* long-run response of money to output	*/

" Estimates of Just Identified SVAR by FIML using sample data " ;
print ;

{ B, G0, G1, SIGMA } = svarivj(dm,dy) ;

/* Set up bootstrap experiment */

nobs = np*3 ;					                        /* Generate T*3 observations: will discard 1st 2*T                  */
ns1 = 8642468 ;  
ns2 = 4321234 ;       								    /* Seed numbers						                                */
draw1 = ceil(rndus(nobs-2,nrep,ns1)*100%(obs-2))+1 ;	/* Matrix of draws		                                			*/
draw2 = ceil(rndus(nobs-2,nrep,ns2)*100%(obs-2))+1 ;	/* Levels series has N obs then SVAR(1) in 1st diff uses N-2 obs	*/

/* Calculate residuals from which to re-sample */
		
u = (dm[2:obs]~dy[2:obs])*B - (dm[1:obs-1]~dy[1:obs-1])*G1 ;
u[.,1] = u[.,1] - G0[1] ;
u[.,2] = u[.,2] - G0[2] ;

/* Set up some empty matricies */

tstato = zeros(1,rows(kk)) ;			/* tag bootstrapped t-stat (ols) onto this row vector	*/
tstatv = zeros(1,rows(kk)) ;			/* tag bootstrapped t-stat (var) onto this row vector	*/

/* Begin bootstrap repititions */

j = 1 ;
do while j <= nrep ;

	/* Generate bootstrap sample */

	bsm = zeros(nobs,1) ;				/* store simulated level of m in this vector	*/
	bsy = zeros(nobs,1) ;				/* store simulated level of y in this vector	*/
	bsy[1:2] = 0|0 ;					/* use zeros for initial values					*/
	bsm[1:2] = 0|0 ;					/* as above										*/
	bdx1 = 0|0 ;			            /* initial 1st differences 						*/ 	
	drawj = draw1[.,j]~draw2[.,j] ;     /* random Integers for resampling residuals     */

	/* Rest of time series */

	t = 3 ;
	do while t <= nobs ;	

		drawjt1 = drawj[t-2,1] ;			/* locator for draw from money residuals    */
		drawjt2 = drawj[t-2,2] ;            /* locator for draw from output residuals   */
		be = u[drawjt1,1]|u[drawjt2,2] ;	/* resampled errors for bootstrap	        */

		bdx = inv(B)*G0 + inv(B)*G1*bdx1 + inv(B)*be ;
		bsm[t] = bsm[t-1] + bdx[1]/100 ;
		bsy[t] = bsy[t-1] + bdx[2]/100 ;
		bdx = bdx1 ;

	t = t + 1 ;
	endo ;

    /* Delete 1st 2*np observations */
    
    bsy = bsy[2*np+1:nobs] ;
    bsm = bsm[2*np+1:nobs] ;
        
	/* Estimate long-run derivatives using bootstrap sample */

	{ lrdols } = fslrd(bsy,bsm,pw) ;
	{ lrdvar } = hodlrd(bsy,bsm,pw) ;

	tstato = tstato|(lrdols[.,3]./sqrt(np))' ;		/* stores t-stat(ols)	    */
	tstatv = tstatv|(lrdvar[.,3]./sqrt(np))' ;		/* stores t-stat(var)	    */

j = j + 1 ;
endo ;

/* Take absolute values of t-stats & remove intial row vectors */
	
tstato = abs(tstato[2:nrep+1,.]) ;
tstatv = abs(tstatv[2:nrep+1,.]) ;

/* Format & print output from bootstrap experiment */

k = 1 ;
do while k <= rows(kk) ;

 
	/* Accept / Reject Null */

	rejo = selif(ststato, ststato .gt ecv95o[5*k]) ;	/* Repititions when null rejected w/ empirical critical value. */
	rejv = selif(ststatv, ststatv .gt ecv95v[5*k]) ;

	print " Size Adjusted Power (nominal size = 0.05) for OLS Estimator = " ;; rows(rejo)/nrep ;	
	print " Size Adjusted Power (nominal size = 0.05) for VAR Estimator = " ;; rows(rejv)/nrep ;	
	print ;

k = k + 1 ;
endo ;



end ;
