/* Gauss procedure to calculate long-run derivatives using the VAR estimator.   */ 
/* See Hodrick (RFS1992). Standard errors computed numerically.                 */
/*  Inputs are as follows:  y = natural log of lhs variable, x = natural log of rhs variable.        */
/*                          kk = horizons, pw = 1 if pre-whiten the HAC estimator.                   */
/*  Need the following procs: bartwin.g, bartpw.g, grdbetak.g                                                 */

proc(1) = hodlrdps(y,x,pw,psbias) ;
local tobs, yyy, xxx, nobs, lrd, bbb, eee, vev, ecov, xxm, mxm, zez, sssbb, covbb, sebb, bb, eve, e1, e2, kbb,
      covw0, ibb, ibbt, vwv, k, bi, bit, jk, vwk, bbbaug, gbk ;

/* Data dimension & manipulations etc */

tobs = rows(y) ;					/* Number of levels observations                    */
yyy = (x[3:tobs]-x[2:tobs-1])
     ~(y[3:tobs]-y[2:tobs-1]) ;		/* Dependent variable for RFVAR(1) in differences   */
xxx = (x[2:tobs-1]-x[1:tobs-2])
     ~(y[2:tobs-1]-y[1:tobs-2]) ;	/* Independent variable for RFVAR(1) indifferences	*/
nobs = rows(yyy) ;					/* Number of 1st differences observations           */

lrd = zeros(rows(kk),6) ;

/* Estimate RFVAR(1) in Growth Rates */

xxx = xxx~ones(nobs,1) ;
bbb = solpd(xxx'yyy, xxx'xxx) ; @ Estimate VAR @
eee = yyy - xxx*bbb ;
vev = eee'eee./nobs ;
ecov = (eee[.,1].*eee[.,1] - vev[1,1])
      ~(eee[.,1].*eee[.,2] - vev[1,2])
      ~(eee[.,2].*eee[.,2] - vev[2,2]) ;

/* Calculate HAC Covariance Matrix */

xxm = xxx~zeros(nobs,rows(bbb)+3)
     |zeros(nobs,rows(bbb))~xxx~zeros(nobs,3)
     |zeros(nobs,2*rows(bbb))~ones(nobs,1)~zeros(nobs,2)
     |zeros(nobs,2*rows(bbb)+1)~ones(nobs,1)~zeros(nobs,1)
     |zeros(nobs,2*rows(bbb)+2)~ones(nobs,1) ;

mxm = xxm'xxm ;
zez = (eee[.,1].*xxx)~(eee[.,2].*xxx)~ecov ;

if pw == 0 ;
    sssbb = bartwin(zez,nobs,1) ;           /* no pre-whitening */
elseif pw == 1 ;
    sssbb = bartpw(zez,nobs,1) ;            /* pre-whiten       */
endif ;

covbb = inv(mxm)*sssbb*inv(mxm) ; 			/* HAC Covariance Matrix of VAR Coefficients . */
 sebb = sqrt( diag(covbb) ) ;

/*  Begin construction of VAR Estimator */

 bb = bbb[1:2,.]' ;		/* Pick out VAR(1) matrix */
eve = vev ;
 e1 = 1|0 ;
 e2 = 0|1 ;

/* Compute Unconditional Co-Variance of Money Growth and Income Growth          */
/* From Hodrick this is V(W) = B*V(W)*B' + V(S) where B VAR(1) Matrix,	V(S) is */
/* Co-VAR of VAR residuals.	Apply VEC operator to linearize nonlinear system.	*/
  
kbb = inv(eye(rows(bb)^2) - bb.*.bb) ;	
covw0 = kbb*vecr(eve) ;                    	

/* Calculate sum of autocovariance of W from j = 0 to k */

ibb = inv(eye(rows(bb)) - bb) ;					/* ibb = (I - B)^(-1)	*/
ibbt = inv(eye(rows(bb)) - bb') ;
vwv = covw0[1:2,.] ;
vwv = vwv~covw0[3:4,.] ;

k = 1 ;
do while k <= rows(kk) ;
	bi = bb ;
	bit = bb' ;
	
	jk = 2 ;
	do until jk > kk[k] ;
		bi = bb*bi ;
		bit = bb'bit ;
	jk = jk + 1 ;
	endo ;
	
	jk = jk - 1 ;

	vwk = 2*jk*(ibb + ibbt)*vwv
       - 2*ibb*(bb*bb)*(eye(rows(bb)) - bb*bb*bi)*ibb*vwv
       - 2*ibbt*(bb'bb')*(eye(rows(bb)) - bb'bb'bit)*ibbt*vwv
       - (eye(rows(bb)) - bb*bb*bi)*ibb*vwv
       - (eye(rows(bb)) - bb'bb'bit)*ibbt*vwv
       - 2*(jk - 1)*vwv ;
                                                   
	/* Calculate betavar for current k */

    /* This is BETA(k,VAR) = COV( sum(j=0,k)(1-L)x(t-j), sum(j=0,k)(1-L)y(t-j) ) / VAR( sum(j=0,k)(1-L)x(t-j) ).             */
   	/* Note that if (1-L)x(t) and (1-L)y(t) are stationary its COV( sum(j=0,k)(1-L)x(t+j), sum(j=0,k)(1-L)y(t+j) )           */
    /* = COV( sum(j=0,k)(1-L)x(t-j), sum(j=0,k)(1-L)y(t-j) ) and VAR( sum(j=0,k)(1-L)x(t+j) ) = VAR( sum(j=0,k)(1-L)x(t-j) ) */

	lrd[k,1] = (e2'vwk*e1)/(e1'vwk*e1) - psbias ;    	/* VAR estimator of beta        */
    lrd[k,5] = e2'vwk*e1 ;                  		        /* numerator of VAR estimator   */
    lrd[k,6] = e1'vwk*e1 ;                  				/* denominator of VAR estimator */

k = k + 1 ;
endo ;

/* Call proc to calculate standard error */

bbbaug = vecr(bbb)|vev[1,1]|vev[1,2]|vev[2,2] ;
gbk = gradre(&grdbetak,bbbaug) ;

lrd[.,2] = sqrt( diag( gbk*covbb*gbk' ) ) ;         /* Std Err of BETAVAR(k)    */
lrd[.,3] = lrd[.,1]./lrd[.,2] ;                     /* t-stat                   */
lrd[.,4] = 2*cdftc( abs(lrd[.,3]), tobs./kk) ;      /* p-value                  */

retp(lrd) ;
endp ;
