new ;
#lineson ;
library pgraph;
graphset ;

/* Gauss program to produce figure 5 for Coe & Nason "Long-run Monetary Neutrality...."  
   Plots densities of numerator of VAR estimator under null and alternative. */

/* Requires: ascii files of empirical densities lrmn1??m.mat where ?? = au, cn, uk, us.
			 ndens.g proc which requires weightn.g  									*/

econ = 1 ;		
do while econ <= 4 ;

	/* Load Monte Carlo Output */

	nrep = 10000 ;			/* Number of repitions of Monte Carlo / Bootstrap experiment */

    if econ == 1 ;
		load mcout[nrep,8] = lrmn1aum.mat ;
    elseif econ == 2 ;
		load mcout[nrep,8] = lrmn1cnm.mat ;
    elseif econ == 3 ;
		load mcout[nrep,8] = lrmn1ukm.mat ;
    elseif econ == 4 ;
		load mcout[nrep,8] = lrmn1usm.mat ;
    endif ;

	/* Calculate and Store Densities */
	
	{ dcov0, xcov0 } = ndens(mcout[.,3],250,nrep) ;					/* cov(deltaM,deltaY) under null 	*/
	{ dcov1, xcov1 } = ndens(mcout[.,7],250,nrep) ;					/* cov(deltaM,deltaY) under alt		*/

	if econ == 1 ;
		aumf3 = xcov0~dcov0~dcov1 ;
	elseif econ == 2 ;
		cnmf3 = xcov0~dcov0~dcov1 ;
	elseif econ == 3 ;
		ukmf3 = xcov0~dcov0~dcov1 ;
	elseif econ == 4 ;
		usmf3 = xcov0~dcov0~dcov1 ;
	endif ;
		
econ = econ + 1 ;
endo ;		

graphset ;
fonts("simplex complex microb simgrma") ;
_ptitlht = 0.3 ;
_pagesize = 7~5 ;
begwind ;
window(2,2,0) ;
setwind(1) ;
	title("Australia") ;
    xy(aumf3[.,1],aumf3[.,2:3]) ;
nextwind ;
	title("Canada") ;
    xy(cnmf3[.,1],cnmf3[.,2:3]) ;
nextwind ;
	title("United Kingdom") ;
    xy(ukmf3[.,1],ukmf3[.,2:3]) ;
nextwind ;
    _plegctl = 1~10 ;
    _plegstr = "NULL\000ALT" ;
	title("United States") ;
    xy(usmf3[.,1],usmf3[.,2:3]) ;
endwind ;

end ;
