new ;
#lineson ;
library pgraph ;
graphset ;

/* Gauss program to produce figure 1-4 for Coe & Nason "Long-run Neutrality..."
   These figures are (OLS) long-run derivatives with asymptotic & empirical 95%
   confidence bands. Fig 1 is Australia, fig 2 is Canada, fig 3 is UK & fig 4 is US.	*/

/* Requires: ascii data files ??.mat where ?? = au, cn, uk, us.
		 	 ascii files with empirical 95% critical values ecv95??#.mat where # = b or m.
		 	 sub-routine to calcluate F&S (1993) long-run derivative = fslrd.g			*/
		 	 
/* SET VALUE FOR ECON ON NEXT LINE */		 	 

econ = 4 ;		/* set economy 1 = Australia, 2 = Canada, 3 = UK, 4= US	*/

if econ == 1 ;
  	np = 94 ;
	load audat[np,3] = au.mat ;
   	b = audat[.,1] ;
   	m = audat[.,2] ;
	y = audat[.,3] ;
elseif econ == 2 ;
	np = 123 ;
    load cndat[np,3] = cn.mat ;
   	b = cndat[.,1] ;
   	m = cndat[.,2] ;
    y = cndat[.,3] ;
elseif econ == 3 ;
	np = 123 ;
    load ukdat[np,3] = uk.mat ;
   	b = ukdat[.,1] ;
   	m = ukdat[.,2] ;
    y = ukdat[.,3] ;
elseif econ == 4 ;
	np = 129 ;
    load usdat[np,3] = us.mat ;
   	b = usdat[.,1] ;
   	m = usdat[.,2] ;
    y = usdat[.,3] ;
endif ;

/* Load Empirical Critical Values */

if econ == 1 ;
	load xm[30,2] = ecv95aub.mat ;
	load xb[30,2] = ecv95aum.mat ;
elseif econ == 2 ;
	load xm[30,2] = ecv95cnb.mat ;
	load xb[30,2] = ecv95cnm.mat ;
elseif econ == 3 ;
	load xm[30,2] = ecv95ukb.mat ;
	load xb[30,2] = ecv95ukm.mat ;
elseif econ == 4 ;
	load xm[30,2] = ecv95usb.mat ;
	load xb[30,2] = ecv95usm.mat ;
endif ;

ecvm = xm[.,1] ;
ecvb = xb[.,1] ;

/* Create k sequence */

kk = seqa(1,1,30) ;

/* Calculate beta_ols & standard errors */

{ smlrdols } = fslrd(y,m,0) ;

betam = smlrdols[.,1] ;
stderrm = smlrdols[.,2] ;

{ smlrdols } = fslrd(y,b,0) ;

betab = smlrdols[.,1] ;
stderrb = smlrdols[.,2] ;

/* Obtain asymptotic & empirical confidence bands */

x1m = zeros(30,3) ;		/* Store asymptotic confidence bands here 	*/
x2m = zeros(30,3) ;		/* Store empirical confidence bands here	*/
x1b = zeros(30,3) ;		/* Store asymptotic confidence bands here 	*/
x2b = zeros(30,3) ;		/* Store empirical confidence bands here	*/

k = 1 ;
do while k <= 30 ;

    if np/k < 3 ;    cv =  4.303 ;		elseif np/k < 4 ;    cv =  3.182 ;		elseif np/k < 5 ;    cv =  2.776 ;
elseif np/k < 6 ;    cv =  2.571 ;		elseif np/k < 7 ;    cv =  2.447 ;		elseif np/k < 8 ;    cv =  2.365 ;
elseif np/k < 9 ;    cv =  2.306 ;		elseif np/k < 10 ;   cv =  2.262 ;		elseif np/k < 11 ;   cv =  2.228 ;
elseif np/k < 12 ;   cv =  2.201 ;		elseif np/k < 13 ;   cv =  2.179 ;		elseif np/k < 14 ;   cv =  2.160 ;
elseif np/k < 15 ;   cv =  2.145 ;		elseif np/k < 16 ;   cv =  2.131 ;		elseif np/k < 17 ;   cv =  2.120 ;
elseif np/k < 18 ;   cv =  2.110 ;		elseif np/k < 19 ;   cv =  2.101 ;		elseif np/k < 20 ;   cv =  2.093 ;
elseif np/k < 21 ;   cv =  2.086 ;		elseif np/k < 22 ;   cv =  2.080 ;		elseif np/k < 23 ;   cv =  2.074 ;
elseif np/k < 24 ;   cv =  2.069 ;		elseif np/k < 25 ;   cv =  2.064 ;		elseif np/k < 26 ;   cv =  2.060 ;
elseif np/k < 27 ;   cv =  2.056 ;		elseif np/k < 28 ;   cv =  2.052 ;		elseif np/k < 29 ;   cv =  2.048 ;
elseif np/k < 30 ;   cv =  2.045 ;		elseif np/k < 35 ;   cv =  2.042 ;		elseif np/k < 40 ;   cv =  2.030 ;
elseif np/k < 45 ;   cv =  2.021 ;		elseif np/k < 50 ;   cv =  2.014 ;		elseif np/k < 60 ;   cv =  2.009 ;
elseif np/k < 70 ;   cv =  2.000 ;		elseif np/k < 80 ;   cv =  1.994 ;		elseif np/k < 90 ;   cv =  1.990 ;
elseif np/k < 100 ;  cv =  1.987 ;		elseif np/k >= 100 ; cv =  1.984 ;
endif ;

x1m[k,1] = betam[k] ;
x1m[k,2] = betam[k] - stderrm[k]*cv ;
x1m[k,3] = betam[k] + stderrm[k]*cv ;

x2m[k,1] = betam[k] ;
x2m[k,2] = betam[k] - stderrm[k]*ecvm[k] ;
x2m[k,3] = betam[k] + stderrm[k]*ecvm[k] ;

x1b[k,1] = betab[k] ;
x1b[k,2] = betab[k] - stderrb[k]*cv ;
x1b[k,3] = betab[k] + stderrb[k]*cv ;

x2b[k,1] = betab[k] ;
x2b[k,2] = betab[k] - stderrb[k]*ecvb[k] ;
x2b[k,3] = betab[k] + stderrb[k]*ecvb[k] ;

k = k + 1 ;
endo ;


graphset ;
fonts("simplex complex microb simgrma") ;
_pdate = 0 ;
_pbox = 0 ;
_ptitlht = 0.225;
_paxht = 0.225 ;
_pnumht = 0.225 ;
_pcolor = 15 ;
_pline = { 1 6 0 0 30 0 1 15 0 } ;
_pltype = {6, 3, 3 } ;
_protate = 0 ;
xlabel("k") ;
ylabel("\204b\201]k,OLS[") ;
xtics(0,30,2,2) ;

if econ == 1 ;
	ytics(-1,1,0.5,0.5) ;
elseif econ == 3 ;
	ytics(-0.5,0.5,0.25,0.25) ;
else ;
	ytics(-1.5,1.5,0.5,0.5) ;
endif ;

begwind ;
window(2,2,0) ;
setwind(1) ;
	title("Stock: Asymptotic Confidence Bands") ;
	xy(k,x1m) ;
nextwind ;
	title("Base: Asymptotic Confidence Bands") ;
	xy(k,x1b) ;
nextwind ;
	title("Stock: Empirical Confidence Bands") ;
	xy(k,x2m) ;
nextwind ;
	title("Base: Empirical Confidence Bands") ;
	xy(k,x2b) ;
endwind ;

end ;

