proc(2) = ndens(xv,npts,nobs) ;

    local j, alph, ad1, densn, xvt, k, x, a, b, n, r1, r2 ;
    local range, inc, xpts, x1, stdx, ann, q1, q2, r, h, i ;
    local xbar, wn, dens ;

@ ----- Compute the Normal Kernal ----- @

   alph = 0.5 ;
   dens = zeros(npts+1,1) ;
      b = zeros(2,1) ;
      n = nobs ;
    ad1 = sqrt( 1/(2*pi) ) ;

@ ----- Compute Adaptive Estimate of Spread ----- @
@ -----   as in Silverman, p.47, eq. 3.30   ----- @

     r1 = minc( xv ) ;  r2 = maxc( xv ) ;
  range = r2 - r1 ;    inc = range/npts ;

@     r1~r2~inc ;@

   xpts = seqa(r1,inc,npts+1) ;
     x1 = sortc(xv,1) ;
   stdx = stdc( xv ) ; ann = n^(-0.2) ;

     q1 = int( n/4 ) ;  q2 = int( 3*n/4 ) ;
      r = x1[q2,.] - x1[q1,.] ;
 b[1,1] = stdx ;   b[2,1] = r/1.34 ;
      a = minc( b ) ;

@ -----   Compute Automatic Bandwidth   ----- @
@ ----- as in Silverman, p.48, eq. 3.31 ----- @

      h = 0.9*a*ann ;
      j = 1 ;
      do until j > npts + 1 ;
         xbar = xpts[j,.] ;
         wn = weightn(xv,xbar,h,ad1) ;
         dens[j,.] = (1/(n*h))*sumc( wn ) ;
         j = j + 1 ;
      endo;

@     dens = missrv(dens,0) ;
      dens = delif(dens,dens[.,1].==0) ;
      if rows(dens) < 500 ;
         densn[.,1] = dens|zeros(npts - rows(dens),1) ;
      else ;
         densn[.,1] = dens ;
      endif ;@

  retp( dens,xpts ) ;

  endp ;
