/* bartpw.g computes a Spectral Density Matrix as Newey and West discuss (EMET 1987 and REStud 1994).   */
/* same as bartwin.g but with prewhitening as outlined by Andrews and Monahan (EMET 1992).              */  

proc bartpw(zez,nobs,mflag) ;
local rz, cz, obs, yyy, xxx, bh, rh, ch, qbq, qsq, qcq, sqs, bhadj, eee, meem, m, specv, j, wij, htj, hjt, omgj, bd, specvrc ;

/* Prewhiten residuals x instruments = zez. Only Correct with a VAR(1) w/no intercept.  */
/* Use Singular Value Decomposition to adjust bh for eigenvalues close to unity.        */

rz = rows(zez) ;
cz = cols(zez) ;
obs = rz - 1 ;
yyy = zez[2:rz,.] ;
xxx = zez[1:rz-1,.] ;
bh = solpd(xxx'yyy, xxx'xxx) ;

rh = rows(bh) ;
ch = cols(bh) ;
{qbq, qsq, qcq} = svd1(bh') ;
sqs = substute(qsq,(qsq .>  0.97),  0.97) ;
sqs = substute(qsq,(qsq .< -0.97), -0.97) ;
bhadj = qbq*sqs*qcq' ;
eee = yyy - xxx*bhadj' ;
meem = eee'eee ;

/* Optimal Lag Length of the Newey-West Correction */

if mflag == 0 ;
    m = 0 ;
else ;
    m = round( 4*( (nobs/100)^(2/9) ) ) ;
endif ;

/*Compute Newey-West Correction */

if mflag == 0 ;
    specv = meem ;
else ;
    specv = meem ;
    j = 1 ;
    do until j > m ;
        wij = 1.0 - (j/(m + 1.0)) ;
        htj = eee[1:obs-j,.] ;
        hjt = eee[j+1:obs,.] ;
        omgj = htj'hjt ;
        specv = specv + wij*(omgj + omgj') ;
    j = j + 1 ;
    endo ;
endif ;

/* Recolor Spectral Density Matrix */

bd = inv( eye(cz) - bhadj ) ;
specvrc = bd*specv*bd' ;

retp(specvrc) ;
endp ;

