@
******************************************************************************
This proc estimates the just-identified SVAR under the following restrictions:
diag cov matrix & long-run monetary exogeneity or price stability.
Estimated by IV - see Hamilton p238-239 & appendix to King & Watson (1997).
******************************************************************************
@
proc(4) = svarivj(dms,dyr) ;
local y, z, x, xh, bm, um, vm, by, uy, vy ;

/* Money Equation */

 y = dms[2:rows(dms)] - theta*dyr[2:rows(dyr)] ;                        /* dependent variable   */
 z = ones(rows(y),1)~dyr[1:rows(dyr)-1]~dms[1:rows(dms)-1] ;            /* instruments          */
 x = ones(rows(y),1)~(dms[1:rows(dms)-1] - theta*dyr[2:rows(dyr)])
    ~(dyr[2:rows(dyr)]-dyr[1:rows(dyr)-1]) ;                            /* indep variables      */
xh = z*inv(z'z)*z'x ;                                                   /*  x-hat                   */
bm = inv(xh'x)*xh'y ;                                                   /* 2SLS estimates       */
um = y-x*bm ;                                                           /* residuals                */
vm = um'um/rows(x) ;                                                    /* residual variance    */

/* Output Equation */

 y = dyr[2:rows(dyr)] ;                                                 /* dependent variable   */
 z = ones(rows(y),1)~dyr[1:rows(dyr)-1]~dms[1:rows(dms)-1]~um ;         /* instruments          */
 x = ones(rows(y),1)~dyr[1:rows(dyr)-1]
    ~dms[2:rows(dms)]~dms[1:rows(dms)-1] ;                              /* indep variables      */
xh = z*inv(z'z)*z'x ;                                                   /*  x-hat                   */
by = inv(xh'x)*xh'y ;                                                   /* 2SLS estimates       */
uy = y-x*by ;                                                           /* residuals                */
vy = uy'uy/rows(x) ;                                                    /* residual variance    */

@ --- End Procedure --- @

retp(1~-((1-bm[2])*theta+bm[3])|-by[3]~1, bm[1]|by[1], bm[2]~-bm[3]|by[4]~by[2],vm~0|0~vy) ;

endp ;