/*  Gauss procedure to calculate long-run derivatives using methodology of Fisher & Seater AER 83(3) */
/*  This version removes bias (uner the null) associated with LRPS.                                  */
/*  Inputs are as follows:  y = natural log of lhs variable, x = natural log of rhs variable.        */
/*                          kk = horizons, pw = 1 if pre-whiten the HAC estimator.                   */
/*  Need the following procs: bartwin.g, bartpw.g.                                                   */

proc(1) = fslrdps(y,x,pw,psbias) ;
local nobs, lrd, k, fh, dp, ip, b, e, sss, cov, se ;

nobs = rows(y) ;
 lrd = zeros(rows(kk),4) ;

/* Estimation of betaols(k) for various horizons */

k = 1 ;
do while k <= rows(kk) ;

    fh = kk[k] ;                            /* forecast horizon                         */
    dp = y[fh+1:nobs] - y[1:nobs-fh] ;      /* long change in y ( dependent variable)   */
    ip = x[fh+1:nobs] - x[1:nobs-fh] ;      /* long change in x ( independent variable) */
    ip = ones(rows(dp),1)~ip ;              /* add an intercept                         */
    b = inv(moment(ip,0))*ip'dp ;           /* OLS estimate                             */
    e = dp - ip*b ;                         /* OLS residuals                            */

    if pw == 0 ;                            /* no pre-whitening in HAC estimator        */
        sss = bartwin(e.*ip,,rows(e),1) ;
    elseif pw == 1 ;                        /* pre-whiten HAC estimator                 */
        sss = bartpw(e.*ip,rows(e),1) ;
    endif ;

    cov = inv(ip'ip)*sss*inv(ip'ip) ;       /* Covariance Matrix by Newey-West (1987) Procedure */
    se = sqrt(diag(cov)) ;                  /* Standard Errors      */

    /* Store results in matrix */

    lrd[k,1] = b[2] - psbias;
    lrd[k,2] = se[2] ;
    lrd[k,3] = lrd[k,1]/se[2] ;                     /* t-stat on betaols    */
    lrd[k,4] = 2*cdftc(abs(lrd[k,3]),nobs/k) ;   /* p-value for betaols  */

k = k + 1;
endo ;

/* End procedure */

retp(lrd) ;
endp ;

