/*  bartwin.g computes the optimal weighting matrix using the Newey & West correction (EMET 1987).  */
/*  They use a Bartlett kernal spectral density estimator. m is the Optimal Bandwidth of the        */
/*  Bartlett kernal. It is chosen with an automatic bandwidth criterion. mlag = 0 and the only      */
/*  correction is for hetroskedasticity.                                                            */

proc bartwin(xx,obs,mflag) ;
local mxxm, specv, m, j, wij, htj, hjt, omgj ;

mxxm = xx'xx ;

/* Optimal Lag Length of the Newey-West Correction */

if mflag == 0 ;
    specv = mxxm ;
else ;
    m = round( 4*( (obs/100)^(2/9) ) ) ;

    /* Compute Newey-West Correction */

    j = 1 ;
        specv = mxxm ;
    do until j > m ;
        wij = 1.0 - (j/(m + 1.0)) ; 
        htj = xx[1:obs-j,.] ;
        hjt = xx[j+1:obs,.] ;
        omgj = htj'*hjt ;
        specv = specv + wij*(omgj + omgj') ;
    j = j + 1 ;
    clear wij, htj, hjt, omgj ;
    endo ;

endif ;

retp(specv) ;
endp ;
