@Gauss program to generate results reported in tables 7 and 8 of
Forecasting Encompassing Tests and Probability Forecasts
by M P Clements and D I Harvey@

new;

library cml;
cmlset;
__output = 0;	
_cml_CovPar = 0;
_cml_Algorithm = 3;	@3 = Newton Raphson@;
ncov=0;

#lineson;

format 8,3;
lps_const = 0; @=1 then include a constant in the linear combination for LPS testing@

@Data are 1960:1-1999:4 for: NBER recession indicator, Spread, N3Doil. See paper for more details.
Each column contains the observations on one variable@
let data[160,3]  = 
   0.000    0.540     0.000 
    1.00     1.17     0.000 
    1.00     1.44     0.000 
    1.00     1.52     0.000 
    1.00     1.41     0.000 
   0.000     1.46     0.000 
   0.000     1.66     0.000 
   0.000     1.50     0.000 
   0.000     1.27     0.000 
   0.000     1.15     0.000 
   0.000     1.13     0.000 
   0.000     1.10     0.000 
   0.000    0.983     0.000 
   0.000     1.02     0.000 
   0.000    0.753     0.000 
   0.000    0.623     0.000 
   0.000    0.643     0.000 
   0.000    0.720     0.000 
   0.000    0.687     0.000 
   0.000    0.487     0.000 
   0.000    0.303     0.000 
   0.000    0.327     0.000 
   0.000    0.387     0.000 
   0.000    0.317     0.000 
   0.000    0.137     0.000 
   0.000    0.183     0.100 
   0.000   0.0900     0.300 
   0.000   -0.243     0.400 
   0.000   0.0467     0.200 
   0.000     1.16     0.000 
   0.000    0.903     0.700 
   0.000    0.857     0.000 
   0.000    0.543     0.000 
   0.000    0.230     0.300 
   0.000    0.237     0.400 
   0.000    0.187     0.000 
   0.000   0.0367      3.98 
   0.000    0.110     0.760 
   0.000   -0.193     0.000 
   0.000  -0.0233     0.000 
    1.00    0.103     0.000 
    1.00    0.963     0.000 
    1.00     1.09     0.000 
    1.00     1.49      6.57 
   0.000     2.15      1.05 
   0.000     2.04     0.170 
   0.000     1.43    0.0900 
   0.000     1.66     0.000 
   0.000     2.60     0.000 
   0.000     2.40     0.000 
   0.000     2.05     0.000 
   0.000     1.52     0.000 
   0.000    0.963     0.170 
   0.000    0.197      8.66 
   0.000    -1.18      6.19 
   0.000   -0.713      9.24 
    1.00   -0.550      32.4 
    1.00   -0.727     0.000 
    1.00   -0.327      11.0 
    1.00    0.333     0.000 
    1.00     1.66      2.25 
   0.000     2.65      10.6 
   0.000     1.96     0.000 
   0.000     2.38      2.55 
   0.000     2.80     0.000 
   0.000     2.60     0.000 
   0.000     2.56     0.000 
   0.000     2.49     0.830 
   0.000     2.73      1.92 
   0.000     2.54     0.810 
   0.000     1.89      1.34 
   0.000     1.46      4.42 
   0.000     1.60      1.77 
   0.000     1.84      1.98 
   0.000     1.17      2.18 
   0.000    0.140      2.14 
   0.000   -0.253      3.69 
   0.000   -0.260      9.49 
   0.000   -0.530      17.0 
   0.000    -1.36      10.9 
    1.00    -1.48      10.5 
    1.00    0.427      4.93 
   0.000     1.72      3.93 
   0.000    -1.29      10.2 
   0.000    -1.41      28.6 
   0.000    -1.08     0.000 
    1.00   -0.240     0.000 
    1.00     2.06     0.000 
    1.00     1.40     0.000 
    1.00     1.57     0.000 
    1.00     3.41     0.000 
    1.00     2.73     0.000 
   0.000     2.48     0.000 
   0.000     2.12     0.000 
   0.000     2.44     0.000 
   0.000     2.89     0.000 
   0.000     3.53     0.000 
   0.000     3.36     0.000 
   0.000     2.52     0.000 
   0.000     2.77     0.000 
   0.000     3.42     0.000 
   0.000     3.29     0.000 
   0.000     3.23     0.000 
   0.000     2.61     0.000 
   0.000     1.67     0.000 
   0.000     1.47     0.000 
   0.000     1.77     0.000 
   0.000     1.92     0.000 
   0.000     1.66     0.000 
   0.000     2.61     0.000 
   0.000     2.84     0.000 
   0.000     3.12     0.000 
   0.000     2.66     0.000 
   0.000     2.68     0.000 
   0.000     2.11     0.000 
   0.000     1.25     0.000 
   0.000    0.673     0.000 
   0.000    0.333     0.860 
   0.000    0.257     0.000 
   0.000    0.267      2.54 
   0.000    0.667     0.330 
   0.000    0.910     0.000 
    1.00     1.21      41.6 
    1.00     1.37     0.000 
    1.00     1.96     0.000 
   0.000     2.54     0.000 
   0.000     2.53     0.000 
   0.000     2.76     0.000 
   0.000     3.39     0.000 
   0.000     3.65     0.000 
   0.000     3.49     0.000 
   0.000     3.67     0.000 
   0.000     3.29     0.000 
   0.000     3.01     0.000 
   0.000     2.60     0.000 
   0.000     2.53     0.000 
   0.000     2.82     0.000 
   0.000     3.05     0.000 
   0.000     2.82     0.000 
   0.000     2.55     0.000 
   0.000     1.70     0.000 
   0.000    0.997     0.000 
   0.000    0.943     0.000 
   0.000    0.623     0.000 
   0.000    0.960     0.000 
   0.000     1.68     0.000 
   0.000     1.64      15.2 
   0.000     1.37      5.36 
   0.000     1.50     0.000 
   0.000     1.62     0.000 
   0.000     1.19     0.000 
   0.000    0.820     0.000 
   0.000    0.510     0.000 
   0.000    0.590     0.000 
   0.000    0.323     0.000 
   0.000    0.357     0.000 
   0.000    0.560     0.000 
   0.000     1.08     0.000 
   0.000     1.19     0.000 
   0.000     1.08      1.40; 


@Estimate models to 1979:4. (T=80) Forecast 80:1 to 99:4@
@T=120@; T=80;
"Spread _{3}";	
y=data[4:T,1];  c= ones(rows(y),1); x =c~data[1:T-3,2];
nsl = cols(x) - 1; 
{ bL,LLu }  = logit(y,x);
logPred = exp(x*bL)./(1+exp(x*bL));

x = ones(rows(y),1);
{ bLr,LLr }  = logit(y,x);
{p2r,pvpr2} = PRsq(llu,llr,nsl,rows(x));	@Returns pseudo R^2 and p-value of slope zero@
"pseudo R^2 and p-value of slope zero";;p2r;;pvpr2;
{QPS,LPS} = QPSLPS(y,logPred);
"QPS and LPS ";
QPS;LPS;
xf = ones(160-T,1)~data[T-2:157,2];
fdata1 = data[T+1:160,1]~(exp(xf*bL)./(1+exp(xf*bL))); 


"N3OPI _{2}";
y=data[3:T,1]; c= ones(rows(y),1);  x = c~data[1:T-2,3];	  
nsl = cols(x) - 1; 
{ bL,LLu }  = logit(y,x);
logPred = exp(x*bL)./(1+exp(x*bL));

x = ones(rows(y),1);
{ bLr,LLr }  = logit(y,x);
{p2r,pvpr2} = PRsq(llu,llr,nsl,rows(x));	@Returns pseudo R^2 and p-value of slope zero@
"pseudo R^2 and p-value of slope zero";;p2r;;pvpr2;
{QPS,LPS} = QPSLPS(y,logPred);
"QPS and LPS ";
QPS;LPS;
xf = ones(160-T,1)~data[T-1:158,3];

fdata1 = fdata1~(exp(xf*bL)./(1+exp(xf*bL)));

{DMa,MDMa,retcode} = fe1(fdata1[.,1],fdata1[.,2],fdata1[.,3],ncov);
 DMb               = fe2(fdata1[.,1],fdata1[.,2],fdata1[.,3]);
{DMc,MDMc}         = fe3(fdata1[.,1],fdata1[.,2],fdata1[.,3],ncov);
  n = rows(fdata1);
  DMa = CDFTC(DMa,n-1); DMb = CDFTC(DMb,n-1); DMc = CDFTC(DMc,n-1);
  "DM tests based on FE1, FE2 and FE3";
  DMa;DMb;DMc;

{DMa,MDMa,retcode} = fe1(fdata1[.,1],fdata1[.,3],fdata1[.,2],ncov);
 DMb               = fe2(fdata1[.,1],fdata1[.,3],fdata1[.,2]);
{DMc,MDMc}         = fe3(fdata1[.,1],fdata1[.,3],fdata1[.,2],ncov);
  DMa = CDFTC(DMa,n-1); DMb = CDFTC(DMb,n-1); DMc = CDFTC(DMc,n-1);
  "DM tests based on FE1, FE2 and FE3";
  DMa;DMb;DMc;



"**** LPS tests ****";

            ncov = floor(4*((n/100)^(2/9)));
			y = fdata1[.,1]; f1 = fdata1[.,2]; f2 = fdata1[.,3]; @Ho: yield FEs oil@;  		
		/*	y = fdata1[.,1]; f1 = fdata1[.,3]; f2 = fdata1[.,2]; @Ho: oil   FEs yield@;	*/

			e1 = y-f1;
            e2 = y-f2;
			c= ones(n,1);
			rows(c);;rows(f1);;rows(f2);
			x = c~f1~f2;
            bstart = y/x;
            _cml_CovPar = 0;
            _cml_A = { . };
            _cml_B = { . };
            _cml_GradProc = &gradproc;
	        _cml_HessProc = &hessproc;
	        {bhat,func,g,cov,retcode} = cml(y~c~f1~f2,0,&mLPS,bstart);

            g = gradproc(bhat,y~c~f1~f2);
            H = hessproc(bhat,y~c~f1~f2);
            covH = inv(-H);   
            p1 = zeros(ncov,1);
            p2 = zeros(ncov,1);
            p3 = zeros(ncov,1);
            p4 = zeros(ncov,1);
            p5 = zeros(ncov,1);
            p6 = zeros(ncov,1);
            ii = 1;
            do while ii <= ncov;
                p1[ii] = (1-(ii/(1+ncov)))*2*sumc(g[1:n-ii,1].*g[ii+1:n,1]);
                p2[ii] = (1-(ii/(1+ncov)))*(sumc(g[1:n-ii,1].*g[ii+1:n,2])+sumc(g[1:n-ii,2].*g[ii+1:n,1]));
                p3[ii] = (1-(ii/(1+ncov)))*(sumc(g[1:n-ii,1].*g[ii+1:n,3])+sumc(g[1:n-ii,3].*g[ii+1:n,1]));
                p4[ii] = (1-(ii/(1+ncov)))*2*sumc(g[1:n-ii,2].*g[ii+1:n,2]);
                p5[ii] = (1-(ii/(1+ncov)))*(sumc(g[1:n-ii,2].*g[ii+1:n,3])+sumc(g[1:n-ii,3].*g[ii+1:n,2]));
                p6[ii] = (1-(ii/(1+ncov)))*2*sumc(g[1:n-ii,3].*g[ii+1:n,3]);
            ii = ii + 1;
            endo;
            gam = (g'g) + ((sumc(p1)~sumc(p2)~sumc(p3))|(sumc(p2)~sumc(p4)~sumc(p5))|(sumc(p3)~sumc(p5)~sumc(p6)));
            covhac = covH*gam*covH;
            fe1_W = bhat[3]/SQRT(covhac[3,3]);

            x = c~(e1-e2);
            b = e1/x;
            bstart = b[1]|b[2];
            _cml_CovPar = 0;
            _cml_A = { . };
            _cml_B = { . };
            _cml_GradProc = &gradproc2;
	        _cml_HessProc = &hessproc2;
	        {bhat,func,g,cov,retcode} = cml(y~c~f1~f2,0,&mLPS2,bstart);
            g = gradproc2(bhat,y~c~f1~f2);
            H = hessproc2(bhat,y~c~f1~f2);
            covH = inv(-H);
            p1 = zeros(ncov,1);
            p2 = zeros(ncov,1);
            p3 = zeros(ncov,1);
            ii = 1;
            do while ii <= ncov;
                p1[ii] = (1-(ii/(1+ncov)))*2*sumc(g[1:n-ii,1].*g[ii+1:n,1]);
                p2[ii] = (1-(ii/(1+ncov)))*(sumc(g[1:n-ii,1].*g[ii+1:n,2])+sumc(g[1:n-ii,2].*g[ii+1:n,1]));
                p3[ii] = (1-(ii/(1+ncov)))*2*sumc(g[1:n-ii,2].*g[ii+1:n,2]);
            ii = ii + 1;
            endo;
            gam = (g'g) + ((sumc(p1)~sumc(p2))|(sumc(p2)~sumc(p3)));
            covhac = covH*gam*covH;
            fe2_W = bhat[2]/SQRT(covhac[2,2]);

            x = c~f2;
            bstart = e1/x;
            _cml_CovPar = 0;
            _cml_A = { . };
            _cml_B = { . };
            _cml_GradProc = &gradproc3;
            _cml_HessProc = &hessproc3;
	        {bhat,func,g,cov,retcode} = cml(y~c~f1~f2,0,&mLPS3,bstart);
	        g = gradproc3(bhat,y~c~f1~f2);
            H = hessproc3(bhat,y~c~f1~f2);
            covH = inv(-H);
            p1 = zeros(ncov,1);
            p2 = zeros(ncov,1);
            p3 = zeros(ncov,1);
            ii = 1;
            do while ii <= ncov;
                p1[ii] = (1-(ii/(1+ncov)))*2*sumc(g[1:n-ii,1].*g[ii+1:n,1]);
                p2[ii] = (1-(ii/(1+ncov)))*(sumc(g[1:n-ii,1].*g[ii+1:n,2])+sumc(g[1:n-ii,2].*g[ii+1:n,1]));
                p3[ii] = (1-(ii/(1+ncov)))*2*sumc(g[1:n-ii,2].*g[ii+1:n,2]);
            ii = ii + 1;
            endo;
            gam = (g'g) + ((sumc(p1)~sumc(p2))|(sumc(p2)~sumc(p3)));
            covhac = covH*gam*covH;
            fe3_W = bhat[2]/SQRT(covhac[2,2]);

	  "n";;n;
"W1 ";;fe1_W;;" ";cdftc(fe1_W,n-3);	  
"W2 ";;fe2_W;;" ";cdftc(fe2_W,n-2);
"W3 ";;fe3_W;;" ";cdftc(fe3_W,n-2);


"***End LPS tests****";  

proc(2) = logit(y,x);
	local start,bhat,likeval,gradient,retcode;
	start = y/x;
	{bhat,likeval,gradient,retcode} = QNewton(&NegLogit,start);
	retp(bhat,likeval);
endp;

proc NegLogit(beta);
	local likvalue;
	likvalue = sumc((y.*(x*beta))-ln(1+exp(x*beta)));
	retp(-likvalue);
endp;

proc(2) = QPSLPS(D,P); @Regime indicator, estimated probs.@ 
local QPS,LPS;
QPS = 2*meanc( (P-D)^2 );
LPS = - meanc(	(1-D).*(ln(1-P)) + D.*ln(P) );
retp(QPS,LPS);
endp;


proc(2) = PRsq(u,r,sl,T);
@Calculates Camacho and Perez-Quiros pseudo R^2 and chi-sq test of slopes@
@sl = #slopes, Tobs = #obs@

local LLu,LLc,PR2;
LLu = -u;
LLc = -r;
PR2 = 1 - (LLu/LLc)^((-2/T)*LLc);
retp(PR2,cdfchic(-2*(LLc-LLu),sl));			   @PR2, p-value of insig. of slope(s)@
endp;
 
@******************************************************QPS procedures********************************************@
proc (3) = fe1(y,f1,f2,ncov);
    local n,c,x,b1,eta1,b2,eta2,d,stat1,stat2;
    n = rows(y);
    c = ones(n,1);
    x = c~f1;
    b1 = y/x;
    eta1 = y-x*b1;
    b2 = f2/x;
    eta2 = f2-x*b2;
    d = eta1.*eta2;
    if ismiss(d);
        stat1 = 0;
        stat2 = 0;
        retcode = 1;
    else;
        stat1 = MDM(d,0);
        stat2 = MDM(d,ncov);
        retcode = 0;
    endif;
retp(stat1,stat2,retcode);
endp;

proc fe2(y,f1,f2);
    local n,e1,e2,d,stat;
    e1 = y-f1;
    e2 = y-f2;
    d = (e1-meanc(e1)).*((e1-meanc(e1))-(e2-meanc(e2)));
    stat = MDM(d,0);
retp(stat);
endp;

proc (2) = fe3(y,f1,f2,ncov);
    local n,e1,d,stat1,stat2;
    e1 = y-f1;
    d = (e1-meanc(e1)).*(f2-meanc(f2));
    stat1 = MDM(d,0);
    stat2 = MDM(d,ncov);
retp(stat1,stat2);
endp;

proc MDM(d,ncov);

    local n,gam0,gam,j,S,h,Sm,stat;
    n = rows(d);
    gam0 = (d-meanc(d))'(d-meanc(d))/n;
    if ncov > 0;
        gam = zeros(ncov,1);
        j = 1;
        do while j <= ncov;
            gam[j] = (d[j+1:n]-meanc(d))'(d[1:n-j]-meanc(d))/n;
        j = j + 1;
        endo;
    else;
        gam = 0;
    endif;
    S = gam0+(2*sumc(gam));
    h = ncov+1;
    Sm = (n/(n+1-(2*h)+((h/n)*(h-1))))*S;
    stat = meanc(d)/sqrt(Sm/n);
retp(stat);
endp;

@******************************************************LPS procedures********************************************@

proc mLPS(beta,dat);

	local y,x;
	y = dat[.,1];
	x = dat[.,2:cols(dat)];
	retp(sumc((y.*ln(x*beta))+((1-y).*ln(1-(x*beta)))));

endp;


proc mLPS2(beta,dat);

	local y,f1,f2;
	y = dat[.,1];
    f1 = dat[.,3];
    f2 = dat[.,4];
	retp(sumc((y.*ln(beta[1]+f1+(beta[2]*(f2-f1))))+((1-y).*ln(1-(beta[1]+f1+(beta[2]*(f2-f1)))))));

endp;

proc mLPS3(beta,dat);

	local y,x,f1;
	y = dat[.,1];
    f1 = dat[.,3];
	x = dat[.,2]~dat[.,4];
	retp(sumc((y.*ln((x*beta)+f1))+((1-y).*ln(1-((x*beta)+f1)))));
  
endp;

proc gradproc(beta,dat);

	local y,f1,f2,fc,g1,g2,g3;
	y = dat[.,1];
	f1 = dat[.,3];
	f2 = dat[.,4];
	fc = beta[1]+(beta[2]*f1)+(beta[3]*f2);
	g1 = (y./fc)-((1-y)./(1-fc));
	g2 = ((y./fc)-((1-y)./(1-fc))).*f1;
	g3 = ((y./fc)-((1-y)./(1-fc))).*f2;
	retp(g1~g2~g3);

endp;

proc hessproc(beta,dat);

	local y,f1,f2,fc,h11,h12,h13,h22,h23,h33,H;
	y = dat[.,1];
	f1 = dat[.,3];
	f2 = dat[.,4];
    fc = beta[1]+(beta[2]*f1)+(beta[3]*f2);
	h11 = -sumc((y./(fc.^2))+((1-y)./((1-fc).^2)));
	h12 = -sumc(((y./(fc.^2))+((1-y)./((1-fc).^2))).*f1);
	h13 = -sumc(((y./(fc.^2))+((1-y)./((1-fc).^2))).*f2);
	h22 = -sumc(((y./(fc.^2))+((1-y)./((1-fc).^2))).*(f1.^2));
	h23 = -sumc(((y./(fc.^2))+((1-y)./((1-fc).^2))).*f1.*f2);
	h33 = -sumc(((y./(fc.^2))+((1-y)./((1-fc).^2))).*(f2.^2));
	H = (h11~h12~h13)|(h12~h22~h23)|(h13~h23~h33);
	retp(H);

endp;

proc gradproc2(beta,dat);

	local y,f1,f2,fc,g1,g2;
	y = dat[.,1];
	f1 = dat[.,3];
	f2 = dat[.,4];
	fc = beta[1]+f1+(beta[2]*(f2-f1));
	g1 = (y./fc)-((1-y)./(1-fc));
	g2 = ((y./fc)-((1-y)./(1-fc))).*(f2-f1);
	retp(g1~g2);

endp;

proc hessproc2(beta,dat);

	local y,f1,f2,fc,h11,h12,h22,H;
	y = dat[.,1];
	f1 = dat[.,3];
	f2 = dat[.,4];
    fc = beta[1]+f1+(beta[2]*(f2-f1));
	h11 = -sumc((y./(fc.^2))+((1-y)./((1-fc).^2)));
	h12 = -sumc(((y./(fc.^2))+((1-y)./((1-fc).^2))).*(f2-f1));
	h22 = -sumc(((y./(fc.^2))+((1-y)./((1-fc).^2))).*((f2-f1).^2));
	H = (h11~h12)|(h12~h22);
	retp(H);

endp;

proc gradproc3(beta,dat);

	local y,f1,f2,fc,g1,g2;
	y = dat[.,1];
	f1 = dat[.,3];
	f2 = dat[.,4];
	fc = beta[1]+f1+(beta[2]*f2);
	g1 = (y./fc)-((1-y)./(1-fc));
	g2 = ((y./fc)-((1-y)./(1-fc))).*f2;
	retp(g1~g2);

endp;

proc hessproc3(beta,dat);

	local y,f1,f2,fc,h11,h12,h22,H;
	y = dat[.,1];
	f1 = dat[.,3];
	f2 = dat[.,4];
    fc = beta[1]+f1+(beta[2]*f2);
	h11 = -sumc((y./(fc.^2))+((1-y)./((1-fc).^2)));
	h12 = -sumc(((y./(fc.^2))+((1-y)./((1-fc).^2))).*f2);
	h22 = -sumc(((y./(fc.^2))+((1-y)./((1-fc).^2))).*(f2.^2));
	H = (h11~h12)|(h12~h22);
	retp(H);

endp;

closeall;
