new;
#lineson; 

vsel = 2;  @1: revisions analysis uses same variances as in bias testing@
           @2: variances as in bias testing with s2eps =0@

sepb = 1;  @1: separate biases over horizons in the pooling model@
		   @0: same bias over horizons in the pooling model      @



format 6,3;

Cases = {3,2,1};
nV = 1; do while nV <= rows(Cases);
nCase = Cases[nV];

if nCase == 1;
"****************************Unemployment***************************************************";
load data[129,7] = c:\mytex\stekler\u.dat;  							   
elseif nCase == 2;
"****************************Real Output ***************************************************";
load data[129,7] = c:\mytex\stekler\x.dat;    
elseif nCase == 3;
"****************************Inflation   ***************************************************";
load data[129,7] = c:\mytex\stekler\p.dat;
endif;


@Description of data files.
The data matrices (`data') u.dat, x.dat and p.dat contain data for unemployment, real output
and inflation, respectively. The files are 129 by 7.
Column 1 contains the date of the forecast 65:4 to 97:4. 
Column 2 contains the actual data (from 65:4 to 97:4).
Column 3contains the forecasts of the current quarter from the 65:4 to 97:4 Greenbook forecasts.
Column 4 contains the forecasts of the next quarter from the 65:4 to 97:4 Greenbook forecasts.
And so on up to column 7.@ 

fn rmsfe(e) = SQRT(meanc(e.*e));

y =  data[.,2];      @actual values, 65:4 to 97:4@
temp = data[5:129,2]~data[5:129,3]~data[4:128,4]~data[3:127,5]~data[2:126,6]~data[1:125,7];
fs = temp[31:125,.];

@Biases + RMSFEs@
"Biases. 74:2 to 97:4"; 
"bias, p-values of bias, rmsfe.";
bias(fs[.,1]-fs[.,2],0)~rmsfe(fs[.,1]-fs[.,2]);
bias(fs[.,1]-fs[.,3],1)~rmsfe(fs[.,1]-fs[.,3]);
bias(fs[.,1]-fs[.,4],2)~rmsfe(fs[.,1]-fs[.,4]);
bias(fs[.,1]-fs[.,5],3)~rmsfe(fs[.,1]-fs[.,5]);
bias(fs[.,1]-fs[.,6],4)~rmsfe(fs[.,1]-fs[.,6]);

"rmsfe.  74:2 - 84:4   and   85:1 - 97:4" ;
rmsfe(fs[1:43,1]-fs[1:43,2])~rmsfe(fs[44:95,1]-fs[44:95,2]);
rmsfe(fs[1:43,1]-fs[1:43,3])~rmsfe(fs[44:95,1]-fs[44:95,3]);
rmsfe(fs[1:43,1]-fs[1:43,4])~rmsfe(fs[44:95,1]-fs[44:95,4]);
rmsfe(fs[1:43,1]-fs[1:43,5])~rmsfe(fs[44:95,1]-fs[44:95,5]);
rmsfe(fs[1:43,1]-fs[1:43,6])~rmsfe(fs[44:95,1]-fs[44:95,6]);

"biases using max poss. no. obs"; 
h=0; do while h<=4;
temp = data[1+h:129,2] - data[1:129-h,3+h];
fa = selif(temp, (temp .LT 1000));
bres=bias(fa,h);
bres~rows(fa)~rmsfe(fa);
h=h+1;endo;

@Constructing pooled error vector. T=95, h=0,1,2,3,4.
First target 74:2, forecasts h=4,3,2,1,0, then 74:3, forecasts h=4,3,2,1,0 etc@
@Given form of `data' for u, x and p, the following code constructs the TH (95 by 5 vector) e@
temp = 0;
i=35; do while i <=129; 
h = 4; do while h >= 0; 
temp = temp|data[i-h,3+h];
h=h-1;endo;
i=i+1;endo;
e= (y[35:129,.].*.ones(5,1)) - temp[2:rows(temp),1];

@Construction of covariance matrix of common shocks@
/*Gm = Am~Bm~Cm~Dm~Em; */
Gm = zeros(5,25);
Gm[1,.] = seqa(5,-1,5)'~seqa(4,-1,5)'~seqa(3,-1,4)'~0~seqa(2,-1,3)'~zeros(1,2)~1~zeros(1,4);
Gm[2,.] = 4~seqa(4,-1,4)'~seqa(4,-1,5)'~seqa(3,-1,4)'~0~seqa(2,-1,3)'~zeros(1,2)~1~zeros(1,4);
Gm[3,.] = 3~3~seqa(3,-1,3)'~3~seqa(3,-1,4)'~seqa(3,-1,4)'~0~seqa(2,-1,3)'~zeros(1,2)~1~zeros(1,4);
Gm[4,.] = 2~2~2~2~1~2~2~2~1~0~2~2~1~0~0~2~1~0~0~0~1~0~0~0~0;
Gm[5,.] = 1~1~1~1~1~1~1~1~1~0~1~1~1~0~0~1~1~0~0~0~1~0~0~0~0;

covM = Gm~(zeros(1,90).*.zeros(5,5)); 
j=2; do while j <= 90;
covM = covM|((ones(1,j-1).*.zeros(5,5))~Gm~(ones(1,90-j+1).*.zeros(5,5)));
j=j+1; endo;
covM = covM|((ones(1,90).*.zeros(5,5))~Gm);  	     @91@
covM = covM|((ones(1,91).*.zeros(5,5))~Gm[.,1:20]);	 @92@
covM = covM|((ones(1,92).*.zeros(5,5))~Gm[.,1:15]);	 @93@
covM = covM|((ones(1,93).*.zeros(5,5))~Gm[.,1:10]);	 @94@
covM = covM|((ones(1,94).*.zeros(5,5))~Gm[.,1:5]);	 @94@

r=2; do while r< rows(covM);
c=1; do while c < r;
covM[r,c] = covM[c,r];
c=c+1;endo;
r=r+1;endo;

TH = rows(e);
@Calculate s2u and s2eps@
if sepb == 0; alphah = meanc(e);	@OLS estimate@
vh = e - alphah;
elseif sepb == 1;
Xex = ones(95,1).*.eye(5);
alphaVEC = invpd(Xex'Xex)*Xex'e;	@OLS estimate. Horizon 4 to horizon 0@
vh = e - Xex*alphaVEC;
endif;

depv = vh.*vh;
indv = ones(TH,1)~(ones(95,1).*.seqa(5,-1,5));
coefv = invpd(indv'indv)*indv'depv;
s2eps = coefv[1,1];"s2eps";; s2eps; 
s2u   = coefv[2,1];"s2u  ";; s2u;	 

if s2eps .LT 0; s2eps = 0; " s^{2}_{eps} set equal to zero; s^{2}_{u} recalculated ";
indv = ones(95,1).*.seqa(5,-1,5);
s2u = invpd(indv'indv)*indv'depv;
"s2u  ";; s2u;	 
endif;

covSIG = s2u*covM + diagrv(zeros(TH,TH),s2eps*ones(TH,1));
iTH = ones(TH,1);

"OLS estimate of pooled bias, std error and p-value";
if sepb == 0;
"Common bias term";
alphah;;alphahse=SQRT(((1/TH)^2)*iTH'covSIG*iTH);
alphahse;;cdffc((alphah/alphahse)^2,1,TH-1);
elseif sepb == 1;

"Separate bias terms";
"Wald stat & pvalue (that all 5 bias estimates = 0 jointly)";
R = eye(5);
alphaVECvar = invpd(Xex'Xex)*Xex'covSIG*Xex*invpd(Xex'Xex);
Wstat = (R*alphaVEC)'invpd(R*alphaVECvar*R')*(R*alphaVEC) ;
Wstat~cdfchic(Wstat,5);

"Wald stat & pvalue (that all 5 biases are equal)";
R4 = ones(4,1)~(-1*eye(4));
Wstat4 = (R4*alphaVEC)'invpd(R4*alphaVECvar*R4')*(R4*alphaVEC) ;
Wstat4~cdfchic(Wstat4,4);
endif;

"OLS estimate of pooled bias, std error and p-value, no idiosyncratic component";
indv = ones(95,1).*.seqa(5,-1,5);
s2unoe = invpd(indv'indv)*indv'depv; 
covSIGnoe = s2unoe*covM;
if sepb == 0;
"Common bias term";
alphah;;alphahse=SQRT(((1/TH)^2)*iTH'covSIGnoe*iTH);
alphahse;;cdffc((alphah/alphahse)^2,1,TH-1);

elseif sepb ==1;
"Separate bias terms";
"Wald stat & pvalue (that all 5 bias estimates = 0 jointly)";
R = eye(5);
alphaVECvar = invpd(Xex'Xex)*Xex'covSIGnoe*Xex*invpd(Xex'Xex);
Wstat = (R*alphaVEC)'invpd(R*alphaVECvar*R')*(R*alphaVEC) ;
Wstat~cdfchic(Wstat,5);

"Wald stat & pvalue (that all 5 biases are equal)";
R4 = ones(4,1)~(-1*eye(4));
Wstat4 = (R4*alphaVEC)'invpd(R4*alphaVECvar*R4')*(R4*alphaVEC) ;
Wstat4~cdfchic(Wstat4,4);
 
endif;

"             Revisions analysis     ";"";
@Construction of vectors v_r (vr) and v_{r-1} (vr1) of forecast revisions@
vr  = zeros(94*4,1);
vr1  = zeros(94*4,1);

@12 revisions@	  @1 to 94 elements of vr@
i=36; do while i <=129; 
vr[i-35,1] = data[i,3]-data[i-1,4];
vr1[i-35,1] = data[i-1,3]-data[i-2,4];
i=i+1;endo;
@23 revisions@	  @95 to 188@
i=35; do while i <=128; 
vr[i+60,1] = data[i,4]-data[i-1,5];
vr1[i+60,1] = data[i-1,4]-data[i-2,5];
i=i+1;endo;
@34 revisions@	  @189 to 282@
i=34; do while i <=127; 
vr[i+155,1] = data[i,5]-data[i-1,6];
vr1[i+155,1] = data[i-1,5]-data[i-2,6];
i=i+1;endo;
@45 revisions@	  @283 to 376@
i=33; do while i <=126; 
vr[i+250,1] = data[i,6]-data[i-1,7];
vr1[i+250,1] = data[i-1,6]-data[i-2,7];
i=i+1;endo;

if vsel == 1;
s2u = s2u; s2e = s2eps;	   @uses same variances as in bias testing     @
elseif vsel == 2;
s2u = s2unoe; s2e = 0 ;	   @variances as in bias testing with s2eps =0 @
endif;

"s2u s2e";
s2u;;s2e;

@Cov matrix of disturbances.@
@Construct upper triangle@
covv = zeros(376,376);
i=1; do while i<=376;
j=i; do while j<=376;
if j == i; covv[i,j] = s2u + 2*s2e;	endif;		@A@
if j == i + 95; covv[i,j] = s2u; endif;	@Bi@
if j == i + 94; covv[i,j] = -s2e; endif;	@Bii@
if j == i + 190; covv[i,j] = s2u;endif;	@C@
if j == i + 285; covv[i,j] = s2u;endif;	@D@
j=j+1;endo;
i=i+1;endo;

@Construct bottom triangle@
r=2; do while r< rows(covv);
c=1; do while c < r;
covv[r,c] = covv[c,r];
c=c+1;endo;
r=r+1;endo;

"OLS estimate of pooled revisions";
vr1X = vr1~(eye(4).*.ones(94,1));
b = invpd(vr1X'vr1X)*vr1X'vr;
Vseb=invpd(vr1X'vr1X)*vr1X'covv*vr1X*invpd(vr1X'vr1X);
"coeff. OLS corrected se. p-value";
b[1,1];;SQRT(Vseb[1,1]);;cdffc((b[1,1]^2)/Vseb[1,1],1,rows(vr)-5);

"Testing revisions separately";
i=1; do while i<=4;
if i == 1; w = vr[1:94,1]; w1 = vr1[1:94,1];
elseif i ==2; w = vr[95:188,1];  w1 = vr1[95:188,1];
elseif i ==3; w = vr[189:282,1]; w1 = vr1[189:282,1];
elseif i ==4; w = vr[283:376,1]; w1 = vr1[283:376,1]; endif;
w1X = w1~ones(94,1);
b = invpd(w1X'w1X)*w1X'w;
res = w - w1X*b;
se2 = (1/(rows(res)-1-1))*(res'res);
Vseb=se2*invpd(w1'w1);
b[1,1];;SQRT(Vseb[1,1]);;cdffc((b[1,1]^2)/Vseb[1,1],1,rows(w)-1-1);
i=i+1;endo;

@************************************************************************************@
"Analysis of revisions for a given target (non-overlapping)";

@Construction of vectors vr and vr1 of forecast revisions for a GIVEN target@

vr   = zeros(95*2,1);
vr1  = zeros(95*2,1);

@12 and 34 revisions@	  @1 to 95 elements of vr and vr1@
i=35; do while i <=129; 
 vr[i-34,1] =  data[i,3]-data[i-1,4];
vr1[i-34,1] = data[i-2,5]-data[i-3,6];
i=i+1;endo;
@23  and 45 revisions@	  @96 to 190@
i=35; do while i <=129; 
 vr[i+61,1] =  data[i-2,5]-data[i-3,6];
vr1[i+61,1] = data[i-3,6]-data[i-4,7];
i=i+1;endo;


if vsel == 1;
s2u = s2u; s2e = s2eps;	   @uses same variances as in bias testing@
elseif vsel == 2;
s2u = s2unoe; s2e = 0 ;	   @variances as in bias testing with s2eps =0 @
endif;


@Cov matrix of disturbances.@
@Construct upper triangle@
covv = zeros(190,190);
i=1; do while i<=190;
j=i; do while j<=190;
if j == i;      covv[i,j] = 2*s2e + s2u;	endif;		@A@
if j == i + 95; covv[i,j] = -s2e;            endif;
if j == i + 96; covv[i,j] = s2u;            endif;     @B@
j=j+1;endo;
i=i+1;endo;

@Construct bottom triangle@
r=2; do while r< rows(covv);
c=1; do while c < r;
covv[r,c] = covv[c,r];
c=c+1;endo;
r=r+1;endo;

"OLS estimate of pooled revisions";
vr1X = vr1~(eye(2).*.ones(95,1)); @append horizon specific dummies to vr1@
b = invpd(vr1X'vr1X)*vr1X'vr;
Vseb=invpd(vr1X'vr1X)*vr1X'covv*vr1X*invpd(vr1X'vr1X);
"coeff. OLS corrected se. p-value";
b[1,1];;SQRT(Vseb[1,1]);;cdffc((b[1,1]^2)/Vseb[1,1],1,rows(vr)-1-2);

"Testing revisions separately";
i=1; do while i<=2;
if i == 1; w = vr[1:95,1]; w1 = vr1[1:95,1];
elseif i == 2; w = vr[96:190,1];  w1 = vr1[96:190,1];
endif;

w1X = w1~ones(95,1); 

b = invpd(w1X'w1X)*w1X'w;
res = w - w1X*b;
se2 = (1/(rows(res)-1-1))*(res'res);
Vseb=se2*invpd(w1X'w1X);
"coeff on revisions. standard error of estimate. p-value (t-stat)";
b[1,1];;SQRT(Vseb[1,1]);;cdffc((b[1,1]^2)/Vseb[1,1],1,rows(w)-2);
i=i+1;endo;

nV = nV + 1;
endo;

/*********************Procedures****************************************/
Proc(1) = bias(e,h);			 @Order of autocorrelation correction to SEs@
local me,n,s,tstat,s_sq,pv,p;
n  = rows(e);
me = meanc(e);
s_sq  = (1/n)*sumc((e-me).*(e-me));
p=1; do while p <= h;
s_sq = s_sq + (2/n)*sumc((e[p+1:n]-me).*(e[1:n-p]-me)); @Uniform weights@ 
p = p+1; endo;
tstat = me/(SQRT(s_sq*(1/n)));
pv = cdffc(tstat^2,1,n-1);
RETP(me~pv);
Endp;
