new;
library cml, pgraph, probs;
format /rd 4,2;
output file=spec0.out reset;
cls;

/* reading in the data  */
load x[]=hstock.txt;
x=reshape(x,rows(x)/10,10);
t=rows(x);


nret=x[.,1];
mret=0;

stop;



/* reading in the garch conditional volatilies */
load g0[t,8]=hcondv.txt;
cond0=g0[.,2];stres0=g0[.,1];
cond1=g0[.,4];stres1=g0[.,3];
cond2=g0[.,6];stres2=g0[.,5];
cond3=g0[.,8];stres3=g0[.,7];



/* constructing static intervals */
cond4=ones(t,1).*stdc((nret-mret))^2;
stres4=(nret-mret)./sqrt(cond4); 


/* evaluating static and garch interval forecasts */
__output=0;
cat=2;
condall=cond0~cond1~cond2~cond3~cond4;
coverage=seqa(0.95,0.005,1);
res1=zeros(rows(coverage),5);
res2=zeros(rows(coverage),5);
res3=zeros(rows(coverage),5);
res4=zeros(rows(coverage),5);
res5=zeros(rows(coverage),5);
res6=zeros(rows(coverage),5);
res7=zeros(rows(coverage),5);
res8=zeros(rows(coverage),5);
res9=zeros(rows(coverage),5);
res10=zeros(rows(coverage),5);
res11=zeros(rows(coverage),5);
res12=zeros(rows(coverage),5);
res13=zeros(rows(coverage),5);
res14=zeros(rows(coverage),5);
res15=zeros(rows(coverage),5);
res16=zeros(rows(coverage),5);
res17=zeros(rows(coverage),5);
res18=zeros(rows(coverage),5);
res19=zeros(rows(coverage),5);
res20=zeros(rows(coverage),5);
res21=zeros(rows(coverage),5);
res22=zeros(rows(coverage),5);
res23=zeros(rows(coverage),5);
lint75=zeros(t,5);uint75=zeros(t,5);
c1=1;
do until c1>rows(coverage);
    p=coverage[c1];
    lp=(1-p)/2;up=(1+p)/2;
    s=1;i=zeros(t,5);lint=zeros(t,5);uint=zeros(t,5);
    do until s>5; p~s;
        if s<=5;
            if s==1;
                sres=sortc(stres0,1);
            endif;
			if s==2;
                sres=sortc(stres1,1);
            endif;
			if s==3;
                sres=sortc(stres2,1);
            endif;
			if s==4;
                sres=sortc(stres3,1);
            endif;
			if s==5;
                sres=sortc(stres4,1);
            endif;


            lint[.,s]=mret+(sres[lp*t]*sqrt(condall[.,s]).*ones(t,1));	
            uint[.,s]=mret+(sres[up*t]*sqrt(condall[.,s]).*ones(t,1));	
            iup=nret .>= uint[.,s];
            ilp=nret .<= lint[.,s];
            i[.,s]=abs(iup+ilp-1);
            if p==0.95;
                uint75[.,s]=uint[.,s];
                lint75[.,s]=lint[.,s];
            endif;
         endif;





         christp1=Int_eval(p,i[.,s],cat,1);   
         christp7=Int_eval(p,i[.,s],cat,7);	   


      			
		 runt=runstest(p,i[.,s],cat);		



         y=logitd(p,i[.,s],cat,1);
		 st=ln(p/(1-p))|0;
		 _cml_Maxiters=100;
		 {yy1,yy2,yy3,yy4,yy5}=cml(y,0,&logit1,st);
		 liku=rows(y)*yy2;
		 p1=sumc(y[.,1])/rows(y);
		 likr=rows(y)*( (p1*ln(p1))+(1-p1)*ln(1-p1) );
		 lrtest=-2*(likr-liku);
		 lrp1=cdfchic(lrtest,1);    
			
		 likr=logit1(ln(p/(1-p))|0,y);
		 lrtest=-2*(likr-liku);
		 lrp1a=cdfchic(lrtest,1+1);



     	 y=logitd(p,i[.,s],cat,7); 
		 st=ln(p/(1-p))|0|0|0|0|0|0|0;
		 _cml_Maxiters=100;
		 {yy1,yy2,yy3,yy4,yy5}=cml(y,0,&logit2,st);
		 liku=rows(y)*yy2;
		 p1=sumc(y[.,1])/rows(y);
		 likr=rows(y)*( (p1*ln(p1))+(1-p1)*ln(1-p1) );
		 lrtest=-2*(likr-liku);
		 lrp2=cdfchic(lrtest,7); 
			
    	 likr=logit2(ln(p/(1-p))|0|0|0|0|0|0|0,y);
		 lrtest=-2*(likr-liku);
		 lrp2a=cdfchic(lrtest,7+1);


		 st=ln(p/(1-p))|0|0|0|0|0|0|0|0|0|0|0|0|0;
		 _cml_Maxiters=100;
		 {yy1,yy2,yy3,yy4,yy5}=cml(y,0,&logit3,st);
		 liku=rows(y)*yy2;
		 p1=sumc(y[.,1])/rows(y);
		 likr=rows(y)*( (p1*ln(p1))+(1-p1)*ln(1-p1) );
		 lrtest=-2*(likr-liku);
		 lrp3=cdfchic(lrtest,7+6); 
		
		 likr=logit3(ln(p/(1-p))|0|0|0|0|0|0|0|0|0|0|0|0|0,y);
		 lrtest=-2*(likr-liku);
		 lrp3a=cdfchic(lrtest,7+6+1);

		 lvol=x[rows(x)-rows(y)+1-7:rows(x)-7,2];
		 y=y~(lvol/100000);
		 st=ln(p/(1-p))|0|0|0|0|0|0|0|0|0|0|0|0|0|0;
		 _cml_Maxiters=100;
		 {yy1,yy2,yy3,yy4,yy5}=cml(y,0,&logit4,st);
		 liku=rows(y)*yy2;
		 p1=sumc(y[.,1])/rows(y);
		 likr=rows(y)*( (p1*ln(p1))+(1-p1)*ln(1-p1) );
		 lrtest=-2*(likr-liku);
		 lrp4=cdfchic(lrtest,7+6+2); 
		
		 likr=logit4(ln(p/(1-p))|0|0|0|0|0|0|0|0|0|0|0|0|0|0,y);
		 lrtest=-2*(likr-liku);
		 lrp4a=cdfchic(lrtest,7+6+1+2);


		 linter=uint[rows(x)-rows(y)+1-1:rows(x)-1,s]-lint[rows(x)-rows(y)+1-1:rows(x)-1,s];
		 laret=abs(nret[rows(x)-rows(y)+1-1:rows(x)-1]);
		 y=y~linter~laret;
		 st=ln(p/(1-p))|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0;
		 _cml_Maxiters=100;
		 {yy1,yy2,yy3,yy4,yy5}=cml(y,0,&logit5,st);
		 liku=rows(y)*yy2;
		 p1=sumc(y[.,1])/rows(y);
		 likr=rows(y)*( (p1*ln(p1))+(1-p1)*ln(1-p1) );
		 lrtest=-2*(likr-liku);
		 lrp5=cdfchic(lrtest,7+6+2+2); 
		
		 likr=logit5(ln(p/(1-p))|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0,y);
		 lrtest=-2*(likr-liku);
		 lrp5a=cdfchic(lrtest,7+6+1+2+2);



		 y=logitd(p,i[.,s],cat,1);
		 ftest1=olsft1(p,y);
			
    	 	 y=logitd(p,i[.,s],cat,7);
		 ftest2=olsft2(p,y);

         	 ftest3=olsft3(p,y);

		 lvol=x[rows(x)-rows(y)+1-7:rows(x)-7,2];	
		 y=y~(lvol/100000); 
		 ftest4=olsft4(p,y);


 

       	 res1[c1,s]=christp1[1,2];	 
             res2[c1,s]=christp1[1,3];
             res3[c1,s]=christp7[1,2];
		 res4[c1,s]=christp7[1,3];

		 res5[c1,s]=runt;

             res6[c1,s]=lrp1;
             res7[c1,s]=lrp1a;
             res8[c1,s]=lrp2;
             res9[c1,s]=lrp2a;
		 res10[c1,s]=lrp3;
		 res11[c1,s]=lrp3a;
		 res12[c1,s]=lrp4;
		 res13[c1,s]=lrp4a;

		 res14[c1,s]=lrp5;
		 res15[c1,s]=lrp5a;

		 res16[c1,s]=ftest1[.,2];
             res17[c1,s]=ftest1[.,3];
             res18[c1,s]=ftest2[.,2];
             res19[c1,s]=ftest2[.,3];
		 res20[c1,s]=ftest3[.,2];
		 res21[c1,s]=ftest3[.,3];
		 res22[c1,s]=ftest4[.,2];
		 res23[c1,s]=ftest4[.,3];

        s=s+1;
    endo;
    c1=c1+1;
endo;


"MCind 1 test";
res1;
"";
"MCcc 1 test";
res2;
"";
"MCind 7 test";
res3;
"";
"MCcc 7 test";
res4;
"";

"runs test";
res5;
"";

"LRind 1 test";
res6;
"";
"LRcc 1 test";
res7;
"";
"LRind 2 test";
res8;
"";
"LRcc 2 test";
res9;
"";
"LRind 3 test";
res10;
"";
"LRcc 3 test";
res11;
"";
"LRind 4 test";
res12;
"";
"LRcc 4 test";
res13;
"";
"LRind 5 test";
res14;
"";
"LRcc 5 test";
res15;
"";
"olsind 1 test";
res16;
"";
"olscc 1 test";
res17;
"";
"olsind 2 test";
res18;
"";
"olscc 2 test";
res19;
"";
"olsind 3 test";
res20;
"";
"olscc 3 test";
res21;
"";
"olsind 4 test";
res22;
"";
"olscc 4 test";
res23;
"";


output off;






graphset;
_pdate=0;
fonts("simplex simgrma");
graphprt("-c=1 -cf=spec0a.eps -w=10");
_paxht=.35;
_pnumht=.35;
_ptitlht=.35;
begwind;
window(3,1,1);
setwind(1);
_pltype={6 6 6};
_plwidth={1 5 5};
ytics(-2,2,0.5,1);
xtics(1,1673,7*5,1);
ylabel("Return");
xlabel("Observation");
title("Panel A: Static Interval");
xy(0,100*(nret~lint75[.,5]~uint75[.,5]));
nextwind;
title("Panel B: GARCH Interval");
xy(0,100*(nret~lint75[.,1]~uint75[.,1]));
nextwind;
title("Panel C: PGARCH Interval");
xy(0,100*(nret~lint75[.,3]~uint75[.,3]));
endwind;





/* Testing for periodic heteroscedasticity */
__output=1;
output file=spec0.out on;
{a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11}=ols(0,10000*abs(x[.,1]),x[.,4 5 6 7 8 9]);
{a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11}=ols(0,10000*(x[.,1]^2),x[.,4 5 6 7 8 9]);
{a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11}=ols(0,10000*cond0,x[.,4 5 6 7 8 9]);
{a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11}=ols(0,10000*cond1,x[.,4 5 6 7 8 9]);
{a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11}=ols(0,10000*cond2,x[.,4 5 6 7 8 9]);
{a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11}=ols(0,10000*cond3,x[.,4 5 6 7 8 9]);
output off;



/*****************************************************************************
 *****************************************************************************
 ****                                                                     ****
 ****                                                                     ****
 ****     BBBB  EEEEE LL     OOO  WW     WW       AAAA  RRRR    EEEEE     ****
 ****     BB  B EE    LL    OO OO WW     WW      AA  AA RR RR   EE        ****
 ****     BBBB  EEEE  LL    OO OO WW  W  WW      AAAAAA RRRR    EEEE      ****
 ****     BB  B EE    LL    OO OO WW WWW WW      AA  AA RR RR   EE        ****
 ****     BBBB  EEEEE LLLLL  OOO   WWW WWW       AA  AA RR  RR  EEEEE     ****
 ****                                                                     ****
 ****                                                                     ****
 ****  TTTTTT HH  HH  EEEEE     SSSS EEEEE PPPP   AAAA  RRRR    AAAA      ****
 ****    TT   HH  HH  EE       SS    EE    PP PP AA  AA RR RR  AA  AA     ****
 ****    TT   HHHHHH  EEEE      SSS  EEEE  PPPP  AAAAAA RRRR   AAAAAA --  ****
 ****    TT   HH  HH  EE          SS EE    PP    AA  AA RR RR  AA  AA     ****
 ****    TT   HH  HH  EEEEE    SSSS  EEEEE PP    AA  AA RR  RR AA  AA     ****
 ****                                                                     ****
 ****                                                                     ****
 ****  TTTTTT EEEEE     RRRR    OOO  UU UU TTTTTT II NNN   N EEEEE   SSSS ****
 ****    TT   EE        RR RR  OO OO UU UU   TT   II NNNN  N EE     SS    ****
 ****    TT   EEEE      RRRR   OO OO UU UU   TT   II NN NN N EEEE    SSS  ****
 ****    TT   EE        RR RR  OO OO UU UU   TT   II NN  NNN EE        SS ****
 ****    TT   EEEEE     RR  RR  OOO   UUU U  TT   II NN   NN EEEEE  SSSS  ****
 ****                                                                     ****
 ****                                                                     ****
 *****************************************************************************
 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/






proc Int_eval(x,y,c,s);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 ** This routine calculates the Christoffersen independence test          **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 ** x=coverage                                                            **
 ** c=categories                                                          **
 ** s=order of seasonality                                                **
 ** Author: Nick Taylor, May 9th 1999.                                    **
 **         Amended MPC Jan 10th 2000.                                    **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    local n, n0, n1, p, pie, j, n00, n01, n10, n11, pie2, pie00,
    pie11, pie10, pie01, num, num1, den, den1, r, pvalUC,
    pvalIND, pvalCC, LRind, LRuc;

    if c==2;
        num=0;den=0;LRind=0;pie2=0;pie00=0;pie10=0;pie01=0;pie11=0;
        n11=0;n00=0;n10=0;n01=0;n0=0;n1=0;
        n1=sumc(y);n0=rows(y)-n1;
        j=1;
        do while j<= rows(y) - s;
            if y[s+j] == 1 AND y[j] == 1; n11=n11+1; endif;
            if y[s+j] == 0 AND y[j] == 0; n00=n00+1; endif;
            if y[s+j] == 1 AND y[j] == 0; n01=n01+1; endif;
            if y[s+j] == 0 AND y[j] == 1; n10=n10+1; endif;
            j=j+1;
        endo;




        if (n00 + n01)  ==  0; pie00 = 1; pie01 = 1;
        else;pie00 = n00/(n00+n01);pie01 = n01/(n00+n01);
        endif;
        if (n10 + n11)  ==  0; pie10 = 1; pie11 = 1;
        else;pie10 = n10/(n10+n11);pie11 = n11/(n10+n11);
        endif;




        den= ((1-pie01)^n00)*(pie01^n01)*((1-pie11)^n10)*(pie11^n11);
        pie2 = (n01+n11)/(n00+n10+n01+n11);
        num = ((1-pie2)^(n00+n10))*(pie2^(n01+n11));
        LRind = -2*ln(num/den);     
        pvalIND = cdfchic(LRind,1);
        num1 = ((1-x)^n0)*(x^n1);
        pie = meanc(y);
        den1 = ((1-pie)^n0)*(pie^n1);
        LRuc = -2*ln(num1/den1);
        pvalUC = cdfchic(LRuc,1);
        pvalCC = cdfchic(LRuc+LRind,2);
        retp(pvalUC~pvalIND~pvalCC);
    endif;
endp;





proc runstest(x,y,c);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 ** This routine calculates the runs independence test                    **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 ** x=coverage                                                            **
 ** c=categories                                                          **
 ** Author: Nick Taylor, Feb 4th 2000                                     **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    local bign,dy,r,m,n,er,varr,z,pvalIND;

    if c==2;
        bign=rows(y);
        dy=y-lag(y);
        dy[1]=1;
        r=sumc(abs(dy));
        n=sumc(y);m=bign-n;

        er=1+(2*n*m/bign);
        varr=2*n*m*( (2*n*m)-bign ) / ( (bign^2)*(bign-1) );
        if r<er; r=r+0.5; else; r=r-0.5; endif;
        z=(r-er)/sqrt(varr);
        pvalIND=2*cdfn(-abs(z));

        retp(pvalIND);
    endif;
endp;


proc logitd(x,y,c,s);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 ** This routine generates data for the LOGIT model                       **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 ** x=coverage                                                            **
 ** c=categories                                                          **
 ** s=order of seasonality                                                **
 ** Author: Nick Taylor, Feb 3rd 2000                                     **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    local n, lagy, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, 
	      fh,t, k, e1, pvalIND1, 
          vardum, dummy1, dummy2, dummy3, dummy4, dummy5, dummy6,
          b1, b2, b3, b4, b5, b6, b7, b8, b9, b10,
          pvalIND2;


	
    if c==2;
        lagy={};
        n=1;
        t=rows(y);
        if s==1;
            vardum={};
        else;
            dummy1=(seqa(1,1,t)%7).==1;
            dummy2=(seqa(1,1,t)%7).==2;
            dummy3=(seqa(1,1,t)%7).==3;
            dummy4=(seqa(1,1,t)%7).==4;
            dummy5=(seqa(1,1,t)%7).==5;
            dummy6=(seqa(1,1,t)%7).==6;
            vardum=dummy1~dummy2~dummy3~dummy4~dummy5~dummy6;
        endif;
        do until n>s;
            lagy=lagy~lagn(y,n);
            n=n+1;
        endo;
		lagy=lagy[s+1:t,.];
		y=y[s+1:t,.];
		if s>1;
			vardum=vardum[s+1:t,.];
		endif;
        retp(y~lagy~vardum);
    endif;
endp;







proc logit1(param,y);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 ** This routine estimates the LOGIT model I                              **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 **                                                                       **
 **                                                                       **
 **                                                                       **
 ** Author: Nick Taylor, July 1 2001                                      **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    
local ly, t, cdffit, fit, lnl, lvar, p1, p2;
p1=param[1];
p2=param[2];

fit=p1+(p2*y[.,2]); 

if maxc(abs(fit))>20;
	fit=substute(fit,fit.>20,20);
	fit=substute(fit,fit.<-20,-20);
endif;

cdffit=exp(fit)./(1+exp(fit)); 
lnl=(y[.,1].*ln(cdffit))+((1-y[.,1]).*ln(1-cdffit)); 
lvar=sumc(lnl);


retp(lvar);
endp;




proc logit2(param,y);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 ** This routine estimates the LOGIT model II                             **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 **                                                                       **
 **                                                                       **
 **                                                                       **
 ** Author: Nick Taylor, July 1 2001                                      **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    
local ly, t, cdffit, fit, lnl, lvar, p1, p2, p3, p4, p5, p6, p7, p8;
p1=param[1];
p2=param[2];
p3=param[3];
p4=param[4];
p5=param[5];
p6=param[6];
p7=param[7];
p8=param[8];


fit=p1+(p2*y[.,2])+(p3*y[.,3])+(p4*y[.,4])+(p5*y[.,5])+(p6*y[.,6])+(p7*y[.,7])+(p8*y[.,8]); 



if maxc(abs(fit))>20;
	fit=substute(fit,fit.>20,20);
	fit=substute(fit,fit.<-20,-20);
endif;

cdffit=exp(fit)./(1+exp(fit)); 
lnl=(y[.,1].*ln(cdffit))+((1-y[.,1]).*ln(1-cdffit)); 
lvar=sumc(lnl);

retp(lvar);
endp;



proc logit3(param,y);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 ** This routine estimates the LOGIT model III                            **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 **                                                                       **
 **                                                                       **
 **                                                                       **
 ** Author: Nick Taylor, July 1 2001                                      **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    
local ly, t, cdffit, fit, lnl, lvar, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14;
p1=param[1];
p2=param[2];
p3=param[3];
p4=param[4];
p5=param[5];
p6=param[6];
p7=param[7];
p8=param[8];
p9=param[9];
p10=param[10];
p11=param[11];
p12=param[12];
p13=param[13];
p14=param[14];

fit=p1+(p2*y[.,2])+(p3*y[.,3])+(p4*y[.,4])+(p5*y[.,5])+(p6*y[.,6])+(p7*y[.,7])+(p8*y[.,8])
      +(p9*y[.,9])+(p10*y[.,10])+(p11*y[.,11])+(p12*y[.,12])+(p13*y[.,13])+(p14*y[.,14]); 




if maxc(abs(fit))>20;
	fit=substute(fit,fit.>20,20);
	fit=substute(fit,fit.<-20,-20);
endif;

cdffit=exp(fit)./(1+exp(fit)); 

lnl=(y[.,1].*ln(cdffit))+((1-y[.,1]).*ln(1-cdffit)); 
lvar=sumc(lnl);


retp(lvar);
endp;






proc logit4(param,y);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 ** This routine estimates the LOGIT model IV                             **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 **                                                                       **
 **                                                                       **
 **                                                                       **
 ** Author: Nick Taylor, July 1 2001                                      **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    
local ly, t, cdffit, fit, lnl, lvar, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15;
p1=param[1];
p2=param[2];
p3=param[3];
p4=param[4];
p5=param[5];
p6=param[6];
p7=param[7];
p8=param[8];
p9=param[9];
p10=param[10];
p11=param[11];
p12=param[12];
p13=param[13];
p14=param[14];
p15=param[15];


fit=p1+(p2*y[.,2])+(p3*y[.,3])+(p4*y[.,4])+(p5*y[.,5])+(p6*y[.,6])+(p7*y[.,7])+(p8*y[.,8])
      +(p9*y[.,9])+(p10*y[.,10])+(p11*y[.,11])+(p12*y[.,12])+(p13*y[.,13])+(p14*y[.,14])
      +(p15*y[.,15]); 



if maxc(abs(fit))>20;
	fit=substute(fit,fit.>20,20);
	fit=substute(fit,fit.<-20,-20);
endif;

cdffit=exp(fit)./(1+exp(fit)); 

lnl=(y[.,1].*ln(cdffit))+((1-y[.,1]).*ln(1-cdffit)); 
lvar=sumc(lnl);


retp(lvar);
endp;




proc logit5(param,y);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 ** This routine estimates the LOGIT model V                              **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 **                                                                       **
 **                                                                       **
 **                                                                       **
 ** Author: Nick Taylor, July 1 2001                                      **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    
local ly, t, cdffit, fit, lnl, lvar, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17;
p1=param[1];
p2=param[2];
p3=param[3];
p4=param[4];
p5=param[5];
p6=param[6];
p7=param[7];
p8=param[8];
p9=param[9];
p10=param[10];
p11=param[11];
p12=param[12];
p13=param[13];
p14=param[14];
p15=param[15];
p16=param[16];
p17=param[17];

fit=p1+(p2*y[.,2])+(p3*y[.,3])+(p4*y[.,4])+(p5*y[.,5])+(p6*y[.,6])+(p7*y[.,7])+(p8*y[.,8])
      +(p9*y[.,9])+(p10*y[.,10])+(p11*y[.,11])+(p12*y[.,12])+(p13*y[.,13])+(p14*y[.,14])
      +(p15*y[.,15])+(p16*y[.,16])+(p17*y[.,17]); 



if maxc(abs(fit))>20;
	fit=substute(fit,fit.>20,20);
	fit=substute(fit,fit.<-20,-20);
endif;

cdffit=exp(fit)./(1+exp(fit)); 

lnl=(y[.,1].*ln(cdffit))+((1-y[.,1]).*ln(1-cdffit)); 
lvar=sumc(lnl);


retp(lvar);
endp;





proc olsft1(x,y);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 ** This routine calculates the OLS-based test I                          **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 ** x=coverage                                                            **
 **                                                                       **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    local n, lagy, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11,
          q, t, k, uss, rss, fstat, e1, pvalIND, pvalUC, pvalCC;

		__con=1;
        _olsres=1;
        {a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11}=ols(0,y[.,1],y[.,2]);
		    

		uss=sumc(a10^2);
        rss=sumc((y[.,1]-meanc(y[.,1]))^2);
        q=1;
        t=rows(a10);
        k=2;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalIND=cdffc(fstat,q,t-k);


        uss=sumc((y[.,1]-meanc(y[.,1]))^2);
        rss=sumc((y[.,1]-x)^2);
        q=1;
        t=rows(a10);
        k=1;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalUC=cdffc(fstat,q,t-k);

        uss=sumc(a10^2);
        rss=sumc((y[.,1]-x)^2);
        q=2;
        t=rows(a10);
        k=2;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalCC=cdffc(fstat,q,t-k);

        retp(pvalUC~pvalIND~pvalCC);
endp;


proc olsft2(x,y);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 **                                                                       **
 ** This routine calculates the OLS-based test II                          **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 ** x=coverage                                                            **
 **                                                                       **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    local n, lagy, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11,
          q, t, k, uss, rss, fstat, e1, pvalIND, pvalUC, pvalCC;

        
        __con=1;
        _olsres=1;
        {a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11}=ols(0,y[.,1],y[.,2 3 4 5 6 7 8]);
        
		uss=sumc(a10^2);
        rss=sumc((y[.,1]-meanc(y[.,1]))^2);
        q=7;
        t=rows(a10);
        k=8;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalIND=cdffc(fstat,q,t-k);

        uss=sumc((y[.,1]-meanc(y[.,1]))^2);
        rss=sumc((y[.,1]-x)^2);
        q=1;
        t=rows(a10);
        k=1;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalUC=cdffc(fstat,q,t-k);

        uss=sumc(a10^2);
        rss=sumc((y[.,1]-x)^2);
        q=8;
        t=rows(a10);
        k=8;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalCC=cdffc(fstat,q,t-k);

        retp(pvalUC~pvalIND~pvalCC);

endp;



proc olsft3(x,y);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 **                                                                       **
 ** This routine calculates the OLS-based test III                        **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 ** x=coverage                                                            **
 **                                                                       **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    local n, lagy, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11,
          q, t, k, uss, rss, fstat, e1, pvalIND, pvalUC, pvalCC;


        
        __con=1;
        _olsres=1;
        {a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11}=ols(0,y[.,1],y[.,2 3 4 5 6 7 8 9 10 11 12 13 14]);
        
		uss=sumc(a10^2);
        rss=sumc((y[.,1]-meanc(y[.,1]))^2);
        q=13;
        t=rows(a10);
        k=14;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalIND=cdffc(fstat,q,t-k);

        uss=sumc((y[.,1]-meanc(y[.,1]))^2);
        rss=sumc((y[.,1]-x)^2);
        q=1;
        t=rows(a10);
        k=1;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalUC=cdffc(fstat,q,t-k);

        uss=sumc(a10^2);
        rss=sumc((y[.,1]-x)^2);
        q=14;
        t=rows(a10);
        k=14;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalCC=cdffc(fstat,q,t-k);

        retp(pvalUC~pvalIND~pvalCC);

endp;


proc olsft4(x,y);
/***************************************************************************
 ***************************************************************************
 **                                                                       **
 **                                                                       **
 ** This routine calculates the OLS-based test IV                         **
 **                                                                       **
 **                                                                       **
 ** y=data                                                                **
 ** x=coverage                                                            **
 **                                                                       **
 **                                                                       **
 ***************************************************************************
 ***************************************************************************/
    local n, lagy, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11,
          q, t, k, uss, rss, fstat, e1, pvalIND, pvalUC, pvalCC;

        
        __con=1;
        _olsres=1;
        {a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11}=ols(0,y[.,1],y[.,2 3 4 5 6 7 8 9 10 11 12 13 14 15]);
        
		uss=sumc(a10^2);
        rss=sumc((y[.,1]-meanc(y[.,1]))^2);
        q=13;
        t=rows(a10);
        k=14;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalIND=cdffc(fstat,q,t-k);

        uss=sumc((y[.,1]-meanc(y[.,1]))^2);
        rss=sumc((y[.,1]-x)^2);
        q=1;
        t=rows(a10);
        k=1;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalUC=cdffc(fstat,q,t-k);

        uss=sumc(a10^2);
        rss=sumc((y[.,1]-x)^2);
        q=14;
        t=rows(a10);
        k=14;
        fstat=( (rss-uss)/q )/( uss/(t-k) );
        pvalCC=cdffc(fstat,q,t-k);

        retp(pvalUC~pvalIND~pvalCC);

endp;

