/* acsAnalysis.do v0.00            DC/SO/CQD               yyyy-mm-dd:2015-04-09
----|----1----|----2----|----3----|----4----|----5----|----6----|----7----|----8

This file uses cleaned ACS data and runs regression of birth quarter on maternal
characteristics (including labour market) to examine season of birth choices. To
replicate all results, simply change the MAIN global below to the location where
this replication directory is located on your computer.

Refer to the README file in the main directory for additional information.

*/

vers 11
clear all
set more off
cap log close
set matsize 2000

********************************************************************************
*** (1) globals and locals
********************************************************************************
global MAIN "/home/replication"

global DAT "$MAIN/data/ACS"
global OUT "$MAIN/results/ACS"
global LOG "$MAIN/log"

log using "$LOG/acsAnalysis.txt", text replace

#delimit ;
local estopt cells(b(star fmt(%-9.3f)) se(fmt(%-9.3f) par([ ]) )) stats 
             (N, fmt(%9.0gc) label(Observations))     
             collabels(none) label;
local wt     [pw=perwt];
local lnote  "Heteroscedasticity robust standard errors are reported in 
            parentheses. $ ^\ddagger $ Significance based on the Leamer criterion
            at 5\%.";
local Fnote  "F-test of age variables refers to the test-statistic on the test that
              the coefficients on mother's age and age squared are jointly equal
              to zero. ";
local Xnote  "$ \chi^2 $ test statistics refer to the test that the coefficients
              on mother's age and age squared are jointly equal to zero. ";
local onote  "Optimal age calculates the turning point of the mother's age
              quadratic. ";
local qnote  "Birth quarter is based on \emph{actual} birth quarter.";
#delimit cr

ssc install estout, replace


********************************************************************************
*** (2) Open data subset to sample of interest (from Sonia's import file)
********************************************************************************
insheet using "$DAT/ACS_20052014_cleaned_all.csv", comma names case clear

keep if motherAge>=20&motherAge<=45&twins==0
tab year       , gen(_year)
tab statefip   , gen(_state)

bys twoLevelOcc: gen counter = _N
keep if counter>499
drop counter
tab twoLevelOcc, gen(_2occ)
gen motherAge2  = motherAge*motherAge/100
gen quarter2 = birthQuarter==2
gen quarter3 = birthQuarter==3
gen all      = 1
gen logInc   = log(hhincome)
gen other    = race!=1&race!=2

lab var quarter2     "Quarter 2"
lab var quarter3     "Quarter 3"
lab var motherAge    "Mother's Age"
lab var motherAge2   "Mother's Age$^2$ / 100"
lab var unemployment "Unemployment Rate"
lab var logInc       "log(household income)"
lab var highEduc     "Some College +"
lab var black        "Black"
lab var white        "White"
lab var hispanic     "Hispanic"

**M is mother, F is father
gen twoLevelOccM = twoLevelOcc
foreach s in M F {
    replace twoLevelOcc`s' = "No Occupation" if twoLevelOcc`s'=="Unemployed"
    gen oc_Arch_`s' = twoLevelOcc`s'=="Architecture and Engineering Occupations"
    gen oc_Arts_`s' = twoLevelOcc`s'=="Arts, Design, Entertainment, Sports, and Media Occupations"
    gen oc_Build_`s'= twoLevelOcc`s'=="Building and Grounds Cleaning and Maintenance Occupations"
    gen oc_Busi_`s' = twoLevelOcc`s'=="Business Operations Specialists"
    gen oc_Comm_`s' = twoLevelOcc`s'=="Community and Social Services Occupations"
    gen oc_Comp_`s' = twoLevelOcc`s'=="Computer and Mathematical Occupations"
    gen oc_Cons_`s' = twoLevelOcc`s'=="Construction Trades"
    gen oc_Educ_`s' = twoLevelOcc`s'=="Education, Training, and Library Occupations"
    gen oc_Extr_`s' = twoLevelOcc`s'=="Extraction Workers"
    gen oc_Farm_`s' = twoLevelOcc`s'=="Farming, Fishing, and Forestry Occupations"
    gen oc_Fin_`s'  = twoLevelOcc`s'=="Financial Specialists"
    gen oc_Food_`s' = twoLevelOcc`s'=="Food Preparation and Serving Occupations"
    gen oc_HltP_`s' = twoLevelOcc`s'=="Healthcare Practitioners and Technical Occupations"
    gen oc_HltS_`s' = twoLevelOcc`s'=="Healthcare Support Occupations"
    gen oc_Insl_`s' = twoLevelOcc`s'=="Installation, Maintenance, and Repair Workers"
    gen oc_Legl_`s' = twoLevelOcc`s'=="Legal Occupations"
    gen oc_Sci_`s'  = twoLevelOcc`s'=="Life, Physical, and Social Science Occupations"
    gen oc_Mgmt_`s' = twoLevelOcc`s'=="Management Occupations"
    gen oc_Mil_`s'  = twoLevelOcc`s'=="Military Specific Occupations"
    gen oc_Off_`s'  = twoLevelOcc`s'=="Office and Administrative Support Occupations"
    gen oc_Care_`s' = twoLevelOcc`s'=="Personal Care and Service Occupations"
    gen oc_Prod_`s' = twoLevelOcc`s'=="Production Occupations"
    gen oc_Prot_`s' = twoLevelOcc`s'=="Protective Service Occupations"
    gen oc_Sale_`s' = twoLevelOcc`s'=="Sales Occupations"
    gen oc_Tran_`s' = twoLevelOcc`s'=="Transportation and Material Moving Occupations"
    gen oc_Unem_`s' = twoLevelOcc`s'=="No Occupation"

    lab var oc_Arch_`s' "Architecture and Engineering"
    lab var oc_Arts_`s' "Arts, Design, Entertainment, Sports, and Media"
    lab var oc_Build_`s'"Building and Grounds Cleaning and Maintenance"
    lab var oc_Busi_`s' "Business Operations Specialists"
    lab var oc_Comm_`s' "Community and Social Services"
    lab var oc_Comp_`s' "Computer and Mathematical"
    lab var oc_Cons_`s' "Construction Trades"
    lab var oc_Educ_`s' "Education, Training, and Library"
    lab var oc_Extr_`s' "Extraction Workers"
    lab var oc_Farm_`s' "Farming, Fishing, and Forestry"
    lab var oc_Fin_`s'  "Financial Specialists"
    lab var oc_Food_`s' "Food Preparation and Serving"
    lab var oc_HltP_`s' "Healthcare Practitioners and Technical"
    lab var oc_HltS_`s' "Healthcare Support"
    lab var oc_Insl_`s' "Installation, Maintenance, and Repair Workers"
    lab var oc_Legl_`s' "Legal"
    lab var oc_Sci_`s'  "Life, Physical, and Social Science"
    lab var oc_Mgmt_`s' "Management"
    lab var oc_Mil_`s'  "Military Specific"
    lab var oc_Off_`s'  "Office and Administrative Support"
    lab var oc_Care_`s' "Personal Care and Service"
    lab var oc_Prod_`s' "Production"
    lab var oc_Prot_`s' "Protective Service"
    lab var oc_Sale_`s' "Sales"
    lab var oc_Tran_`s' "Transportation and Material Moving"
    lab var oc_Unem_`s' "No Occupation"
}
gen oc_Unkn_F = twoLevelOccF==""
lab var oc_Unkn_F "No Reported Occupation"

gen oc_OtherOc_M  = oc_Educ_M==0&oc_Unem_M==0
gen oc_OtherOc1_M = oc_Educ_M==0&oc_Arts_M==0

********************************************************************************
*** (3) regressions: industry (by quarter) [TABLES 3, A15, A16, A17]
********************************************************************************
keep if race<7
bys twoLevelOcc:  gen counterM = _N
bys twoLevelOccF: gen counterF = _N
keep if counterF>499

#delimit ;
local se  robust;
local abs abs(statefip);
local age motherAge motherAge2;
local une ;
local lv2 oc_Arch_M oc_Build_M oc_Busi_M oc_Comm_M oc_Comp_M oc_Educ_M oc_Fin_M
          oc_Food_M oc_HltP_M oc_HltS_M oc_Legl_M oc_Sci_M oc_Mgmt_M oc_Off_M
          oc_Care_M oc_Prod_M oc_Prot_M oc_Sale_M oc_Tran_M;
local lv2b oc_Arch_M oc_Arts_M oc_Build_M oc_Busi_M oc_Comm_M oc_Comp_M oc_Educ_M
           oc_Fin_M oc_Food_M oc_HltP_M oc_HltS_M oc_Legl_M oc_Sci_M oc_Mgmt_M
           oc_Off_M oc_Care_M oc_Prod_M oc_Prot_M oc_Sale_M oc_Tran_M ;
local lv2F oc_Arch_F oc_Build_F oc_Busi_F oc_Comm_F oc_Comp_F oc_Cons_F
           oc_Educ_F oc_Farm_F oc_Fin_F oc_Food_F oc_HltP_F oc_HltS_F oc_Insl_F
           oc_Legl_F oc_Sci_F oc_Mgmt_F oc_Mil_F oc_Off_F oc_Care_F oc_Prod_F
           oc_Prot_F oc_Sale_F oc_Tran_F oc_Unkn_F;
local lv2Fo oc_Arch_F oc_Build_F oc_Busi_F oc_Comm_F oc_Comp_F oc_Cons_F
           oc_Educ_F oc_Farm_F oc_Fin_F oc_Food_F oc_HltP_F oc_HltS_F oc_Insl_F
           oc_Legl_F oc_Sci_F oc_Mgmt_F oc_Mil_F oc_Off_F oc_Care_F oc_Prod_F
           oc_Prot_F oc_Sale_F oc_Tran_F;
local lv2bF oc_Arch_F oc_Arts_F oc_Build_F oc_Busi_F oc_Comm_F oc_Comp_F 
           oc_Cons_F oc_Educ_F oc_Farm_F oc_Fin_F oc_Food_F oc_HltP_F oc_HltS_F 
           oc_Insl_F oc_Legl_F oc_Sci_F oc_Mgmt_F oc_Mil_F oc_Off_F oc_Care_F 
           oc_Prod_F oc_Prot_F oc_Sale_F oc_Tran_F oc_Unkn_F;
#delimit cr

cap drop _2occ2
gen nowork = workedyr==2
lab var nowork "Did Not Work Last Year"

#delimit ;
local add `" "(Married Mothers, 20--45)" "(Unmarried Mothers, 20--45)" "';
local nam Married Unmarried;
#delimit cr
tokenize `nam'

local k=1
foreach type of local add {
    if `k'==1 local gg  motherAge>=20&motherAge<=45&married==1
    if `k'==2 local gg  motherAge>=20&motherAge<=45&married==0
    if `k'==1 local partner spouse
    if `k'==2 local partner partner
    
    local edu highEduc black white hispanic 
    local mar  unmarried
    if `k'==1 local mar married

    preserve
    keep if `gg'
     
    drop if occ2010 == 9920
    drop _2occ21
    eststo: areg quarter2 `age' `edu' `une' _year* `lv2' `wt', `se' `abs'
    test `lv2'
    estadd scalar F1 = r(F)
    local L1   = string((e(df_r)/r(df))*(e(N)^(r(df)/e(N))-1), "%5.3f")
    local L1   = string(invFtail(r(df),e(N),0.05), "%5.3f")
    test `age'
    estadd scalar F1a = r(F)
    local L2   = string((e(df_r)/r(df))*(e(N)^(r(df)/e(N))-1), "%5.3f")
    local L2   = string(invFtail(r(df),e(N),0.05), "%5.3f")
    local opt1 = round((-_b[motherAge]/(0.02*_b[motherAge2]))*100)/100
    local tL1  = string(sqrt((e(df_r)/1)*(e(N)^(1/e(N))-1)), "%5.3f")
    local pvL = ttail(e(N),sqrt((e(df_r)/1)*(e(N)^(1/e(N))-1)))
    
    eststo: areg quarter3 `age' `edu' `une' _year* `lv2' `wt', `se' `abs'
    test `lv2'
    estadd scalar F1 = r(F)
    test `age'
    estadd scalar F1a = r(F)
    local opt2 = round((-_b[motherAge]/(0.02*_b[motherAge2]))*100)/100
    
    #delimit ;
    esttab est1 est2 using "$OUT/IPUMSIndustry_``k''.tex", replace 
    keep(`age' highEduc black white hispanic `une' `lv2')
    b(%-9.3f) se(%-9.3f) brackets nonotes nogaps noline
    mlabels(, none) starlevel("$ ^\ddagger $ " `pvL')
    nonumbers style(tex) fragment label mtitles(, none)
    stats(N F1 F1a, fmt(%9.0gc %5.3f %5.3f)
          label("\midrule Observations" "F-test of Mother's Occupation Dummies"
                "F-test of Age Variables"))
    postfoot("\bottomrule \multicolumn{3}{p{13.6cm}}{\begin{footnotesize}      "
             "Sample consists of"
             " all singleton first-born children in the US born to `race' `mar'"
             " mothers aged 20-45 included in 2005-2014 ACS data where the     "
             "mother is either the head of the household or the `partner' of the "
             "head of the household and works in an occupation with at least   "
             "500 workers in the full sample. `qnote' Occupation classification"
             " is provided by the 2 digit occupation codes from the census. The"
             "omitted occupational category is Arts, Design, Entertainment,    "
             "Sports, and Media, as this occupation has Q2+Q3=0.500(0.500).    "
             "F-tests for occupation report test-statistics for the joint      "
             "significance of the dummies and `Fnote' Critical values are `L1' "
             "and `L2' for occupational and age tests respectively. The Leamer "
             "critical value for the t-statistic is `tL1'. `lnote' "
             "\end{footnotesize}}");
    #delimit cr
    estimates clear


    logit quarter2 `age' `edu' `une' _year* `lv2' i.statefip `wt', `se'
    test `lv2'
    local F1 = r(chi2)
    local L1   = string(invchi2tail(r(df),0.05), "%5.3f")
    test `age'
    local F1a = r(chi2)
    local L2   = string(invchi2tail(r(df),0.05), "%5.3f")
    local opt1 = round((-_b[motherAge]/(0.02*_b[motherAge2]))*100)/100
    local dfr = e(N)-e(rank)
    local tL1  = string(sqrt((`dfr'/1)*(e(N)^(1/e(N))-1)), "%5.3f")
    local pvL = ttail(e(N),sqrt((`dfr'/1)*(e(N)^(1/e(N))-1)))
    margins, dydx(`age' `edu' `une' black white hispanic `lv2') post
    estimates store m1
    estadd scalar F1  = `F1'
    estadd scalar F1a = `F1a'
    
    logit quarter3 `age' `edu' `une' _year* `lv2' i.statefip `wt', `se'
    test `lv2'
    local F1 = r(chi2)
    test `age'
    local F1a = r(chi2)
    local opt2 = round((-_b[motherAge]/(0.02*_b[motherAge2]))*100)/100
    margins, dydx(`age' `edu' `une' black white hispanic `lv2') post
    estimates store m2
    estadd scalar F1  = `F1'
    estadd scalar F1a = `F1a'
    
    #delimit ;
    esttab m1 m2 using "$OUT/IPUMSIndustryLogit_``k''.tex", replace 
    keep(`age' highEduc black white hispanic `une' `lv2')
    b(%-9.3f) se(%-9.3f) brackets nonotes nogaps noline
    mlabels(, none) starlevel("$ ^\ddagger $ " `pvL')
    nonumbers style(tex) fragment label mtitles(, none)
    stats(N F1 F1a, fmt(%9.0gc %5.3f %5.3f)
          label("\midrule Observations" "$ \chi^2 $ test of Mother's Occupation Dummies"
                "$ \chi^2 $ test of Age Variables"))
    postfoot("\bottomrule "
             "\multicolumn{3}{p{13.6cm}}{\begin{footnotesize}  Refer to notes   "
             "in Table \ref{ACS``k''}.  Results are replicated here using a     "
             "Logit regression and reporting average marginal effects. `qnote'  "
             "$\chi^2$ tests for occupation report test statistics for the      "
             "joint significance of the dummies, and `Xnote' Critical values    "
             "are `L1' and `L2' for occupational and age tests respectively. The"
             " Leamer critical value for the t-statistic is `tL1'. `lnote' "
             "\end{footnotesize}}");
    #delimit cr
    estimates clear
    
    lab var oc_Arch_F "\multicolumn{3}{l}{\textbf{Husband's Occupations}}\\ \\Architecture, Engineering"
    lab var oc_Arch_M "\multicolumn{3}{l}{\textbf{Mother's Occupations}}\\ \\ Architecture and Engineering"
    drop if twoLevelOccF=="No Occupation"
    eststo: areg quarter2 `age' `edu' `une' _year* `lv2' `lv2F' `wt', `se' `abs'
    test `lv2'
    estadd scalar F2 = r(F)
    test `lv2F'
    estadd scalar F2b = r(F)
    local L1   = string((e(df_r)/r(df))*(e(N)^(r(df)/e(N))-1), "%5.3f")
    local L1   = string(invFtail(r(df),e(N),0.05), "%5.3f")
    test `age'
    estadd scalar F2a = r(F)
    local L2   = string((e(df_r)/r(df))*(e(N)^(r(df)/e(N))-1), "%5.3f")
    local L2   = string(invFtail(r(df),e(N),0.05), "%5.3f")
    local opt1 = round((-_b[motherAge]/(0.02*_b[motherAge2]))*100)/100
    local tL1  = string(sqrt((e(df_r)/1)*(e(N)^(1/e(N))-1)), "%5.3f")
    local pvL = ttail(e(N),sqrt((e(df_r)/1)*(e(N)^(1/e(N))-1)))
    
    eststo: areg quarter3 `age' `edu' `une' _year* `lv2' `lv2F' `wt', `se' `abs'
    test `lv2'
    estadd scalar F2 = r(F)
    test `lv2F'
    estadd scalar F2b = r(F)
    test `age'
    estadd scalar F2a = r(F)
    local opt2 = round((-_b[motherAge]/(0.02*_b[motherAge2]))*100)/100
    
    #delimit ;
    esttab est1 est2 using "$OUT/IPUMSIndustry_``k''-both.tex", replace 
    keep(`age' highEduc black white hispanic `une' `lv2' `lv2Fo')
    b(%-9.3f) se(%-9.3f) brackets nonotes nogaps noline
    mlabels(, none) starlevel("$ ^\ddagger $ " `pvL')
    nonumbers style(tex) fragment label mtitles(, none)
    stats(N F2 F2b F2a, fmt(%9.0gc %5.3f %5.3f %5.3f)
          label("\midrule Observations" "F-test of Mother's Occupation Dummies"
                "F-test of Husband's Occupation Dummies" "F-test of Age Variables"))
    postfoot("\bottomrule \multicolumn{3}{p{13.6cm}}{\begin{footnotesize}       "
             "Sample consists of all singleton first-born children in the US    "
             "born to `race' `mar' mothers aged 20-45 included in 2005-2014 ACS "
             "data where the mother is either the head of the household or the  "
             "wife of the head of the household and both the mother and the     "
             "husband work in an occupation with at least 500 workers in the    "
             "full sample. `qnote' Occupation classification is provided by the "
             "2 digit occupation codes from the census. The omitted occupational"
             " category is Arts, Design, Entertainment, Sports, and Media, as   "
             "this occupation has Q2+Q3=0.500(0.500). F-tests for occupation    "
             "report test-statistics for the joint significance of the dummies  "
             "(for mothers and husbands separately) and `Fnote' Critical values "
             "are `L1' and `L2' for occupational and age tests respectively.    "
             "The Leamer critical value for the t-statistic is `tL1'. `lnote'  "
             "\end{footnotesize}}");
    #delimit cr
    estimates clear
    
    restore
    local ++k
}


********************************************************************************
*** (4) Figure 1b
********************************************************************************
gen Qnum = _n in 1/4
gen Qnum1 = _n+0.05 in 1/4
gen Qnum2 = _n-0.05 in 1/4
gen Qnum3 = _n+0.10 in 1/4
gen EstEduc  = .
gen EstOther = .
gen EstUnem  = .
gen lbEduc  = .
gen lbOther = .
gen lbUnem  = .
gen ubEduc  = .
gen ubOther = .
gen ubUnem  = .

gen EstEduc_u  = .
gen EstOther_u = .
gen lbEduc_u  = .
gen lbOther_u = .
gen ubEduc_u  = .
gen ubOther_u = .

gen Q2 = birthQuarter==2
reg Q2 oc_Educ_M if motherAge>=20&motherAge<=45&married==1
drop Q2


count if motherAge>=20&motherAge<=45&married==1
local NNm = string(r(N),"%12.0fc")

count if motherAge>=20&motherAge<=45&married==0
local NNu = string(r(N),"%12.0fc")

foreach Q of numlist 1(1)4 {
    gen Q`Q'=birthQuarter==`Q'
    reg Q`Q' if oc_Educ_M&motherAge>=20&motherAge<=45&married==1
    local tL1  = sqrt((e(df_r)/1)*(e(N)^(1/e(N))-1))
    replace EstEduc = _b[_cons] in `Q'
    replace ubEduc = _b[_cons]+`tL1'*_se[_cons] in `Q'
    replace lbEduc = _b[_cons]-`tL1'*_se[_cons] in `Q'
    
    reg Q`Q' if oc_OtherOc_M&motherAge>=20&motherAge<=45&married==1
    local tL1  = sqrt((e(df_r)/1)*(e(N)^(1/e(N))-1))
    replace EstOther = _b[_cons] in `Q'
    replace ubOther = _b[_cons]+`tL1'*_se[_cons] in `Q'
    replace lbOther = _b[_cons]-`tL1'*_se[_cons] in `Q'

    reg Q`Q' if oc_Unem_M&motherAge>=20&motherAge<=45&married==1
    local tL1  = sqrt((e(df_r)/1)*(e(N)^(1/e(N))-1))
    replace EstUnem = _b[_cons] in `Q'
    replace ubUnem = _b[_cons]+`tL1'*_se[_cons] in `Q'
    replace lbUnem = _b[_cons]-`tL1'*_se[_cons] in `Q'

    reg Q`Q' if oc_Educ_M&motherAge>=20&motherAge<=45&married==0
    local tL1  = sqrt((e(df_r)/1)*(e(N)^(1/e(N))-1))
    replace EstEduc_u = _b[_cons] in `Q'
    replace ubEduc_u = _b[_cons]+`tL1'*_se[_cons] in `Q'
    replace lbEduc_u = _b[_cons]-`tL1'*_se[_cons] in `Q'
    
    reg Q`Q' if oc_OtherOc_M&motherAge>=20&motherAge<=45&married==0
    local tL1  = sqrt((e(df_r)/1)*(e(N)^(1/e(N))-1))
    replace EstOther_u = _b[_cons] in `Q'
    replace ubOther_u = _b[_cons]+`tL1'*_se[_cons] in `Q'
    replace lbOther_u = _b[_cons]-`tL1'*_se[_cons] in `Q'
}

#delimit ;
format EstEduc %04.2f;
format ubEduc_u %04.2f;
format lbEduc_u %04.2f;
twoway connected EstEduc Qnum in 1/4, lcolor(black) lwidth(medthick) m(Sh) mcolor(red) 
   ||  rcap ubEduc lbEduc Qnum in 1/4, scheme(s1mono) lcolor(gs12) 
   || connected EstOther Qnum1 in 1/4, lcolor(black) lwidth(medthick) lpattern(dash) m(Oh) mcolor(blue) 
   ||  rcap ubOther lbOther Qnum1 in 1/4, lcolor(gs12)  yline(0.25, lcolor(red) lpatter(dash))
   || connected EstOther_u Qnum2 in 1/4,
      lcolor(black) lwidth(medthick) lpattern(dash_dot) m(T) mcolor(blue) 
   ||  rcap ubOther_u lbOther_u Qnum2 in 1/4, lcolor(gs12)
   || connected EstEduc_u Qnum3 in 1/4,
       lcolor(black) lwidth(medthick) lpattern(longdash) m(D) mcolor(blue) 
   ||  rcap ubEduc_u lbEduc_u Qnum3 in 1/4, lcolor(gs12) 
ytitle("Proportion Births")
note("Number of married mothers = `NNm'.  Number of unmarried mothers = `NNu'")
xlabel(1 "Quarter 1" 2 "Quarter 2" 3 "Quarter 3" 4 "Quarter 4")
legend(order(1 "Education, Library, Training (Married)" 3 "Other Occupations (Married)"   
             7 "Education, Library, Training (Unmarried)" 5 "Other Occupations (Unmarried)"
             2 "95% CI") size(small) symxsize(11));
graph export "$OUT/occupationQuarters_withUnmarried.eps", replace;
#delimit cr


********************************************************************************
*** (5) Sumstats [Table A14]
********************************************************************************
generat young     =   motherAge <=39
gen teacher=twoLevelOcc =="Education, Training, and Library Occupations"
gen quarter1 = birthQuarter==1
gen quarter4 = birthQuarter==4

local rd (1=2) (2=6) (3=9) (4=10) (5=11) (6=12) (7=13) (8=14) (10=15) (11=16)
recode educ `rd', gen(educYrs)
 
lab var other     "Other Race (Asian/Native American)"
lab var educYrs   "Years of education"
lab var married   "Married"
lab var young     "Young (aged 25-39)"
lab var highEduc  "Some College +"
lab var goodQuart "Good Season of Birth"
lab var motherAge "\midrule Mother's Age"
lab var teacher   "Works in Education, Training and Library"
lab var quarter1  "Quarter 1 Birth"
lab var quarter2  "Quarter 2 Birth"
lab var quarter3  "Quarter 3 Birth"
lab var quarter4  "Quarter 4 Birth"

#delimit ;
local add `" "(Married Mothers, 20--45)" "(Unmarried Mothers, 20--45)" "';
local nam Married Unmarried;
#delimit cr
tokenize `nam'

local k=1
foreach type of local add {
    if `k'==1 local gg  motherAge>=20&motherAge<=45&married==1
    if `k'==2 local gg  motherAge>=20&motherAge<=45&married==0
    local edu black white other hispanic

    preserve
    keep if `gg'
    drop if occ2010 == 9920
    #delimit ;
    estpost tabstat motherAge `edu' highEduc educYrs teacher
    quarter1 quarter2 quarter3 quarter4,
    statistics(count mean sd min max) columns(statistics);

    esttab using "$OUT/IPUMSstats_``k''.tex", replace label noobs
    cells("count(fmt(%12.0gc) label(N)) mean(fmt(3) label(Mean)) sd(fmt(2)
           label(Std. Dev.)) min(fmt(0) label(Min.)) max(fmt(0) label(Max.))")
    fragment tex nonumber nolines nomtitles nonotes; 
    #delimit cr
    restore

    local ++k
}


********************************************************************************
*** (6) Close
********************************************************************************
log close


