************
************ Table 4 APPLICATION TO FORECASTING GDP GROWTH WITH BBB-AAA SPREAD AND REAL STOCK PRICE GROWTH
************ comparison of pairs of overlapping forecasting models
************ Clark and McCracken, "Tests of Equal Forecast Accuracy for Overlapping Models," Journal of Applied Econometrics
************

dis %dateandtime()
dis %ratsversion()

*****  sample stuff

comp styr = 1959
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2010:4
comp fcst = 1985:1
all endsmpl

***** other settings
comp nboot = 4999                     ;* # of bootstrap reps  
comp horz = 1                        ;* forecast horizon
comp bw = 0                          ;* bandwidth/kernel setting, for Newey-West (imposing bandwidth of 0 for tau = 1)

comp seedval = 64*64 ;* seed used for artificial data
seed seedval 

**************************************** reading in functions for forecast and test computation
sou(noecho) fcasterr2.src
sou(noecho) msetfcn.src
sou(noecho) pctiles1s.src
sou(noecho) pctiles2s.src

******************************** reading in data
open data table4data.xls
data(format=xls,org=col) / gdpgrowth creditspread spgrowth
close

********************************* forecast stuff setup
comp nvar = 3                  ;* # of variables in model 
comp nfc = 2                   ;* number of forecasts considered

dec vec[series] actdata(nvar) fcerrsq(nfc)       ;* actdata = data series on y, x     
dec vec[int] truelags(nvar)                      ;* vector of lags for each variable in the y equation
dec vec[int] totvars(nvar)                       ;* vector holding count of total # of regressors in each equation
clear yfixed

dec vec[equations] model_eqs(nfc)     ;* vector of forecasting model equations
dec vec[equations] fixmodel_eqs(nfc)  ;* vector of forecasting model equations used in fixed regressor bootstrap (same equations, but with LHS variable defined differently)

comp truelags(1) = 1  ;*lags of y in y eq 
do i = 2,nvar
 comp truelags(i) = 2 ;*lags of x(i) in y eq, i = 2 to 3
end do i
comp maxlags = 0
do i = 1,nvar
  comp maxlags = %imax(maxlags,truelags(i))
end do i
dis 'maxlags =' maxlags

set actdata(1) = gdpgrowth
set actdata(2) = creditspread
set actdata(3) = spgrowth

**** forecasting equations
equation model_eqs(1) actdata(1) ;* fc model 1
# constant actdata(1){1 to truelags(1)} actdata(2){1 to truelags(2)} 
equation model_eqs(2) actdata(1) ;* fc model 2
# constant actdata(1){1 to truelags(1)} actdata(3){1 to truelags(3)}

** restricted model used in bootstrap
equation fixmodel0 yfixed
# constant actdata(1){1 to truelags(1)}

************** build up unrestricted forecasting model that includes all x variables considered
comp tableall = %eqntable(model_eqs(1))
do i = 1,nfc
 comp tableall = %tablemerge(tableall,%eqntable(model_eqs(i)))
end do i
comp reglistall = %RLFROMTABLE(tableall)

************** set up forecasting equations for use in fixed regressor bootstrap
do i = 1,nfc
 equation fixmodel_eqs(i) yfixed
 # %rlfromtable(%eqntable(model_eqs(i)))
end do i

********************************* defs. of sample points and series init.
********************************* (dep. on DGP lags)
comp stsmpl = 1960:1 ;* first obs. used in regression sample
comp firstfc = fcst+horz-1

comp impliedR = fcst-1 - stsmpl + 1
comp impliedP = endsmpl-firstfc + 1
dis impliedR impliedP %datelabel(stsmpl) %datelabel(fcst) %datelabel(endsmpl)

**************************************** bootstrap storage stuff
dec vec mset_fr(nboot) sdd_fr(nboot)

****************************************
**************************************** generating results
****************************************

******************************
****************************** sample data:  estimating models & forecast test statistics
******************************

do nm = 1,nfc
 comp temprec = fcasterr2(actdata(1),model_eqs(nm),horz,stsmpl,fcst,endsmpl,0)
 set fcerrsq(nm) firstfc endsmpl = temprec(t,2) 
 stats(noprint) fcerrsq(nm) firstfc endsmpl
 dis '*********** forecast model ' nm @40 'MSE, RMSE = ' ###.### %mean %mean^0.5
end do nm

set msediff  firstfc endsmpl = fcerrsq(1){0} - fcerrsq(2){0}  
comp resultsvec = msetfcn(msediff,firstfc,endsmpl,bw)
comp sdd = resultsvec(3)
comp mset = resultsvec(2)

linreg(robusterrors) msediff firstfc endsmpl
# constant

***** display diff in MSEs, MSE-t test, Sdd (not normalized by P)
dis ###.### resultsvec

******************************
****************************** fixed regressor bootstrap
******************************

set yfixed stsmpl-maxlags endsmpl = actdata(1){0}
linreg(print,equation=fixmodel0) * stsmpl endsmpl bsresids1
prj yfitted stsmpl endsmpl                                       ;* fitted values from restricted model

linreg(print) yfixed stsmpl endsmpl bsresids                   ;* need to estimate model with all variables, to get the right residuals
# reglistall 

do bb = 1,nboot
 ******* data generation
 set yfixed stsmpl endsmpl = yfitted{0} + bsresids{0}*%ran(1.)

 ******* forming forecasts
 do nm = 1,nfc
  comp temprec = fcasterr2(yfixed,fixmodel_eqs(nm),horz,stsmpl,fcst,endsmpl,0)
  set fcerrsq(nm) firstfc endsmpl = temprec(t,2) 
 end do nm

 set bsmsediff firstfc endsmpl = fcerrsq(1){0} - fcerrsq(2){0}
 comp resultsvec = msetfcn(bsmsediff,firstfc,endsmpl,bw)
 comp sdd_fr(bb) = resultsvec(3)
 comp mset_fr(bb) = resultsvec(2)
end do bb

******* compute and display the bootstrap percentiles we need
set statser 1 nboot = sdd_fr(t)
comp [vec] pctile_sdd = pctile1s(statser,nboot) ;* computes vector of 90th and 95th percentiles
set statser 1 nboot = mset_fr(t)
comp [rec] pctile_mset = pctile2s(statser,nboot) ;* computes matrix of 2-sided critical values, for 10% in row 1 and 5% in row 2

dis ###.### pctile_sdd

dis ###.### pctile_mset


dis %dateandtime()
