clear;

D = 2;  % the number of instruments D can take values 1, 2 or 3 ("const", "const and lagged fe", "const and lag fe and lag GDPr")
p = 1;  % the functional form parameter which can take values 1 (Lin-Lin) or 2 (Quad-Quad)
Ncases = 26;

% Activate the relevant number of observations "Nobs" below, according to the variable in use.

%Nobs inf0
%Nobs = [36;36;32;32;36;36;24;24;19;19;36;36;32;32;36;36;36;36;36;36;19;19;32;32;36;36];
%Nobs inf1
%Nobs = [35;35;31;31;35;35;23;23;18;18;35;35;31;31;35;35;35;35;35;35;18;18;31;31;35;35];

%Nobs une0
%Nobs = [36;36;32;32;36;36;24;24;19;19;35;35;32;32;36;36;30;30;36;36;19;19;32;32;36;36];
%Nobs une1
%Nobs = [34;34;31;31;34;34;23;23;18;18;34;34;31;31;34;34;29;29;34;34;18;18;31;31;34;34];

%Nobs gb0
%Nobs = [34;34;28;28;36;36;23;23;19;19;36;36;31;31;36;36;31;31;36;36;19;19;32;32;36;36];
%Nobs gb1
%Nobs = [34;34;28;28;35;35;23;23;18;18;35;35;31;31;35;35;30;30;35;35;18;18;31;31;35;35];

%Nobs inv0
%Nobs = [36;36;32;32;36;36;24;24;19;19;36;36;32;32;36;36;29;29;36;36;19;19;32;32;36;36];
%Nobs inv1
%Nobs = [35;35;31;31;35;35;23;23;18;18;35;35;31;31;35;35;28;28;35;35;18;18;31;31;35;35];

%Nobs ca0
%Nobs = [34;34;33;33;34;34;23;23;19;19;34;34;32;32;34;34;27;27;34;34;19;19;32;32;34;34];
%Nobs ca1
Nobs = [34;34;31;31;34;34;23;23;18;18;34;34;31;31;34;34;25;25;34;34;18;18;31;31;34;34];


load f:\MacroForecasts\ca1.dat;      % loads a T x 26 matrix VAR_forecast, VAR_true (stucked from past to present)
alphas = zeros(Ncases/2,1);
sdevs = zeros(Ncases/2,1);
jtests = zeros(Ncases/2,4);

iter = 1; while iter <= Ncases;
    
T = Nobs(iter);   % the number of years
VARf = ca1(max(Nobs)-T+1:max(Nobs),iter);   % forecast seies
VARt = ca1(max(Nobs)-T+1:max(Nobs),iter+1);   % true series 
fe = VARt-VARf;         % forecast error series
Niter = 20;     % number of iterations for convergence

% construction of instruments

if D==1;
    v = ones(T-1,1);
elseif D==2;
    v = [ones(T-1,1) VARt(1:T-1)];
elseif D==3;
    v = [ones(T-1,1) fe(1:T-1) VARt(1:T-1)];
end;

% construction of series to be analysed from 2:T

VARf = VARf(2:T);
VARt = VARt(2:T);
fe = fe(2:T);

vfe = zeros(T-1,D);
vdfe = zeros(T-1,D);
vdafe = zeros(T-1,D);

% iteration i = 1

S(:,:,1) = eye(D);    % the 1-st iteration uses the identity matrix as a covariance matrix

i=1; while i <= T-1;
vfe(i,:) = v(i,:).*abs(fe(i))^(p-1);
i=i+1;
end;

i=1; while i <= T-1;
    if fe(i) < 0; 
vdfe(i,:) = v(i,:).*abs(fe(i))^(p-1);
    else;
vdfe(i,:) = 0;
end
i=i+1;
end;

a(1) = (mean(vfe)*inv(S(:,:,1))*mean(vdfe)')/(mean(vfe)*inv(S(:,:,1))*mean(vfe)');

% iterations i = 2,3 ... until convergence

j = 2; while j<=Niter; 
    s = zeros(D,D,T-1);
    
    i=1; while i <= T-1;
        if fe(i) < 0; 
    s(:,:,i) = v(i,:)'*v(i,:).*(1-a(j-1))^2*abs(fe(i))^(2*p-2);
        else;
    s(:,:,i) = v(i,:)'*v(i,:).*(-a(j-1))^2*abs(fe(i))^(2*p-2);
    end
    i=i+1;
    end;    
    
    
    S(:,:,j) = mean(s,3);
    
    
    i=1; while i <= T-1;
vfe(i,:) = v(i,:).*abs(fe(i))^(p-1);
i=i+1;
end;

i=1; while i <= T-1;
    if fe(i) < 0; 
vdfe(i,:) = v(i,:).*abs(fe(i))^(p-1);
    else;
vdfe(i,:) = 0;
end
i=i+1;
end;

a(j) = (mean(vfe)*inv(S(:,:,j))*mean(vdfe)')/(mean(vfe)*inv(S(:,:,j))*mean(vfe)');
    
j=j+1;
end;


% estimation of parameter std deviation (proposition (4))

h = mean(vfe);

sig2 = inv(h*inv(S(:,:,Niter))*h');
sig = sqrt(sig2)/sqrt(T-1);

% construction of the J-statistic (Corollary 5) under ASYMMETRIC loss

i=1; while i <= T-1;
    if fe(i) < 0; 
vdafe(i,:) = v(i,:).*(1-a(Niter))*abs(fe(i))^(p-1);
    else;
vdafe(i,:) = v(i,:).*(-a(Niter))*abs(fe(i))^(p-1);
end
i=i+1;
end;

J = (1/(T-1))*(sum(vdafe)*inv(S(:,:,Niter))*sum(vdafe)');

a=a(Niter), sig, J
alphas((iter+1)/2) = a;
sdevs((iter+1)/2) = sig;
jtests((iter+1)/2,1) = J;

%  J-statistic under SYMMETRIC loss: a(Niter)=.20;

a=.20;
s = zeros(D,D,T-1);
    
    i=1; while i <= T-1;
        if fe(i) < 0; 
    s(:,:,i) = v(i,:)'*v(i,:).*(1-a)^2*abs(fe(i))^(2*p-2);
        else;
    s(:,:,i) = v(i,:)'*v(i,:).*(-a)^2*abs(fe(i))^(2*p-2);
    end;
    i=i+1;
    end;    
   
    S = mean(s,3);
    
i=1; while i <= T-1;
    if fe(i) < 0; 
vdafe(i,:) = v(i,:).*(1-a)*abs(fe(i))^(p-1);
    else;
vdafe(i,:) = v(i,:).*(-a)*abs(fe(i))^(p-1);
end
i=i+1;
end

Jasym = (1/(T-1))*(sum(vdafe)*inv(S)*sum(vdafe)');

jtests((iter+1)/2,2) = Jasym;

%  J-statistic under SYMMETRIC loss: a(Niter)=.50;

a=.50;
s = zeros(D,D,T-1);
    
    i=1; while i <= T-1;
        if fe(i) < 0; 
    s(:,:,i) = v(i,:)'*v(i,:).*(1-a)^2*abs(fe(i))^(2*p-2);
        else;
    s(:,:,i) = v(i,:)'*v(i,:).*(-a)^2*abs(fe(i))^(2*p-2);
    end;
    i=i+1;
    end;    
   
    S = mean(s,3);
    
i=1; while i <= T-1;
    if fe(i) < 0; 
vdafe(i,:) = v(i,:).*(1-a)*abs(fe(i))^(p-1);
    else;
vdafe(i,:) = v(i,:).*(-a)*abs(fe(i))^(p-1);
end
i=i+1;
end

Jasym = (1/(T-1))*(sum(vdafe)*inv(S)*sum(vdafe)');

jtests((iter+1)/2,3) = Jasym;

%  J-statistic under SYMMETRIC loss: a(Niter)=.80;

a=.80;
s = zeros(D,D,T-1);
    
    i=1; while i <= T-1;
        if fe(i) < 0; 
    s(:,:,i) = v(i,:)'*v(i,:).*(1-a)^2*abs(fe(i))^(2*p-2);
        else;
    s(:,:,i) = v(i,:)'*v(i,:).*(-a)^2*abs(fe(i))^(2*p-2);
    end;
    i=i+1;
    end;    
   
    S = mean(s,3);
    
i=1; while i <= T-1;
    if fe(i) < 0; 
vdafe(i,:) = v(i,:).*(1-a)*abs(fe(i))^(p-1);
    else;
vdafe(i,:) = v(i,:).*(-a)*abs(fe(i))^(p-1);
end
i=i+1;
end

Jasym = (1/(T-1))*(sum(vdafe)*inv(S)*sum(vdafe)');

jtests((iter+1)/2,4) = Jasym;






iter = iter + 2;
end;