% Estimation of spectral density
% gam = spectral density
% d_t = loss differential, i.e., d_t=g(e_1t) - g(e_2t)

function [fd]=specden(d_t)

TF=length(d_t);% length of forecasting differential
gam=var(d_t);% variance of forecasting differential
M=round(TF^(1/3));% maximum lag length (both sides)
m=M+1;    
    
gamm=zeros(TF-(m-1),m);% bins

for kk=1:m
 gamm(:,kk)=d_t(m+1-kk:TF+1-kk);% part of loss differential to compute covariance    
end

gamk=zeros(m-1,1);% bins for covariance
    
for jj=1:m-1

gamk(jj)=corr(gamm(:,1),gamm(:,jj+1))*std(gamm(:,1))*std(gamm(:,jj+1));
    
end
    
fd=(1/(2*pi))*(gam+2*sum(gamk));% spectral density
    
if fd<0
  fd=sqrt(fd^2);
end

end


