rm(list=ls())
library(Bolstad) 
library(AER) 
library(mvtnorm) 
source("TSIV_functions.R")

n1=5000
n2=1000
S=5000
alpha=0.05
beta = c(-2,0,2)
K=c(1,5,10)
CONC=c(1,4,16)
p=1
eta=rep(0,p)
nu=rep(0,p)
for (b in 1:length(beta)){  
ci_true = matrix(NA,nrow=length(K),ncol=length(CONC))
ci_true_AR = matrix(NA,nrow=length(K),ncol=length(CONC))
ci_true_CLR = matrix(NA,nrow=length(K),ncol=length(CONC))
ci_true_K = matrix(NA,nrow=length(K),ncol=length(CONC))

type_AR_2 = matrix(NA,nrow=length(K),ncol=length(CONC))
type_CLR_2 = matrix(NA,nrow=length(K),ncol=length(CONC))
type_K_2 = matrix(NA,nrow=length(K),ncol=length(CONC))

ci_length = matrix(NA,nrow=length(K),ncol=length(CONC))
ci_length_AR = matrix(NA,nrow=length(K),ncol=length(CONC))
ci_length_CLR = matrix(NA,nrow=length(K),ncol=length(CONC))
ci_length_K = matrix(NA,nrow=length(K),ncol=length(CONC))

for (kind in 1:length(K)){
	k=K[kind]
	set.seed(123)  
  for (concind in 1:length(CONC)){
  	conc=CONC[concind]
  	print(c(k,conc))
    lambda = conc*k
	Pi=rep(sqrt(lambda / (n2*k)),k)
	citrue = rep(NA,S)
	citrue_AR = rep(NA,S)
	citrue_CLR = rep(NA,S)
	citrue_K = rep(NA,S)
	type_AR = rep(NA,S)
	type_CLR = rep(NA,S)
  type_K = rep(NA,S)
  cilength = rep(NA,S)
	cilength_AR = rep(NA,S)
	cilength_CLR = rep(NA,S)
	cilength_K = rep(NA,S)

for (s in 1:S){
	z1=rmvnorm(n1,sigma=diag(k))
	z2=rmvnorm(n2,sigma=diag(k))
	u1=rnorm(n1)
	e=rnorm(n1)
	v1=u1*0.1+e*sqrt(0.99)
	v2=rnorm(n2)
	if (p==1){
	x1<-matrix(1,nrow=n1,ncol=p)
    x2<-matrix(1,nrow=n2,ncol=p)
    }
    else{
    x1<-cbind(rep(1,n1),rnorm(n1))
    x2<-cbind(rep(1,n2),rnorm(n2))		
    }
	w1=t(t(z1))%*%Pi+x1%*%eta+v1
	w2=t(t(z2))%*%Pi+x2%*%eta+v2
	y1=beta[b]*w1+x1%*%nu+u1
	
  
## 95% Confidence Interval - Classical t-test
	Pihat<-lm(w2~z2+x2-1)$coefficients
	v2sigmasq<-sum((residuals(lm(w2~z2+x2-1)))^2)/(n2-k-p)
	w1hat<-cbind(z1,x1)%*%Pihat
	betahat<-lm(y1~w1hat+x1-1)$coefficients[1]  
	e1sigmasq<-sum((residuals(lm(y1~w1hat+x1-1)))^2)/(n2-1-p)
	vbetahat=(summary(lm(y1~w1hat+x1-1))$coefficients[1,2])^2*(1+n1/n2*betahat^2*(v2sigmasq)/(e1sigmasq))
	ci <- c(betahat-qt(0.975,n1-k-1)*sqrt(vbetahat), betahat+qt(0.975,n1-k-1)*sqrt(vbetahat)) 
	citrue[s] <- ci[1] <= beta[b] & ci[2] >= beta[b]
  cilength[s] <- qt(0.975,n1-k-1)*sqrt(vbetahat)*2


## 95% Confidence Set - AR method
	results<-TSci(y1,w1hat,w2,z1,z2,x1,x2,alpha)
	type_AR[s]=results$type_AR
	set_AR=results$set_AR
	# Four cases 1)Empty, 2) [x1,x2], 3) real line, 4) (-inf,x1] U [x2,inf)
	if (type_AR[s]==1) {
 	 citrue_AR[s] <- 0
	} else if (type_AR[s]==3) {
	  citrue_AR[s] <- 1
	} else if (type_AR[s]==2) {
	  citrue_AR[s] <- set_AR[1] <= beta[b] & set_AR[2] >= beta[b]
	} else {
	  citrue_AR[s] <- set_AR[1] >= beta[b] | set_AR[2] <= beta[b]
	}
  # Calculate length of CI
  if (type_AR[s]==2) {
    cilength_AR[s] <- abs(set_AR[1]-set_AR[2])
  } else {
    cilength_AR[s] <- 0
  }


## 95% Confidence Set - CLR method
type_CLR[s]=results$type_CLR
set_CLR=results$set_CLR 
# Three cases 2) [x1,x2], 3) real line, 4) (-inf,x1] U [x2,inf).
if (type_CLR[s]==1) {
  citrue_CLR[s] <- 0
} else if (type_CLR[s]==3) {
  citrue_CLR[s] <- 1
} else if (type_CLR[s]==2) {
  citrue_CLR[s] <- set_CLR[1] <= beta[b] & set_CLR[2] >= beta[b]
} else {
  citrue_CLR[s] <- set_CLR[1] >= beta[b] | set_CLR[2] <= beta[b]
}
# Calculate length of CI
if (type_CLR[s]==2) {
  cilength_CLR[s] <- abs(set_CLR[1]-set_CLR[2])
} else {
  cilength_CLR[s] <- 0
}

## 95% Confidence Set - K method
type_K[s]=results$type_K
set_K=results$set_K 
# Four cases 1) Not possible 2) [x1,x2], 3) real line, 4) (-inf,x1] U [x2,inf), 
# 5) (-inf,x1] U [x2,x3] U [x4,inf), 6) [x1,x2] U [x3,x4].
if (type_K[s]==1) {
  citrue_K[s] <- 0
} else if (type_K[s]==3) {
  citrue_K[s] <- 1
} else if (type_K[s]==2) {
  citrue_K[s] <- set_K[1] <= beta[b] & set_K[2] >= beta[b]
} else if (type_K[s]==4) {
  citrue_K[s] <- set_K[1] >= beta[b] | set_K[2] <= beta[b]
} else if (type_K[s]==5) {
  citrue_K[s] <- set_K[1] >= beta[b] | set_K[4] <= beta[b] | (set_K[2] <= beta[b] & set_K[3] >= beta[b])
} else {
  citrue_K[s] <- (set_K[1] <= beta[b] & set_K[2] >= beta[b]) | (set_K[3] <= beta[b] & set_K[4] >= beta[b])
}
# Calculate length of CI
if (k==1){
if (type_K[s]==2) {
  cilength_K[s] <- abs(set_K[1]-set_K[2])
} else {
  cilength_K[s] <- 0
}
}
else{
# Calculate length of CI
if (type_K[s]==6) {
  cilength_K[s] <- abs(set_K[1]-set_K[2]) +abs(set_K[3]-set_K[4])
} else {
  cilength_K[s] <- 0
}
}


}

ci_true[kind,concind] <- mean(citrue)
ci_true_AR[kind,concind] <- mean(citrue_AR)
ci_true_CLR[kind,concind] <- mean(citrue_CLR)
ci_true_K[kind,concind] <- mean(citrue_K)

type_AR_2[kind,concind] <- sum(type_AR == 2)
type_CLR_2[kind,concind] <- sum(type_CLR == 2)
if (k==1) {
type_K_2[kind,concind] <- sum(type_K == 2)
}
else{
type_K_2[kind,concind] <- sum(type_K == 6)
}
ci_length[kind,concind] <- mean(cilength)
ci_length_AR[kind,concind] <- sum(cilength_AR) / type_AR_2[kind,concind]
ci_length_CLR[kind,concind] <- sum(cilength_CLR) / type_CLR_2[kind,concind]
ci_length_K[kind,concind] <- sum(cilength_K) / type_K_2[kind,concind]


}
}
print(ci_true)
print(ci_true_AR)
print(ci_true_CLR)
print(ci_true_K)

print(type_AR_2)
print(type_CLR_2)
print(type_K_2)

print(ci_length)
print(ci_length_AR)
print(ci_length_CLR)
print(ci_length_K)



save(ci_true,ci_true_AR,ci_true_CLR,ci_true_K,type_AR_2,type_CLR_2,type_K_2,ci_length,ci_length_AR,ci_length_CLR,ci_length_K,file=paste("./mktable/ci",b,".RData",sep=""))
}


