# version January, 2017

TStest<-function(y1,w1hat,w2,z1,z2,x1,x2,beta0=0){
	n1=length(y1)
	n2=length(w2)
	k=ncol(z1)
    if (is.null(x1)!=1){
    z1=residuals(lm(z1~x1)) 
    z2=residuals(lm(z2~x2)) 
    p=ncol(x1)
    } else {
  	p=0
    }
    Y=cbind(y1,w1hat) 
    Z1=cbind(z1,x1)
	Z2=cbind(z2,x2)	
	a0=c(beta0,1)
	b0=c(1,-beta0)
	u1sigmasq=(t(y1)%*%y1-t(y1)%*%Z1%*%solve(crossprod(Z1))%*%(t(Z1)%*%y1))/(n1-k-p)
	v2sigmasq=(t(w2)%*%w2-t(w2)%*%Z2%*%solve(crossprod(Z2))%*%(t(Z2)%*%w2))/(n2-k-p)
	OMEGA=matrix(c(u1sigmasq,0,0,n1/n2*v2sigmasq),nrow=2,ncol=2)
	Z=z1
	ZprimeZ= t(Z)%*%Z
	if (k>1){
	ZprimeZ_sqrt=eigen(ZprimeZ)$vectors%*%diag(sqrt(eigen(ZprimeZ)$values))%*%t(eigen(ZprimeZ)$vectors)
	} else
	{
	ZprimeZ_sqrt=sqrt(ZprimeZ)	
	}
	MATS= (solve(ZprimeZ_sqrt)%*%t(Z)%*%Y%*%b0)/drop(t(b0)%*%OMEGA%*%b0)^0.5
	MATT=solve(ZprimeZ_sqrt)%*%t(Z)%*%Y%*%solve(OMEGA)%*%a0/drop(t(a0)%*%solve(OMEGA)%*%a0)^0.5

# The proposed two-sample AR method
    ARstat=t(MATS)%*%MATS
# The proposed two-sample LM method
    Kstat=(t(MATS)%*%MATT)^2/(t(MATT)%*%MATT)
# The proposed two-sample CLR method
	CLRstat=(t(MATS)%*%MATS-t(MATT)%*%MATT+sqrt((t(MATS)%*%MATS+t(MATT)%*%MATT)^2-4*t(MATS)%*%MATS%*%t(MATT)%*%MATT+4*(t(MATS)%*%MATT)^2))/2
## obtaining p-value for the CLR test
CLRpvalue=CLRpvaluefunc(CLRstat, t(MATT)%*%MATT, k)
list(ARstat=ARstat,Kstat=Kstat,CLRstat=CLRstat,CLRpvalue=CLRpvalue)
}

TStest_hetero<-function(y1,w2,z1,z2,x1,x2,beta=0){
	n1=length(y1)
	n2=length(w2)
	k=ncol(z1)
	p=ncol(x1)
	z1=residuals(lm(z1~x1)) 
	z2=residuals(lm(z2~x2))  
	hateta=solve(crossprod(z1))%*%(t(z1)%*%y1)
	hatpi=solve(crossprod(z2))%*%(t(z2)%*%w2)	
  u1hat=residuals(lm(y1~z1+x1)) 
	v2hat=residuals(lm(w2~z2+x2)) 
	SIGMAU1=crossprod((u1hat%*%matrix(1,nrow=1,ncol=k))*z1)
  SIGMAE2=crossprod((v2hat%*%matrix(1,nrow=1,ncol=k))*z2)
  SIGMA1=solve(crossprod(z1))%*%SIGMAU1%*%solve(crossprod(z1))*n1^2/(n1-k-p)
  SIGMA2=solve(crossprod(z2))%*%SIGMAE2%*%solve(crossprod(z2))*n2^2/(n2-k-p)

	ARstat=rep(NA,length(beta))
	Kstat=rep(NA,length(beta))
	CLRstat=rep(NA,length(beta))
	CLRpvalue=rep(NA,length(beta))
	    for (g in 1:length(beta)){
	    	beta0=beta[g]
	    	print(beta0)
	SIGMA=SIGMA1+(n1/n2)*beta0^2*SIGMA2
	SIGMA_inv=solve(SIGMA)
	if (k>1){
      	SIGMA_invsqrt=eigen(SIGMA_inv)$vectors%*%diag(sqrt((eigen(SIGMA_inv)$values)))%*%t(eigen(SIGMA_inv)$vectors)
	} else
	{
	SIGMA_invsqrt=1/sqrt(SIGMA)	
	}
# The proposed robust two-sample AR method
    ARstat[g]=n1*t(hateta-hatpi*beta0)%*%SIGMA_inv%*%(hateta-hatpi*beta0)
    hatD=-(hatpi+(n1/n2)*beta0*SIGMA2%*%SIGMA_inv%*%(hateta-hatpi*beta0))
    PK=(SIGMA_invsqrt%*%hatD)%*%solve(t(SIGMA_invsqrt%*%hatD)%*%(SIGMA_invsqrt%*%hatD))%*%t(SIGMA_invsqrt%*%hatD)
    Kstat[g]=n1*t(SIGMA_invsqrt%*%(hateta-hatpi*beta0))%*%PK%*%(SIGMA_invsqrt%*%(hateta-hatpi*beta0))
    hatQt=n1*t(hatD)%*%solve((n1/n2)*SIGMA2-(n1/n2)^2*beta0^2*SIGMA2%*%SIGMA_inv%*%SIGMA2)%*%hatD
    CLRstat[g]=(ARstat[g]-hatQt+sqrt((ARstat[g]+hatQt)^2-4*ARstat[g]%*%hatQt+4*Kstat[g]%*%hatQt))/2
## obtaining p-value for the CLR test
CLRpvalue[g]=CLRpvaluefunc(CLRstat[g],hatQt, k)
}
list(ARstat=ARstat,Kstat=Kstat,CLRstat=CLRstat,CLRpvalue=CLRpvalue)
}


TStest_homo_unequal<-function(y1,w2,z1,z2,x1,x2,beta=0){
  n1=length(y1)
  n2=length(w2)
  k=ncol(z1)
  if (is.null(x1)!=1){
  z1=residuals(lm(z1~x1)) 
  z2=residuals(lm(z2~x2)) 
  p=ncol(x1)
  } else {
  	p=0
  } 
  hateta=solve(crossprod(z1))%*%(t(z1)%*%y1)
  hatpi=solve(crossprod(z2))%*%(t(z2)%*%w2)	
  if (is.null(x1)!=1){
  u1hat=residuals(lm(y1~z1+x1)) 
  v2hat=residuals(lm(w2~z2+x2)) 
  } else {
  u1hat=residuals(lm(y1~z1-1)) 
  v2hat=residuals(lm(w2~z2-1)) 	
  }
  u1sigmasq=(t(y1)%*%y1-t(y1)%*%z1%*%solve(crossprod(z1))%*%(t(z1)%*%y1))/(n1-k-p)
  v2sigmasq=(t(w2)%*%w2-t(w2)%*%z2%*%solve(crossprod(z2))%*%(t(z2)%*%w2))/(n2-k-p)
  SIGMA1=as.numeric(u1sigmasq)*solve(crossprod(z1)/n1)
  SIGMA2=as.numeric(v2sigmasq)*solve(crossprod(z2)/n2)
  ### When SIGMA2=as.numeric(v2sigmasq)*solve(crossprod(z1)/n1) is used, the test reduce to the benchmark test. See paper page 14, discussion on \bar \Sigma_beta0.
  
  ARstat=rep(NA,length(beta))
  Kstat=rep(NA,length(beta))
  CLRstat=rep(NA,length(beta))
  CLRpvalue=rep(NA,length(beta))
  for (g in 1:length(beta)){
    beta0=beta[g]
    print(beta0)
    SIGMA=SIGMA1+(n1/n2)*beta0^2*SIGMA2
    SIGMA_inv=solve(SIGMA,tol=0)
    if (k>1){
      SIGMA_invsqrt=eigen(SIGMA_inv)$vectors%*%diag(sqrt((eigen(SIGMA_inv)$values)))%*%t(eigen(SIGMA_inv)$vectors)
    } else
    {
      SIGMA_invsqrt=1/sqrt(SIGMA)	
    }
    # The proposed robust two-sample AR method
    ARstat[g]=n1*t(hateta-hatpi*beta0)%*%SIGMA_inv%*%(hateta-hatpi*beta0)
    hatD=-(hatpi+(n1/n2)*beta0*SIGMA2%*%SIGMA_inv%*%(hateta-hatpi*beta0))
    PK=(SIGMA_invsqrt%*%hatD)%*%solve(t(SIGMA_invsqrt%*%hatD)%*%(SIGMA_invsqrt%*%hatD))%*%t(SIGMA_invsqrt%*%hatD)
    Kstat[g]=n1*t(SIGMA_invsqrt%*%(hateta-hatpi*beta0))%*%PK%*%(SIGMA_invsqrt%*%(hateta-hatpi*beta0))
    hatQt=n1*t(hatD)%*%solve((n1/n2)*SIGMA2-(n1/n2)^2*beta0^2*SIGMA2%*%SIGMA_inv%*%SIGMA2)%*%hatD
    CLRstat[g]=(ARstat[g]-hatQt+sqrt((ARstat[g]+hatQt)^2-4*ARstat[g]%*%hatQt+4*Kstat[g]%*%hatQt))/2
    ## obtaining p-value for the CLR test
    CLRpvalue[g]=CLRpvaluefunc(CLRstat[g],hatQt, k)
  }
  list(ARstat=ARstat,Kstat=Kstat,CLRstat=CLRstat,CLRpvalue=CLRpvalue)
}


TSci<-function(y1,w1hat,w2,z1,z2,x1,x2,alpha=0.05,beta=0){
	n1=length(y1)
	n2=length(w2)
	k=ncol(z1)
	if (is.null(x1)!=1){
    z1=residuals(lm(z1~x1)) 
    z2=residuals(lm(z2~x2)) 
    p=ncol(x1)
    } else {
  	p=0
    }
	Y=cbind(y1,w1hat)
	Z1=cbind(z1,x1)
	Z2=cbind(z2,x2)	
	u1sigmasq=(crossprod(y1)-(crossprod(y1,Z1)%*%solve(crossprod(Z1)))%*%crossprod(Z1,y1))/(n1-k-p)
	v2sigmasq=(crossprod(w2)-(crossprod(w2,Z2)%*%solve(crossprod(Z2)))%*%crossprod(Z2,w2))/(n2-k-p)
	OMEGA=matrix(c(u1sigmasq,0,0,n1/n2*v2sigmasq),nrow=2,ncol=2)
	Z=z1
	ZprimeZ= crossprod(Z)
	if (k>1){
	ZprimeZ_sqrt=eigen(ZprimeZ)$vectors%*%diag(sqrt(eigen(ZprimeZ)$values))%*%t(eigen(ZprimeZ)$vectors)
	} else
	{
	ZprimeZ_sqrt=sqrt(ZprimeZ)	
	}
    
# The proposed two-sample AR confidence region
	MATci=crossprod(Y,Z)%*%(solve(ZprimeZ)%*%crossprod(Z,Y))
  arci=ARCI(MATci,OMEGA,k,alpha)

# The proposed two-sample CLR confidence region
	OMEGA_sqrt=eigen(OMEGA)$vectors%*%diag(sqrt(eigen(OMEGA)$values))%*%t(eigen(OMEGA)$vectors)
  MATA= solve(OMEGA_sqrt)%*%MATci%*% solve(OMEGA_sqrt) 
  M =  max(eigen(MATA)$values)  
  N =  min(eigen(MATA)$values)
  clrci=CLRCI(MATci,OMEGA,M,k,alpha)

# The proposed two-sample K confidence region
Kci=KCI(MATci,OMEGA,M,N,k,alpha)
list(type_AR=arci$type_AR,set_AR=arci$set_AR,type_CLR=clrci$type_CLR,set_CLR=clrci$set_CLR,type_K=Kci$type_K,set_K=Kci$set_K)
}


CLRpvaluefunc<-function(clrstat, QT, k){
  ## calculate the conditional p-values using numerical intergral
if (k>=2){
K4=exp(lgamma(k/2)-log(pi^0.5)-lgamma((k-1)/2)) 
x = seq(0,1,length = 5000)
u = seq(0,pi/2,length = 5000)
epsilon = 0.02
z = seq(0,1-epsilon,length = 5000)

if (k==2) {
  fu = pchisq((QT+clrstat)/(1+QT*sin(u)^2/clrstat),k)
  estimate = sintegral(u,fu)$value
  CLRpvalue=1-2*K4*estimate
} else if (k==4) {
  fz = pchisq((QT+clrstat)/(1+QT*z^2/clrstat),k)*(1-z^2)^((k-3)/2)
  estimate = sintegral(z,fz)$value
  CLRpvalue=1-2*K4*estimate-2*K4*pchisq((QT+clrstat)/(1+QT*(1-epsilon/2)^2/clrstat),k)*(0.5*(asin(1)-asin(1-epsilon))-((1-epsilon)/2)*(1-(1-epsilon)^2)^0.5)
}
else {
 fx = pchisq((QT+clrstat)/(1+QT*x^2/clrstat),k)*(1-x^2)^((k-3)/2)
 estimate = sintegral(x,fx)$value
 CLRpvalue=1-2*K4*estimate
}
} 
else {
CLRpvalue=1-pchisq(clrstat,k)	
}
list(CLRpvalue=CLRpvalue)
} 


ARCI<-function(MAT,OMEGA,k=1,alpha=0.05){
	MATAR = MAT-qchisq((1-alpha),k)*OMEGA
	DMATAR = -det(MATAR) 
	MATAR12 = MATAR[1,2] 
	MATAR22 = MATAR[2,2] 
	x1=NA
	x2=NA
	if (MATAR22<0){
  		if (DMATAR<0){type_AR = 3}
  		else{ type_AR = 4
        	x1 = (MATAR12 + sqrt(DMATAR))/MATAR22
        	x2 = (MATAR12 - sqrt(DMATAR))/MATAR22
  		}
	}
	else {
  		if (DMATAR<0) { type_AR=1}
  		else{ type_AR =2
        	x1= (MATAR12-sqrt(DMATAR))/MATAR22
        	x2= (MATAR12+sqrt(DMATAR))/MATAR22        
  		}
	}
list(type_AR=type_AR,set_AR=c(x1,x2))	
}



KCI<-function(MAT,OMEGA,M,N,k=1,alpha=0.05){
  MATK = solve(OMEGA)%*%MAT%*%solve(OMEGA)-(M-qchisq((1-alpha),1))*solve(OMEGA)
  DMATK = -4*det(MATK) 
  MATK11 = MATK[1,1] 
  MATK12 = MATK[1,2] 
  y1=(-2*MATK12+sqrt(DMATK))/2/MATK11
  y2=(-2*MATK12-sqrt(DMATK))/2/MATK11
  K_x1=NA
  K_x2=NA
  K_x3=NA
  K_x4=NA
  if (k==1){
    if (MATK11>0){
      if (DMATK>0){type_K = 4
                   K_x1 = y2
                   K_x2 = y1
      }
      else{type_K = 3}
    }
    
    else {
      if (DMATK>0){type_K = 2
                   K_x1 = y1
                   K_x2 = y2    
      }
      else{type_K = 3}
    }
  }  
  else {
    if ((M + N - qchisq((1-alpha),1))^2-4*M*N<0) { 
      type_K = 3
    }
    else {
      q1 = (M + N - qchisq((1-alpha),1) -  sqrt((M+N - qchisq((1-alpha),1))^2 -  4*M*N))/2
      q2 = (M + N - qchisq((1-alpha),1) +  sqrt((M+N - qchisq((1-alpha),1))^2 -  4*M*N))/2
      if ((q1 < N) | (q2 > M)) {
        type_K = 3
      }
      
      else {           
        MATK1 = solve(OMEGA)%*%MAT%*%solve(OMEGA)-q1*solve(OMEGA)
        MATK2 = solve(OMEGA)%*%MAT%*%solve(OMEGA)-q2*solve(OMEGA)
        DMATK1 = -4*det(MATK1)
        DMATK2 = -4*det(MATK2)
        if (MATK1[1,1]>0) { 
          if (MATK2[1,1]>0) { 
            type_K = 5
            y1 = (-2*MATK1[1,2] + sqrt(DMATK1))/2/MATK1[1,1]
            y2 = (-2*MATK1[1,2] - sqrt(DMATK1))/2/MATK1[1,1]
            y3 = (-2*MATK2[1,2] + sqrt(DMATK2))/2/MATK2[1,1]
            y4 = (-2*MATK2[1,2] - sqrt(DMATK2))/2/MATK2[1,1]
            K_x1 = y4
            K_x2 = y2
            K_x3 = y1
            K_x4 = y3
          }
          else {
            type_K = 6
            y1 = (-2*MATK1[1,2] + sqrt(DMATK1))/2/MATK1[1,1]
            y2 = (-2*MATK1[1,2] - sqrt(DMATK1))/2/MATK1[1,1]
            y3 = (-2*MATK2[1,2] + sqrt(DMATK2))/2/MATK2[1,1]
            y4 = (-2*MATK2[1,2] - sqrt(DMATK2))/2/MATK2[1,1]
            K_x1 = y3
            K_x2 = y4
            K_x3 = y2
            K_x4 = y1
          }
        }
        if (MATK1[1,1]<=0) {
          type_K = 5
          y1 = (-2*MATK1[1,2] + sqrt(DMATK1))/2/MATK1[1,1]
          y2 = (-2*MATK1[1,2] - sqrt(DMATK1))/2/MATK1[1,1]
          y3 = (-2*MATK2[1,2] + sqrt(DMATK2))/2/MATK2[1,1]
          y4 = (-2*MATK2[1,2] - sqrt(DMATK2))/2/MATK2[1,1]
          K_x1 = y1
          K_x2 = y3
          K_x3 = y4
          K_x4 = y2
        }
      }
    }
  }
  list(type_K=type_K,set_K=c(K_x1,K_x2,K_x3,K_x4))  
}




CLRCI<-function(MAT,OMEGA,M,k=1,alpha=0.05,eps=10^-8){
		# Find C where C is a solution to the equation p(M-C;C)=alpha (prog def inversefun)
	aa=eps
	bb=M-eps
	fa=CLRpvaluefunc(bb, aa, k)
	fb=CLRpvaluefunc(aa, bb, k)
	if(fa > alpha) { C = aa }
    else  if (fb < alpha) {C = bb}
    else {
   		while (bb-aa>eps) {
   			xx = (bb-aa)/2+aa
            fx=CLRpvaluefunc(M- xx, xx, k) 
            if (fx >alpha) {bb = xx}
            else {aa = xx}                                
        }
        C = xx
    }
	MATCLR = solve(OMEGA)%*%MAT%*%solve(OMEGA)-C*solve(OMEGA)
	DMATCLR = -det(MATCLR) 
	MATCLR11 = MATCLR[1,1] 
	MATCLR12 = MATCLR[1,2] 
	xx1=NA
	xx2=NA
if (MATCLR11<0){
  if (DMATCLR<0){type_CLR = 1}
  else{ type_CLR = 2
        xx1 = (-MATCLR12 + sqrt(DMATCLR))/MATCLR11
        xx2 = (-MATCLR12 - sqrt(DMATCLR))/MATCLR11
  }
}
else{
  if (DMATCLR<0) {type_CLR=3}
  else{ type_CLR =4
        xx1 = (-MATCLR12 - sqrt(DMATCLR))/MATCLR11
        xx2 = (-MATCLR12 + sqrt(DMATCLR))/MATCLR11     
  }
}
list(type_CLR=type_CLR,set_CLR=c(xx1,xx2))
}



Test_Equal_Moment<-function(x1,x2,z1,z2){
  
  n1 <- matrix(nrow(x1),nrow=ncol(z1),ncol=1)
  n2 <- matrix(nrow(x2),nrow=ncol(z1),ncol=1)
  n1z <- matrix(NA,nrow=ncol(z1),ncol=1)
  n2z <- matrix(NA,nrow=ncol(z1),ncol=1)
  row <- matrix(1,nrow=ncol(z1),ncol=1)
  col <- matrix(5,nrow=ncol(z1),ncol=1)
  p <- matrix(NA,nrow=ncol(z1),ncol=1)
  q <- matrix(NA,nrow=ncol(z1),ncol=1)
  
  for (g in 1:ncol(z1)){
    n1z[g] <- sum(z1[,g])
    n2z[g] <- sum(z2[,g])
    p[g] <- (n1z[g] + n2z[g]) / (n1[g]+n2[g])
    q[g] <- ((n1z[g] - n1[g]*p[g])^2) / (n1[g]*p[g]) + ((n2z[g] - n2[g]*p[g])^2) / (n2[g]*p[g])
  }
  
  Qstat <- sum(q)

  list(Qstat=Qstat)
  
}